#!/usr/bin/env python
# -*- coding: utf-8 -*-

import unittest

from colored.exceptions import (InvalidColor, InvalidControl, InvalidHexColor,
                                InvalidStyle)


class TestInvalid(unittest.TestCase):

    """Test for the Exceptions.
    """

    def test_exception_raised_invalidcolor(self) -> None:
        """Test that the exception is raised correctly."""
        with self.assertRaises(InvalidColor) as context:
            raise InvalidColor("InvalidColor: red_90")

        # Check that the error message is correct.
        self.assertEqual(str(context.exception), "InvalidColor: red_90")

    def test_exception_message_invalidcolor(self) -> None:
        """Test the exception message directly."""
        exception = InvalidColor("InvalidColor: red_90")
        self.assertEqual(str(exception), "InvalidColor: red_90")

    def test_exception_inheritance_invalidcolor(self) -> None:
        """Test that InvalidColor inherits from Exception."""
        exception = InvalidColor("Test message")
        self.assertIsInstance(exception, Exception)

    def test_exception_raised_invalidhexcolor(self) -> None:
        """Test that the exception is raised correctly."""
        with self.assertRaises(InvalidHexColor) as context:
            raise InvalidHexColor("InvalidHexColor: #005fdj")

        # Check that the error message is correct.
        self.assertEqual(str(context.exception), "InvalidHexColor: #005fdj")

    def test_exception_message_invalidhexcolor(self) -> None:
        """Test the exception message directly."""
        exception = InvalidHexColor("InvalidHexColor: blue_15")
        self.assertEqual(str(exception), "InvalidHexColor: blue_15")

    def test_exception_inheritance_invalidhexcolor(self) -> None:
        """Test that InvalidHexColor inherits from Exception."""
        exception = InvalidHexColor("Test message")
        self.assertIsInstance(exception, Exception)

    def test_exception_raised_invalidcontrol(self) -> None:
        """Test that the exception is raised correctly."""
        with self.assertRaises(InvalidControl) as context:
            raise InvalidControl("InvalidControl: upper")

        # Check that the error message is correct.
        self.assertEqual(str(context.exception), "InvalidControl: upper")

    def test_exception_message_invalidcontrol(self) -> None:
        """Test the exception message directly."""
        exception = InvalidControl("InvalidControl: righting")
        self.assertEqual(str(exception), "InvalidControl: righting")

    def test_exception_inheritance_invalidcontrol(self) -> None:
        """Test that InvalidControl inherits from Exception."""
        exception = InvalidControl("Test message")
        self.assertIsInstance(exception, Exception)

    def test_exception_raised_invalidstyle(self) -> None:
        """Test that the exception is raised correctly."""
        with self.assertRaises(InvalidStyle) as context:
            raise InvalidStyle("InvalidStyle: bolb")

        # Check that the error message is correct.
        self.assertEqual(str(context.exception), "InvalidStyle: bolb")

    def test_exception_message_invalidstyle(self) -> None:
        """Test the exception message directly."""
        exception = InvalidStyle("InvalidStyle: bolb")
        self.assertEqual(str(exception), "InvalidStyle: bolb")

    def test_exception_inheritance_invalidstyle(self) -> None:
        """Test that InvalidStyle inherits from Exception."""
        exception = InvalidStyle("Test message")
        self.assertIsInstance(exception, Exception)


if __name__ == '__main__':
    unittest.main()
