import unittest

from colored.attributes import Style
from colored.colored import Colored
from colored.library import Library

# pylint: disable=invalid-name


class TestStyles(unittest.TestCase):

    """Test for styles attributes names and codes.
    """

    def setUp(self) -> None:
        self.ESC: str = '\x1b['
        self.END: str = 'm'
        self.UNDERLINE_COLOR: str = f'{self.ESC}4;58;5;'

    def test_style_code(self) -> None:
        """Test styles attributes by code.
        """
        for code in Library.STYLES.values():
            style = Colored(code)
            self.assertEqual(f'{self.ESC}{code}{self.END}', style.attribute())

    def test_style_name(self) -> None:
        """Test styles attributes by name.
        """
        for name, code in Library.STYLES.items():
            style = Colored(name)
            self.assertEqual(f'{self.ESC}{code}{self.END}', style.attribute())

    def test_underline_color(self) -> None:
        """Test underline attribute.
        """
        for code in Library.COLORS.values():
            self.assertEqual(f'{self.UNDERLINE_COLOR}{code}{self.END}', Style.underline_color(color=code))


if __name__ == '__main__':
    unittest.main()
