/* Copyright (c) 2017-2022 Hans-Kristian Arntzen
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#pragma once

#include "vulkan_headers.hpp"
#include <unordered_set>
#include <vector>

namespace Vulkan
{
class Device;
class CommandPool
{
public:
	CommandPool(Device *device, uint32_t queue_family_index);
	~CommandPool();

	CommandPool(CommandPool &&) noexcept;
	CommandPool &operator=(CommandPool &&) noexcept;
	CommandPool(const CommandPool &) = delete;
	void operator=(const CommandPool &) = delete;

	void begin();
	void trim();
	VkCommandBuffer request_command_buffer();
	VkCommandBuffer request_secondary_command_buffer();
	void signal_submitted(VkCommandBuffer cmd);

private:
	Device *device;
	const VolkDeviceTable *table;
	VkCommandPool pool = VK_NULL_HANDLE;
	std::vector<VkCommandBuffer> buffers;
	std::vector<VkCommandBuffer> secondary_buffers;
#ifdef VULKAN_DEBUG
	std::unordered_set<VkCommandBuffer> in_flight;
#endif
	unsigned index = 0;
	unsigned secondary_index = 0;
};
}
