/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLProtocolException;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.DHKeyExchange;
import sun.security.ssl.ECDHKeyExchange;
import sun.security.ssl.HandshakeAbsence;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.Record;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLKeyExchange;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.SSLStringizer;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SupportedGroupsExtension;
import sun.security.ssl.Utilities;

final class KeyShareExtension {
    static final HandshakeProducer chNetworkProducer = new CHKeyShareProducer();
    static final SSLExtension.ExtensionConsumer chOnLoadConsumer = new CHKeyShareConsumer();
    static final HandshakeAbsence chOnTradAbsence = new CHKeyShareOnTradeAbsence();
    static final SSLStringizer chStringizer = new CHKeyShareStringizer();
    static final HandshakeProducer shNetworkProducer = new SHKeyShareProducer();
    static final SSLExtension.ExtensionConsumer shOnLoadConsumer = new SHKeyShareConsumer();
    static final HandshakeAbsence shOnLoadAbsence = new SHKeyShareAbsence();
    static final SSLStringizer shStringizer = new SHKeyShareStringizer();
    static final HandshakeProducer hrrNetworkProducer = new HRRKeyShareProducer();
    static final SSLExtension.ExtensionConsumer hrrOnLoadConsumer = new HRRKeyShareConsumer();
    static final HandshakeProducer hrrNetworkReproducer = new HRRKeyShareReproducer();
    static final SSLStringizer hrrStringizer = new HRRKeyShareStringizer();

    KeyShareExtension() {
    }

    private static final class HRRKeyShareConsumer
    implements SSLExtension.ExtensionConsumer {
        private HRRKeyShareConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            HRRKeyShareSpec hRRKeyShareSpec;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.HRR_KEY_SHARE)) {
                throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unsupported key_share extension in HelloRetryRequest");
            }
            if (clientHandshakeContext.clientRequestedNamedGroups == null || clientHandshakeContext.clientRequestedNamedGroups.isEmpty()) {
                throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected key_share extension in HelloRetryRequest");
            }
            try {
                hRRKeyShareSpec = new HRRKeyShareSpec(byteBuffer);
            }
            catch (IOException iOException) {
                throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
            }
            SupportedGroupsExtension.NamedGroup namedGroup = SupportedGroupsExtension.NamedGroup.valueOf(hRRKeyShareSpec.selectedGroup);
            if (namedGroup == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unsupported HelloRetryRequest selected group: " + SupportedGroupsExtension.NamedGroup.nameOf(hRRKeyShareSpec.selectedGroup));
            }
            if (!clientHandshakeContext.clientRequestedNamedGroups.contains((Object)namedGroup)) {
                throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected HelloRetryRequest selected group: " + namedGroup.name);
            }
            clientHandshakeContext.serverSelectedNamedGroup = namedGroup;
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.HRR_KEY_SHARE, hRRKeyShareSpec);
        }
    }

    private static final class HRRKeyShareReproducer
    implements HandshakeProducer {
        private HRRKeyShareReproducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.HRR_KEY_SHARE)) {
                throw serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unsupported key_share extension in HelloRetryRequest");
            }
            CHKeyShareSpec cHKeyShareSpec = (CHKeyShareSpec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.CH_KEY_SHARE);
            if (cHKeyShareSpec != null && cHKeyShareSpec.clientShares != null && cHKeyShareSpec.clientShares.size() == 1) {
                int n = cHKeyShareSpec.clientShares.get((int)0).namedGroupId;
                byte[] byArray = new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
                return byArray;
            }
            return null;
        }
    }

    private static final class HRRKeyShareProducer
    implements HandshakeProducer {
        private HRRKeyShareProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.HRR_KEY_SHARE)) {
                throw serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unsupported key_share extension in HelloRetryRequest");
            }
            if (serverHandshakeContext.clientRequestedNamedGroups == null || serverHandshakeContext.clientRequestedNamedGroups.isEmpty()) {
                throw serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected key_share extension in HelloRetryRequest");
            }
            SupportedGroupsExtension.NamedGroup namedGroup = null;
            for (SupportedGroupsExtension.NamedGroup namedGroup2 : serverHandshakeContext.clientRequestedNamedGroups) {
                if (!SupportedGroupsExtension.SupportedGroups.isActivatable(serverHandshakeContext.algorithmConstraints, namedGroup2)) continue;
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("HelloRetryRequest selected named group: " + namedGroup2.name, new Object[0]);
                }
                namedGroup = namedGroup2;
                break;
            }
            if (namedGroup == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "No common named group");
            }
            Object object = new byte[]{(byte)(namedGroup.id >> 8 & 0xFF), (byte)(namedGroup.id & 0xFF)};
            serverHandshakeContext.serverSelectedNamedGroup = namedGroup;
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.HRR_KEY_SHARE, new HRRKeyShareSpec(namedGroup));
            return object;
        }
    }

    private static final class HRRKeyShareStringizer
    implements SSLStringizer {
        private HRRKeyShareStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new HRRKeyShareSpec(byteBuffer).toString();
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
    }

    static final class HRRKeyShareSpec
    implements SSLExtension.SSLExtensionSpec {
        final int selectedGroup;

        HRRKeyShareSpec(SupportedGroupsExtension.NamedGroup namedGroup) {
            this.selectedGroup = namedGroup.id;
        }

        private HRRKeyShareSpec(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.remaining() != 2) {
                throw new SSLProtocolException("Invalid key_share extension: improper data (length=" + byteBuffer.remaining() + ")");
            }
            this.selectedGroup = Record.getInt16(byteBuffer);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"selected group\": '['{0}']'", Locale.ENGLISH);
            Object[] objectArray = new Object[]{SupportedGroupsExtension.NamedGroup.nameOf(this.selectedGroup)};
            return messageFormat.format(objectArray);
        }
    }

    private static final class SHKeyShareAbsence
    implements HandshakeAbsence {
        private SHKeyShareAbsence() {
        }

        @Override
        public void absent(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (SSLLogger.isOn && SSLLogger.isOn("handshake")) {
                SSLLogger.fine("No key_share extension in ServerHello, cleanup the key shares if necessary", new Object[0]);
            }
            clientHandshakeContext.handshakePossessions.clear();
        }
    }

    private static final class SHKeyShareConsumer
    implements SSLExtension.ExtensionConsumer {
        private SHKeyShareConsumer() {
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public void consume(ConnectionContext var1_1, SSLHandshake.HandshakeMessage var2_2, ByteBuffer var3_3) throws IOException {
            var4_4 = (ClientHandshakeContext)var1_1;
            if (var4_4.clientRequestedNamedGroups == null || var4_4.clientRequestedNamedGroups.isEmpty()) {
                throw var4_4.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected key_share extension in ServerHello");
            }
            if (!var4_4.sslConfig.isAvailable(SSLExtension.SH_KEY_SHARE)) {
                throw var4_4.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unsupported key_share extension in ServerHello");
            }
            try {
                var5_5 = new SHKeyShareSpec(var3_3);
            }
            catch (IOException var6_6) {
                throw var4_4.conContext.fatal(Alert.UNEXPECTED_MESSAGE, var6_6);
            }
            var6_7 = var5_5.serverShare;
            var7_8 = SupportedGroupsExtension.NamedGroup.valueOf(var6_7.namedGroupId);
            if (var7_8 == null || !SupportedGroupsExtension.SupportedGroups.isActivatable(var4_4.algorithmConstraints, var7_8)) {
                throw var4_4.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unsupported named group: " + SupportedGroupsExtension.NamedGroup.nameOf(var6_7.namedGroupId));
            }
            var8_9 = SSLKeyExchange.valueOf(var7_8);
            if (var8_9 == null) {
                throw var4_4.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "No key exchange for named group " + var7_8.name);
            }
            var9_10 /* !! */  = null;
            if (var7_8.type == SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_ECDHE) {
                try {
                    var10_11 = ECDHKeyExchange.ECDHECredentials.valueOf(var7_8, var6_7.keyExchange);
                    if (var10_11 == null) ** GOTO lbl40
                    if (var4_4.algorithmConstraints != null && !var4_4.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), var10_11.popPublicKey)) {
                        throw var4_4.conContext.fatal(Alert.INSUFFICIENT_SECURITY, "ECDHE key share entry does not comply to algorithm constraints");
                    }
                    var9_10 /* !! */  = var10_11;
                }
                catch (IOException | GeneralSecurityException var10_12) {
                    throw var4_4.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Cannot decode named group: " + SupportedGroupsExtension.NamedGroup.nameOf(var6_7.namedGroupId));
                }
            } else if (var7_8.type == SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_FFDHE) {
                try {
                    var10_13 = DHKeyExchange.DHECredentials.valueOf(var7_8, var6_7.keyExchange);
                    if (var10_13 == null) ** GOTO lbl40
                    if (var4_4.algorithmConstraints != null && !var4_4.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), var10_13.popPublicKey)) {
                        throw var4_4.conContext.fatal(Alert.INSUFFICIENT_SECURITY, "DHE key share entry does not comply to algorithm constraints");
                    }
                    var9_10 /* !! */  = var10_13;
                }
                catch (IOException | GeneralSecurityException var10_14) {
                    throw var4_4.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Cannot decode named group: " + SupportedGroupsExtension.NamedGroup.nameOf(var6_7.namedGroupId));
                }
            } else {
                throw var4_4.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unsupported named group: " + SupportedGroupsExtension.NamedGroup.nameOf(var6_7.namedGroupId));
            }
lbl40:
            // 4 sources

            if (var9_10 /* !! */  == null) {
                throw var4_4.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unsupported named group: " + var7_8.name);
            }
            var4_4.handshakeKeyExchange = var8_9;
            var4_4.handshakeCredentials.add(var9_10 /* !! */ );
            var4_4.handshakeExtensions.put(SSLExtension.SH_KEY_SHARE, var5_5);
        }
    }

    private static final class SHKeyShareProducer
    implements HandshakeProducer {
        private SHKeyShareProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            Object object22;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            CHKeyShareSpec cHKeyShareSpec = (CHKeyShareSpec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.CH_KEY_SHARE);
            if (cHKeyShareSpec == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("Ignore, no client key_share extension", new Object[0]);
                }
                return null;
            }
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.SH_KEY_SHARE)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("Ignore, no available server key_share extension", new Object[0]);
                }
                return null;
            }
            if (serverHandshakeContext.handshakeCredentials == null || serverHandshakeContext.handshakeCredentials.isEmpty()) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("No available client key share entries", new Object[0]);
                }
                return null;
            }
            KeyShareEntry keyShareEntry = null;
            for (Object object22 : serverHandshakeContext.handshakeCredentials) {
                SupportedGroupsExtension.NamedGroup namedGroup = null;
                if (object22 instanceof ECDHKeyExchange.ECDHECredentials) {
                    namedGroup = ((ECDHKeyExchange.ECDHECredentials)object22).namedGroup;
                } else if (object22 instanceof DHKeyExchange.DHECredentials) {
                    namedGroup = ((DHKeyExchange.DHECredentials)object22).namedGroup;
                }
                if (namedGroup == null) continue;
                SSLKeyExchange sSLKeyExchange = SSLKeyExchange.valueOf(namedGroup);
                if (sSLKeyExchange == null) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                    SSLLogger.warning("No key exchange for named group " + namedGroup.name, new Object[0]);
                    continue;
                }
                SSLPossession[] sSLPossessionArray = sSLKeyExchange.createPossessions(serverHandshakeContext);
                for (SSLPossession object3 : sSLPossessionArray) {
                    if (!(object3 instanceof ECDHKeyExchange.ECDHEPossession) && !(object3 instanceof DHKeyExchange.DHEPossession)) continue;
                    serverHandshakeContext.handshakeKeyExchange = sSLKeyExchange;
                    serverHandshakeContext.handshakePossessions.add(object3);
                    keyShareEntry = new KeyShareEntry(namedGroup.id, object3.encode());
                    break;
                }
                if (keyShareEntry == null) continue;
                for (Map.Entry<Byte, HandshakeProducer> entry : sSLKeyExchange.getHandshakeProducers(serverHandshakeContext)) {
                    serverHandshakeContext.handshakeProducers.put(entry.getKey(), entry.getValue());
                }
            }
            if (keyShareEntry == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("No available server key_share extension", new Object[0]);
                }
                return null;
            }
            Object object4 = keyShareEntry.getEncoded();
            object22 = new SHKeyShareSpec(keyShareEntry);
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.SH_KEY_SHARE, object22);
            return object4;
        }
    }

    private static final class SHKeyShareStringizer
    implements SSLStringizer {
        private SHKeyShareStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new SHKeyShareSpec(byteBuffer).toString();
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
    }

    static final class SHKeyShareSpec
    implements SSLExtension.SSLExtensionSpec {
        final KeyShareEntry serverShare;

        SHKeyShareSpec(KeyShareEntry keyShareEntry) {
            this.serverShare = keyShareEntry;
        }

        private SHKeyShareSpec(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.remaining() < 5) {
                throw new SSLProtocolException("Invalid key_share extension: insufficient data (length=" + byteBuffer.remaining() + ")");
            }
            int n = Record.getInt16(byteBuffer);
            byte[] byArray = Record.getBytes16(byteBuffer);
            if (byteBuffer.hasRemaining()) {
                throw new SSLProtocolException("Invalid key_share extension: unknown extra data");
            }
            this.serverShare = new KeyShareEntry(n, byArray);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"server_share\": '{'\n  \"named group\": {0}\n  \"key_exchange\": '{'\n{1}\n  '}'\n'}',", Locale.ENGLISH);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            Object[] objectArray = new Object[]{SupportedGroupsExtension.NamedGroup.nameOf(this.serverShare.namedGroupId), Utilities.indent(hexDumpEncoder.encode(this.serverShare.keyExchange), "    ")};
            return messageFormat.format(objectArray);
        }
    }

    private static final class CHKeyShareOnTradeAbsence
    implements HandshakeAbsence {
        private CHKeyShareOnTradeAbsence() {
        }

        @Override
        public void absent(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (serverHandshakeContext.negotiatedProtocol.useTLS13PlusSpec() && serverHandshakeContext.handshakeExtensions.containsKey(SSLExtension.CH_SUPPORTED_GROUPS)) {
                throw serverHandshakeContext.conContext.fatal(Alert.MISSING_EXTENSION, "No key_share extension to work with the supported_groups extension");
            }
        }
    }

    private static final class CHKeyShareConsumer
    implements SSLExtension.ExtensionConsumer {
        private CHKeyShareConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            CHKeyShareSpec cHKeyShareSpec;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (serverHandshakeContext.handshakeExtensions.containsKey(SSLExtension.CH_KEY_SHARE)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("The key_share extension has been loaded", new Object[0]);
                }
                return;
            }
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_KEY_SHARE)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable key_share extension", new Object[0]);
                }
                return;
            }
            try {
                cHKeyShareSpec = new CHKeyShareSpec(byteBuffer);
            }
            catch (IOException iOException) {
                throw serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
            }
            LinkedList<ECDHKeyExchange.ECDHECredentials> linkedList = new LinkedList<ECDHKeyExchange.ECDHECredentials>();
            for (KeyShareEntry keyShareEntry : cHKeyShareSpec.clientShares) {
                SSLCredentials sSLCredentials;
                SupportedGroupsExtension.NamedGroup namedGroup = SupportedGroupsExtension.NamedGroup.valueOf(keyShareEntry.namedGroupId);
                if (namedGroup == null || !SupportedGroupsExtension.SupportedGroups.isActivatable(serverHandshakeContext.algorithmConstraints, namedGroup)) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                    SSLLogger.fine("Ignore unsupported named group: " + SupportedGroupsExtension.NamedGroup.nameOf(keyShareEntry.namedGroupId), new Object[0]);
                    continue;
                }
                if (namedGroup.type == SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_ECDHE) {
                    try {
                        sSLCredentials = ECDHKeyExchange.ECDHECredentials.valueOf(namedGroup, keyShareEntry.keyExchange);
                        if (sSLCredentials == null) continue;
                        if (serverHandshakeContext.algorithmConstraints != null && !serverHandshakeContext.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), sSLCredentials.popPublicKey)) {
                            if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                            SSLLogger.warning("ECDHE key share entry does not comply to algorithm constraints", new Object[0]);
                            continue;
                        }
                        linkedList.add((ECDHKeyExchange.ECDHECredentials)sSLCredentials);
                    }
                    catch (IOException | GeneralSecurityException exception) {
                        if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                        SSLLogger.warning("Cannot decode named group: " + SupportedGroupsExtension.NamedGroup.nameOf(keyShareEntry.namedGroupId), new Object[0]);
                    }
                    continue;
                }
                if (namedGroup.type != SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_FFDHE) continue;
                try {
                    sSLCredentials = DHKeyExchange.DHECredentials.valueOf(namedGroup, keyShareEntry.keyExchange);
                    if (sSLCredentials == null) continue;
                    if (serverHandshakeContext.algorithmConstraints != null && !serverHandshakeContext.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), ((DHKeyExchange.DHECredentials)sSLCredentials).popPublicKey)) {
                        if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                        SSLLogger.warning("DHE key share entry does not comply to algorithm constraints", new Object[0]);
                        continue;
                    }
                    linkedList.add((ECDHKeyExchange.ECDHECredentials)sSLCredentials);
                }
                catch (IOException | GeneralSecurityException exception) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                    SSLLogger.warning("Cannot decode named group: " + SupportedGroupsExtension.NamedGroup.nameOf(keyShareEntry.namedGroupId), new Object[0]);
                }
            }
            if (!linkedList.isEmpty()) {
                serverHandshakeContext.handshakeCredentials.addAll(linkedList);
            } else {
                serverHandshakeContext.handshakeProducers.put(SSLHandshake.HELLO_RETRY_REQUEST.id, SSLHandshake.HELLO_RETRY_REQUEST);
            }
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.CH_KEY_SHARE, cHKeyShareSpec);
        }
    }

    private static final class CHKeyShareProducer
    implements HandshakeProducer {
        private CHKeyShareProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            Object object222;
            List<SupportedGroupsExtension.NamedGroup> list;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_KEY_SHARE)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable key_share extension", new Object[0]);
                }
                return null;
            }
            if (clientHandshakeContext.serverSelectedNamedGroup != null) {
                list = Arrays.asList(clientHandshakeContext.serverSelectedNamedGroup);
            } else {
                list = clientHandshakeContext.clientRequestedNamedGroups;
                if (list == null || list.isEmpty()) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.warning("Ignore key_share extension, no supported groups", new Object[0]);
                    }
                    return null;
                }
            }
            LinkedList<KeyShareEntry> linkedList = new LinkedList<KeyShareEntry>();
            for (Object object222 : list) {
                SSLKeyExchange object3 = SSLKeyExchange.valueOf(object222);
                if (object3 == null) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                    SSLLogger.warning("No key exchange for named group " + object222.name, new Object[0]);
                    continue;
                }
                SSLPossession[] sSLPossessionArray = object3.createPossessions(clientHandshakeContext);
                for (SSLPossession sSLPossession : sSLPossessionArray) {
                    clientHandshakeContext.handshakePossessions.add(sSLPossession);
                    if (!(sSLPossession instanceof ECDHKeyExchange.ECDHEPossession) && !(sSLPossession instanceof DHKeyExchange.DHEPossession)) continue;
                    linkedList.add(new KeyShareEntry(object222.id, sSLPossession.encode()));
                }
                if (linkedList.isEmpty()) continue;
                break;
            }
            int n = 0;
            for (KeyShareEntry keyShareEntry : linkedList) {
                n += keyShareEntry.getEncodedSize();
            }
            object222 = new byte[n + 2];
            ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])object222);
            Record.putInt16(byteBuffer, n);
            for (KeyShareEntry keyShareEntry : linkedList) {
                byteBuffer.put(keyShareEntry.getEncoded());
            }
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.CH_KEY_SHARE, new CHKeyShareSpec(linkedList));
            return object222;
        }
    }

    private static final class CHKeyShareStringizer
    implements SSLStringizer {
        private CHKeyShareStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new CHKeyShareSpec(byteBuffer).toString();
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
    }

    static final class CHKeyShareSpec
    implements SSLExtension.SSLExtensionSpec {
        final List<KeyShareEntry> clientShares;

        private CHKeyShareSpec(List<KeyShareEntry> list) {
            this.clientShares = list;
        }

        private CHKeyShareSpec(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.remaining() < 2) {
                throw new SSLProtocolException("Invalid key_share extension: insufficient data (length=" + byteBuffer.remaining() + ")");
            }
            int n = Record.getInt16(byteBuffer);
            if (n != byteBuffer.remaining()) {
                throw new SSLProtocolException("Invalid key_share extension: incorrect list length (length=" + n + ")");
            }
            LinkedList<KeyShareEntry> linkedList = new LinkedList<KeyShareEntry>();
            while (byteBuffer.hasRemaining()) {
                int n2 = Record.getInt16(byteBuffer);
                byte[] byArray = Record.getBytes16(byteBuffer);
                if (byArray.length == 0) {
                    throw new SSLProtocolException("Invalid key_share extension: empty key_exchange");
                }
                linkedList.add(new KeyShareEntry(n2, byArray));
            }
            this.clientShares = Collections.unmodifiableList(linkedList);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"client_shares\": '['{0}\n']'", Locale.ENGLISH);
            StringBuilder stringBuilder = new StringBuilder(512);
            for (KeyShareEntry keyShareEntry : this.clientShares) {
                stringBuilder.append(keyShareEntry.toString());
            }
            Object[] objectArray = new Object[]{Utilities.indent(stringBuilder.toString())};
            return messageFormat.format(objectArray);
        }
    }

    private static final class KeyShareEntry {
        final int namedGroupId;
        final byte[] keyExchange;

        private KeyShareEntry(int n, byte[] byArray) {
            this.namedGroupId = n;
            this.keyExchange = byArray;
        }

        private byte[] getEncoded() {
            byte[] byArray;
            block2: {
                byArray = new byte[this.keyExchange.length + 4];
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                try {
                    Record.putInt16(byteBuffer, this.namedGroupId);
                    Record.putBytes16(byteBuffer, this.keyExchange);
                }
                catch (IOException iOException) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) break block2;
                    SSLLogger.warning("Unlikely IOException", iOException);
                }
            }
            return byArray;
        }

        private int getEncodedSize() {
            return this.keyExchange.length + 4;
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\n'{'\n  \"named group\": {0}\n  \"key_exchange\": '{'\n{1}\n  '}'\n'}',", Locale.ENGLISH);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            Object[] objectArray = new Object[]{SupportedGroupsExtension.NamedGroup.nameOf(this.namedGroupId), Utilities.indent(hexDumpEncoder.encode(this.keyExchange), "    ")};
            return messageFormat.format(objectArray);
        }
    }
}

