/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.rework.jars;

import com.azul.crs.client.Tweaks;
import com.azul.crs.client.rework.jars.JarAccess;
import com.azul.crs.client.rework.jars.JarCache;
import com.azul.crs.client.rework.jars.JarSource;
import com.azul.crs.client.rework.jars.utils.Utils;
import com.azul.crs.jar.ZipTools;
import com.azul.crs.runtime.utils.URLHelper;
import com.azul.crs.util.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarFile;

public class JarAccessFactory {
    final Logger logger = Logger.getLogger(this.getClass());
    private final JarCache cache;
    private final ZipTools zt;
    private final MessageDigest digest;

    public JarAccessFactory(int n, ZipTools zipTools, MessageDigest messageDigest) {
        this.cache = new JarCache(n);
        this.zt = zipTools;
        this.digest = messageDigest;
    }

    public boolean hardstop() {
        return false;
    }

    public boolean isKnown(JarAccess jarAccess) {
        return this.cache.isKnown(jarAccess);
    }

    public JarCache getCache() {
        return this.cache;
    }

    private JarAccess create(JarFile jarFile, JarSource jarSource, JarAccess.InitiatedBy initiatedBy) {
        String string;
        URL uRL = jarSource.getUrl();
        String string2 = uRL.toString();
        String string3 = string = jarFile != null ? jarFile.getName() : null;
        if (Tweaks.DEBUG_JARLOAD) {
            this.logger.trace("create jarAccess from: (jar=%s, url=%s, path=%s, source=%s, initiatedBy=%s)", new Object[]{Utils.toStringWithIdentityHash(jarFile), uRL, string, string2, initiatedBy});
        }
        if (this.cache.isPathKnown(string) || this.cache.isURLKnown(uRL) || this.cache.isSourceKnown(string2)) {
            this.logger.trace("Skip already known JAR reporting: %s (path: %s, source: %s, jar: %s)", uRL, string, string2, Utils.toStringWithIdentityHash(jarFile));
            return null;
        }
        try {
            if (!ZipTools.isJDKNative(jarFile)) {
                string = URLHelper.extractContainerPathFromURL(uRL.toString()).replaceAll("!/.*$", "");
                uRL = new URL("jar:file:" + string + "!/");
                string2 = uRL.toString();
                jarFile = new JarFile(string, false);
                JarSource jarSource2 = new JarSource.Builder().fromUrl(uRL).build();
                if (jarSource2 != null) {
                    return this.create(jarFile, jarSource2, initiatedBy);
                }
                throw new RuntimeException("Failed creating jarAccess jar=" + Utils.toStringWithIdentityHash(jarFile) + ", url=" + uRL + ", source=" + string2 + ", path=" + string);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed creating jarAccess jar=" + Utils.toStringWithIdentityHash(jarFile) + ", url=" + uRL + ", source=" + string2 + ", path=" + string, exception);
        }
        if (Tweaks.DEBUG_JARLOAD) {
            this.logger.trace("before creating jarAccess: %s, %s, %s, %s, %s", new Object[]{this, Utils.toStringWithIdentityHash(jarFile), uRL, string, string2, initiatedBy});
        }
        JarAccess jarAccess = new JarAccess(this, jarFile, jarSource, string, initiatedBy);
        this.cache.put(jarAccess);
        if (Tweaks.DEBUG_JARLOAD) {
            this.logger.trace("created jarAccess: %s", jarAccess);
        }
        return jarAccess;
    }

    private JarAccess createSafe(JarFile jarFile, JarSource jarSource, JarAccess.InitiatedBy initiatedBy) {
        URL uRL = jarSource.getUrl();
        if (uRL == null) {
            throw new RuntimeException("URL in JarSource can not be null");
        }
        jarFile = jarFile != null ? jarFile : this.getJar(uRL);
        return this.create(jarFile, jarSource, initiatedBy);
    }

    private JarFile getJar(URL uRL) {
        try {
            return ((JarURLConnection)uRL.openConnection()).getJarFile();
        }
        catch (Exception exception) {
            this.logger.debug("Failed to get jar file by url='%s', e='%s'", uRL, exception);
            return null;
        }
    }

    public synchronized JarAccess create(JarSource jarSource, JarFile jarFile) {
        return this.createSafe(jarFile, jarSource, ZipTools.isJDKNative(jarFile) ? JarAccess.InitiatedBy.JDK_NATIVE_LOADING : JarAccess.InitiatedBy.OTHER);
    }

    public synchronized JarAccess create(JarSource jarSource) {
        return this.createSafe(null, jarSource, JarAccess.InitiatedBy.CLASS_LOADING);
    }

    public synchronized JarAccess create(JarSource jarSource, JarAccess.InitiatedBy initiatedBy) {
        return this.createSafe(null, jarSource, initiatedBy);
    }

    ZipTools.JarShortDigest calculateJarShortDigest(JarAccess jarAccess) throws IOException {
        try {
            AtomicReference atomicReference = new AtomicReference();
            jarAccess.withInputStream(inputStream -> atomicReference.set(this.zt.getDigest((MessageDigest)this.digest.clone(), jarAccess.getURL(), jarAccess.getJarFile(), (InputStream)inputStream)));
            ZipTools.JarShortDigest jarShortDigest = (ZipTools.JarShortDigest)atomicReference.get();
            this.logger.trace("jar central directory signature calculated jar=%s, url=%s, digest=%s", jarAccess.getJarFile(), jarAccess.getURL(), jarShortDigest);
            if (jarShortDigest == null) {
                return null;
            }
            if (Tweaks.DEBUG_JARLOAD && Tweaks.TRACE_CD_CONTENT) {
                System.out.println(">>> notifyJarLoad url=" + jarAccess.getURL() + "\njar=" + jarAccess.getJarFile() + "\ncentralDirectoryHashString=" + com.azul.crs.client.Utils.encodeToStringOrNull(jarShortDigest.getCentralDirectoryHash()) + "\nmanifestHashString=" + com.azul.crs.client.Utils.encodeToStringOrNull(jarShortDigest.getManifestHash()));
            }
            return jarShortDigest;
        }
        catch (Exception exception) {
            this.logger.error("Failed to calculate jar digest, due to exception=", exception);
            throw new RuntimeException(exception);
        }
    }

    private static Logger logger() {
        return Logger.getLogger(JarAccessFactory.class);
    }

    public static class JarAccessReference {
        final String path;
        final String hash;

        public JarAccessReference(String string, String string2) {
            this.path = string;
            this.hash = string2;
        }
    }
}

