/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.rework.jars;

import com.azul.crs.client.rework.jars.JarAccess;
import com.azul.crs.client.rework.jars.utils.LRU;
import com.azul.crs.util.logging.Logger;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class JarCache {
    final Logger logger = Logger.getLogger(this.getClass());
    private final Map<String, JarAccess> fromCacheByPath = new HashMap<String, JarAccess>();
    private final Map<String, JarAccess> fromCacheByHash = new HashMap<String, JarAccess>();
    private final Map<String, JarAccess> fromCacheByURL = new HashMap<String, JarAccess>();
    private final Map<String, JarAccess> fromCacheBySource = new HashMap<String, JarAccess>();
    private final LRU<JarAccess> lruJarAccess;

    public JarCache(int n) {
        this.lruJarAccess = new LRU<JarAccess>(n, jarAccess -> {
            if (jarAccess.getPath() != null) {
                this.fromCacheByPath.put(jarAccess.getPath(), (JarAccess)jarAccess);
            }
            if (jarAccess.getHashLazy() != null) {
                this.fromCacheByHash.put(jarAccess.getHashLazy(), (JarAccess)jarAccess);
            }
            if (jarAccess.getURL() != null) {
                this.fromCacheByURL.put(jarAccess.getURL().toString(), (JarAccess)jarAccess);
            }
            if (jarAccess.getSource() != null) {
                this.fromCacheBySource.put(jarAccess.getSource(), (JarAccess)jarAccess);
            }
        }, jarAccess -> {
            if (jarAccess.getPath() != null) {
                this.fromCacheByPath.remove(jarAccess.getPath());
            }
            if (jarAccess.getHashLazy() != null) {
                this.fromCacheByHash.remove(jarAccess.getHashLazy());
            }
            if (jarAccess.getURL() != null) {
                this.fromCacheByURL.remove(jarAccess.getURL().toString());
            }
            if (jarAccess.getSource() != null) {
                this.fromCacheBySource.remove(jarAccess.getSource());
            }
        });
    }

    private JarAccess byPath(String string) {
        return this.fromCacheByPath.get(string);
    }

    private JarAccess byHash(String string) {
        if (string == null) {
            return null;
        }
        return this.fromCacheByHash.get(string);
    }

    private JarAccess byURL(URL uRL) {
        return this.fromCacheByURL.get(uRL.toString());
    }

    private JarAccess bySource(String string) {
        return this.fromCacheBySource.get(string);
    }

    public boolean isPathKnown(String string) {
        return this.byPath(string) != null;
    }

    public boolean isHashKnown(String string) {
        return this.byHash(string) != null;
    }

    public boolean isURLKnown(URL uRL) {
        return this.byURL(uRL) != null;
    }

    public boolean isSourceKnown(String string) {
        return this.bySource(string) != null;
    }

    public boolean isKnown(JarAccess jarAccess) {
        return this.isHashKnown(jarAccess.getHashLazy()) || this.isSourceKnown(jarAccess.getSource()) || this.isURLKnown(jarAccess.getURL()) || this.isPathKnown(jarAccess.getPath());
    }

    public void put(JarAccess jarAccess) {
        this.logger.trace("JarCache.put: %s", jarAccess);
        this.lruJarAccess.put(jarAccess);
    }
}

