/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.rework.jars;

import com.azul.crs.client.jars.JarURLFactory;
import com.azul.crs.client.rework.jars.SourceCache;
import com.azul.crs.util.logging.Logger;
import java.net.URL;

public class JarSource {
    private static Logger logger = Logger.getLogger(JarSource.class);
    private final String source;
    private final URL originalUrl;
    private final URL url;

    private JarSource(String string, URL uRL, URL uRL2) {
        this.source = string;
        this.originalUrl = uRL;
        this.url = uRL2;
    }

    public String getSource() {
        return this.source;
    }

    public URL getUrl() {
        return this.url;
    }

    public String toString() {
        return "JarSource[source=" + this.source + ", originalUrl=" + this.originalUrl + ", url=" + this.url + ']';
    }

    public static final class Builder {
        private String source;
        private URL url;
        private boolean fromSource = false;
        private boolean fromUrl = false;
        private SourceCache sourceCache;

        public Builder fromSource(String string) {
            if (this.fromUrl) {
                throw new RuntimeException("Invalid build step to create JarSource from source.");
            }
            this.fromSource = true;
            this.source = string;
            return this;
        }

        public Builder fromUrl(URL uRL) {
            if (this.fromSource) {
                throw new RuntimeException("Invalid build step to create JarSource from url.");
            }
            this.fromUrl = true;
            this.url = uRL;
            return this;
        }

        public JarSource build() {
            if (this.fromSource) {
                URL uRL = JarURLFactory.createURL(this.source, this.sourceCache);
                if (uRL == null) {
                    logger.trace("Can not create URL from source=%s", this.source);
                    return null;
                }
                return new JarSource(this.source, null, uRL);
            }
            if (this.fromUrl) {
                URL uRL = JarURLFactory.createURL(this.url.toString(), this.sourceCache);
                if (uRL == null) {
                    logger.trace("Can not create URL from url=%s", this.url);
                    return null;
                }
                return new JarSource(null, this.url, uRL);
            }
            throw new RuntimeException("Invalid JarSource builder ... ");
        }

        public Builder withCache(SourceCache sourceCache) {
            this.sourceCache = sourceCache;
            return this;
        }
    }
}

