/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.rework.jars.utils;

import com.azul.crs.client.Tweaks;
import com.azul.crs.client.rework.jars.utils.StackTrace;
import com.azul.crs.client.rework.jars.utils.Utils;
import com.azul.crs.util.logging.Logger;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class MyAtomicLongDebuggable {
    private static final Logger logger = Logger.getLogger(MyAtomicLongDebuggable.class);
    private final Map<Object, StackTrace> map = Collections.synchronizedMap(new IdentityHashMap());
    private final AtomicLong delegate = new AtomicLong();
    private final String name;

    public MyAtomicLongDebuggable(String string) {
        this.name = string;
    }

    public Long incrementAndGet(Object object) {
        if (Tweaks.DEBUG_JARLOAD) {
            StackTrace stackTrace = StackTrace.get();
            logger.trace("[%s] incrementAndGet: (%s); stack=(%s)", this.name, Utils.toStringWithIdentityHash(object), stackTrace);
            this.map.put(object, stackTrace);
        }
        return this.delegate.incrementAndGet();
    }

    public Long decrementAndGet(Object object) {
        if (Tweaks.DEBUG_JARLOAD) {
            StackTrace stackTrace = StackTrace.get();
            logger.trace("[%s] decrementAndGet: (%s) => (%s), from: (%s)", this.name, Utils.toStringWithIdentityHash(object), this.map.get(object), stackTrace);
            if (null == this.map.remove(object)) {
                logger.debug("[%s] requested not scheduled decrementAndGet: (%s) => (%s), from: (%s)", this.name, Utils.toStringWithIdentityHash(object), this.map.get(object), stackTrace);
            }
        }
        return this.delegate.decrementAndGet();
    }

    public Long get() {
        return this.delegate.get();
    }

    public void dump() {
        if (!Tweaks.DEBUG_JARLOAD) {
            return;
        }
        logger.trace("[%s] MyAtomicLongDebuggable: dump[size=%d]", this.name, this.map.size());
        for (Object object : new HashSet<Object>(this.map.keySet())) {
            logger.trace("[%s] Not decremented atomic long: (%s) => (%s)", this.name, Utils.toStringWithIdentityHash(object), this.map.get(object));
        }
    }
}

