/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.rework.jars.utils;

import com.azul.crs.client.Tweaks;
import com.azul.crs.client.rework.jars.utils.StackTrace;
import com.azul.crs.client.rework.jars.utils.Utils;
import com.azul.crs.util.logging.Logger;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public final class MySetDebuggable<T> {
    private static final Logger logger = Logger.getLogger(MySetDebuggable.class);
    private final Map<T, StackTrace> map = Collections.synchronizedMap(new IdentityHashMap());
    private final Set<T> delegate = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private final String name;

    public MySetDebuggable(String string) {
        this.name = string;
    }

    public boolean add(T t) {
        if (Tweaks.DEBUG_JARLOAD) {
            StackTrace stackTrace = StackTrace.get();
            logger.trace("[%s] add: (%s); stack=(%s)", this.name, Utils.toStringWithIdentityHash(t), stackTrace);
            this.map.put(t, stackTrace);
        }
        return this.delegate.add(t);
    }

    public boolean remove(T t) {
        if (Tweaks.DEBUG_JARLOAD) {
            StackTrace stackTrace = StackTrace.get();
            logger.trace("[%s] remove: (%s) => (%s), from: (%s)", this.name, Utils.toStringWithIdentityHash(t), this.map.remove(t), stackTrace);
        }
        return this.delegate.remove(t);
    }

    public int size() {
        return this.delegate.size();
    }

    public void dump() {
        if (!Tweaks.DEBUG_JARLOAD) {
            return;
        }
        logger.trace("[%s] MySetDebuggable: dump[size=%d]", this.name, this.map.size());
        for (T t : new HashSet<T>(this.map.keySet())) {
            logger.trace("[%s] Not removed atomic long: (%s) => (%s)", this.name, Utils.toStringWithIdentityHash(t), this.map.get(t));
        }
    }
}

