/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.Inventory;
import com.azul.crs.client.Utils;
import com.azul.crs.client.models.VMArtifact;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.jfr.access.FlightRecorderAccess;
import com.azul.crs.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import jdk.jfr.Configuration;
import jdk.jfr.FlightRecorder;
import jdk.jfr.FlightRecorderListener;
import jdk.jfr.Recording;
import jdk.jfr.RecordingState;

public final class JFRMonitor
implements ClientService,
FlightRecorderListener,
FlightRecorderAccess.FlightRecorderCallbacks {
    private static final String SERVICE_NAME = "client.service.JFR";
    private static final Logger logger = Logger.getLogger(JFRMonitor.class);
    private static JFRMonitor instance;
    private static final AtomicReference<Thread> initTask;
    private final AtomicReference<FlightRecorder> recorder = new AtomicReference();
    private final AtomicInteger chunkSequenceNumber = new AtomicInteger();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final Map<Long, Integer> idMap = new HashMap<Long, Integer>();
    private final Object shutdownJfrMonitor = new Object();
    private final Client client;
    private final String params;
    private final AtomicReference<FlightRecorderAccess> accessRef = new AtomicReference();

    private JFRMonitor(Client client, String string) {
        this.client = client;
        this.params = string;
    }

    public static synchronized JFRMonitor getInstance(Client client, String string) {
        if (instance == null) {
            instance = new JFRMonitor(client, string);
            initTask.set(new Thread("JFRMonitor Init Thread"){
                {
                    this.setDaemon(true);
                }

                @Override
                public void run() {
                    FlightRecorder.addListener(instance);
                }
            });
            try {
                initTask.get().start();
                initTask.get().join();
                JFRMonitor.instance.initialized.set(true);
            }
            catch (InterruptedException interruptedException) {
                logger.debug("Exception when waiting JFRMonitor initTask", interruptedException);
            }
            finally {
                initTask.set(null);
            }
            return instance;
        }
        if (!Objects.equals(client, JFRMonitor.instance.client) || !Objects.equals(string, JFRMonitor.instance.params)) {
            throw new IllegalArgumentException("client.service.JFR: an instance with different parameters has already been created");
        }
        return instance;
    }

    @Override
    public String serviceName() {
        return SERVICE_NAME;
    }

    @Override
    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("client.service.JFR has already been started");
        }
        if (this.initialized.get()) {
            JFRMonitor.maybeStartLifetimeRecording(this.params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(Utils.Deadline deadline) {
        if (!this.stopped.compareAndSet(false, true)) {
            throw new IllegalStateException("client.service.JFR has already been stopped");
        }
        Object object = this.shutdownJfrMonitor;
        synchronized (object) {
            while (this.recorder.get() != null && !deadline.hasExpired()) {
                logger.debug("Waiting for jfr to shutdown", new Object[0]);
                try {
                    this.shutdownJfrMonitor.wait(Math.max(1L, deadline.remainder(TimeUnit.MILLISECONDS)));
                }
                catch (InterruptedException interruptedException) {
                    logger.debug("jfr shutdown waiting thread has been interrupted", new Object[0]);
                    Thread.interrupted();
                    break;
                }
            }
        }
        logger.debug("Unblocked CRS client shutdown", new Object[0]);
    }

    @Override
    public void recorderInitialized(FlightRecorder flightRecorder) {
        if (!this.recorder.compareAndSet(null, flightRecorder)) {
            throw new IllegalStateException("recorderInitialized is expected to be called only once");
        }
        try {
            this.setAccess(FlightRecorderAccess.getAccess(flightRecorder, this));
        }
        catch (Throwable throwable) {
            this.recorder.set(null);
            FlightRecorder.removeListener(instance);
            logger.error("Cannot install associate to JFR: %s", throwable.toString());
            return;
        }
        for (Recording recording : flightRecorder.getRecordings()) {
            this.recordingStateChanged(recording);
        }
    }

    @Override
    public void recordingStateChanged(Recording recording) {
        logger.debug("recording %s state changed to %s", new Object[]{this.getRecordingName(recording), recording.getState()});
        try {
            this.createOrUpdate(recording);
        }
        catch (Throwable throwable) {
            logger.error("Exception %s", throwable.getMessage(), throwable);
        }
    }

    @Override
    public void nextChunk(Object object, Path path, Instant instant, Instant instant2, long l, Recording recording) {
        this.lockRepositoryChunk(object);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (Recording recording2 : this.recorder.get().getRecordings()) {
            long l2 = recording2.getId();
            if (recording2 == recording || !this.idMap.containsKey(l2)) continue;
            arrayList.add(l2);
        }
        if (arrayList.isEmpty()) {
            logger.warning("No active record for the chunk", new Object[0]);
            return;
        }
        this.enqueuePostVMArtifactChunk(object, path, instant, instant2 == null ? Instant.now() : instant2, l, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishJoin() {
        Object object;
        logger.debug("shutting down JFR " + System.currentTimeMillis(), new Object[0]);
        try {
            object = initTask.get();
            if (object != null) {
                ((Thread)object).interrupt();
                logger.warning("JFR stopped before JFRMonitor was fully initialized.", new Object[0]);
            } else {
                for (Recording recording : this.recorder.get().getRecordings()) {
                    recording.close();
                }
                this.client.finishChunkPost();
            }
        }
        finally {
            object = this.shutdownJfrMonitor;
            synchronized (object) {
                this.recorder.set(null);
                this.shutdownJfrMonitor.notify();
            }
        }
        logger.debug("JFR tracking finished " + System.currentTimeMillis(), new Object[0]);
    }

    private void enqueuePostVMArtifactChunk(Object object, Path path, Instant instant, Instant instant2, long l2, Collection<Long> collection) {
        logger.debug("Enqueuing chunk data record [%s, size %d], Recordings: %s", path.toString(), l2, Arrays.toString(collection.toArray()));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("startTime", instant.toEpochMilli());
        hashMap.put("endTime", instant2.toEpochMilli());
        hashMap.put("size", l2);
        hashMap.put("path", path.toString());
        hashMap.put("sequenceNumber", Integer.toString(this.chunkSequenceNumber.incrementAndGet()));
        HashSet<Integer> hashSet = new HashSet<Integer>(collection.size());
        collection.forEach(l -> hashSet.add(this.idMap.get(l)));
        this.client.postVMArtifactChunk(VMArtifact.Type.JFR, hashSet, hashMap, outputStream -> {
            try {
                Files.copy(path, outputStream);
            }
            catch (IOException iOException) {
                logger.warning("Failed to send recording chunk %s: %s%s", path.toString(), iOException, Client.isVMShutdownInitiated() ? " (expected during shutdown if timeout is exceeded)" : "");
            }
            finally {
                this.releaseRepositoryChunk(object);
            }
        });
    }

    private void setAccess(FlightRecorderAccess flightRecorderAccess) {
        this.accessRef.set(flightRecorderAccess);
    }

    private void lockRepositoryChunk(Object object) {
        try {
            logger.debug("locking chunk %s", object);
            this.accessRef.get().useRepositoryChunk(object);
        }
        catch (FlightRecorderAccess.AccessException accessException) {
            accessException.printStackTrace();
        }
    }

    private void releaseRepositoryChunk(Object object) {
        try {
            logger.debug("releasing chunk %s", object);
            this.accessRef.get().releaseRepositoryChunk(object);
        }
        catch (FlightRecorderAccess.AccessException accessException) {
            accessException.printStackTrace();
        }
    }

    private static void maybeStartLifetimeRecording(String string) {
        Recording recording;
        if (null == string || "disable".equals(string)) {
            logger.info("lifetime recording is disabled", new Object[0]);
            return;
        }
        if (!FlightRecorder.isAvailable()) {
            logger.warning("lifetime recording is not available", new Object[0]);
            return;
        }
        if (string.isEmpty()) {
            recording = new Recording();
            logger.info("started lifetime recording with empty configuration", new Object[0]);
        } else {
            try {
                recording = new Recording(Configuration.create(new File(string).toPath()));
                logger.info("started lifetime recording with configuration from %s", string);
            }
            catch (IOException | ParseException exception) {
                logger.error("cannot read or parse specified JFR configuration file %s. recording stopped", string);
                return;
            }
        }
        recording.setName("lifetime recording");
        recording.scheduleStart(Duration.ZERO);
    }

    private String getRecordingName(Recording recording) {
        String string = recording.getName();
        if (!Long.toString(recording.getId()).equals(string)) {
            return string;
        }
        Path path = recording.getDestination();
        return path == null ? string : path.getFileName().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrUpdate(Recording recording) {
        Integer n;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        RecordingState recordingState = recording.getState();
        hashMap.put("state", recordingState.name());
        if (recordingState == RecordingState.STOPPED || recordingState == RecordingState.CLOSED) {
            hashMap.put("stopTime", recording.getStopTime().toEpochMilli());
        }
        long l = recording.getId();
        int n2 = -1;
        Object object = this.idMap;
        synchronized (object) {
            n = this.idMap.get(l);
            if (n == null) {
                n2 = this.client.createArtifactId();
                this.idMap.put(l, n2);
            }
        }
        if (n2 > 0) {
            hashMap.put("name", this.getRecordingName(recording));
            hashMap.put("tags", Inventory.instanceTags());
            hashMap.put("startTime", recording.getStartTime().toEpochMilli());
            object = recording.getDestination();
            if (object != null) {
                hashMap.put("destination", object.toString());
            }
            this.client.postVMArtifactCreate(VMArtifact.Type.JFR, n2, hashMap);
            logger.debug("Enqueued VMArtifact creation [id: %d, crs_id: %d]", l, n2);
        } else {
            this.client.postVMArtifactPatch(VMArtifact.Type.JFR, n, hashMap);
            logger.debug("Enqueued VMArtifact patching [id: %d, crs_id: %d]", l, n);
        }
    }

    static {
        initTask = new AtomicReference();
    }
}

