/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.sysinfo;

import com.azul.crs.client.sysinfo.SystemInfoProvider;
import com.azul.crs.util.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

final class MacOSXSystemInfoProvider
extends SystemInfoProvider.SystemInfoProviderImpl {
    private static final String SYSCTL_PROGRAM_LOCATION = "/usr/sbin/sysctl";
    private static final String SYSCTL_PROGRAM_FALLBACK_LOCATION = "/sbin/sysctl";

    MacOSXSystemInfoProvider() {
    }

    @Override
    protected void initProps() throws IOException, InterruptedException {
        String string;
        if (this.isSysctlAvailableAndExecutable(SYSCTL_PROGRAM_LOCATION)) {
            string = SYSCTL_PROGRAM_LOCATION;
        } else if (this.isSysctlAvailableAndExecutable(SYSCTL_PROGRAM_FALLBACK_LOCATION)) {
            string = SYSCTL_PROGRAM_FALLBACK_LOCATION;
        } else {
            return;
        }
        ProcessBuilder processBuilder = new ProcessBuilder(string, "-a");
        Process process = processBuilder.start();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf(58);
                if (n < 0) continue;
                String string3 = string2.substring(0, n).trim();
                String string4 = string2.substring(n + 1).trim();
                this.machdepProps.set("sysctl." + string3, string4);
            }
        }
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.PROCESSOR_COUNT, this.machdepProps.intValue("sysctl.hw.ncpu"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.VENDOR, this.machdepProps.strValue("sysctl.machdep.cpu.vendor"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.MODEL_NAME, this.machdepProps.strValue("sysctl.machdep.cpu.brand_string"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.PHYSICAL_CORE_COUNT, this.machdepProps.intValue("sysctl.hw.physicalcpu"));
        process.waitFor();
    }

    private boolean isSysctlAvailableAndExecutable(String string) {
        File file = new File(string);
        if (!file.exists()) {
            Logger.getLogger(MacOSXSystemInfoProvider.class).warning("sysctl is not available under path: %s", string);
            return false;
        }
        if (!file.canExecute()) {
            Logger.getLogger(MacOSXSystemInfoProvider.class).warning("sysctl is not executable", new Object[0]);
            return false;
        }
        return true;
    }
}

