/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.runtime.utils;

import java.util.Arrays;
import java.util.List;

public final class URLHelper {
    private static final List<String> containerExtensions = Arrays.asList(".jar", ".war", ".ear");
    private static final List<String> remoteLocation = Arrays.asList("http://", "https://");
    private static final List<String> containerProtos = Arrays.asList("jar:", "file:");
    private static final String containerProtoPattern = "^[a-z]{3,}:.+";

    private URLHelper() {
    }

    public static String toNormalizedURL(String string) {
        if (string == null) {
            return null;
        }
        if (!string.contains("/") && !string.contains("\\")) {
            return string;
        }
        if (string.contains("http://") || string.contains("https://")) {
            return string;
        }
        boolean bl = string.matches(containerProtoPattern);
        return (bl ? string : "file:/" + string).replace('\\', '/').replaceAll("/+", "/").replace(" ", "%20");
    }

    public static String toNormalizedJarURL(String string) {
        int n;
        if (!(string = URLHelper.toNormalizedURL(string)).startsWith("jar:")) {
            string = "jar:" + string;
        }
        if ((n = string.lastIndexOf(".jar")) > 0 && !string.endsWith(".jar!/")) {
            string = string.substring(0, n) + ".jar!/";
        }
        return string;
    }

    public static String extractContainerPathFromURL(String string) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        int n3 = 0;
        int n4 = string.length();
        block0: while (true) {
            for (String string3 : containerProtos) {
                if (!string.regionMatches(n3, string3, 0, n2 = string3.length())) continue;
                n3 += n2;
                continue block0;
            }
            break;
        }
        if (n3 == 0) {
            return string;
        }
        if (string.regionMatches(n4 - 2, "!/", 0, 2)) {
            n4 -= 2;
        }
        int n5 = n4;
        boolean bl = containerExtensions.stream().anyMatch(string2 -> {
            int n2 = string2.length();
            return string.regionMatches(n5 - n2, (String)string2, 0, n2);
        });
        n2 = n3;
        boolean bl2 = remoteLocation.stream().anyMatch(string2 -> string.startsWith((String)string2, n2));
        if (!bl && (n = containerExtensions.stream().mapToInt(string2 -> {
            int n = string.lastIndexOf(string2 + "!/");
            return n > 0 ? n + string2.length() : n;
        }).max().orElse(-1)) > 0) {
            n4 = n;
        }
        if (bl2) {
            return string.substring(n3, n4);
        }
        return ("/" + string.substring(n3, n4)).replaceAll("/+", "/").replace("%20", " ");
    }
}

