/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.cosnaming;

import com.sun.jndi.cosnaming.CNCtx;
import com.sun.jndi.cosnaming.CNNameParser;
import com.sun.jndi.toolkit.corba.CorbaUtils;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.NamingManager;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIterator;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.NameComponent;

final class CNBindingEnumeration
implements NamingEnumeration<javax.naming.Binding> {
    private static final int DEFAULT_BATCHSIZE = 100;
    private BindingListHolder _bindingList;
    private BindingIterator _bindingIter;
    private int counter;
    private int batchsize = 100;
    private CNCtx _ctx;
    private Hashtable<?, ?> _env;
    private boolean more = false;
    private boolean isLookedUpCtx = false;

    CNBindingEnumeration(CNCtx cNCtx, boolean bl, Hashtable<?, ?> hashtable) {
        String string;
        String string2 = string = hashtable != null ? (String)hashtable.get("java.naming.batchsize") : null;
        if (string != null) {
            try {
                this.batchsize = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Batch size not numeric: " + string);
            }
        }
        this._ctx = cNCtx;
        this._ctx.incEnumCount();
        this.isLookedUpCtx = bl;
        this._env = hashtable;
        this._bindingList = new BindingListHolder();
        BindingIteratorHolder bindingIteratorHolder = new BindingIteratorHolder();
        this._ctx._nc.list(0, this._bindingList, bindingIteratorHolder);
        this._bindingIter = bindingIteratorHolder.value;
        this.more = this._bindingIter != null ? this._bindingIter.next_n(this.batchsize, this._bindingList) : false;
        this.counter = 0;
    }

    @Override
    public javax.naming.Binding next() throws NamingException {
        if (this.more && this.counter >= this._bindingList.value.length) {
            this.getMore();
        }
        if (this.more && this.counter < this._bindingList.value.length) {
            Binding binding = this._bindingList.value[this.counter];
            ++this.counter;
            return this.mapBinding(binding);
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasMore() throws NamingException {
        return this.more ? this.counter < this._bindingList.value.length || this.getMore() : false;
    }

    @Override
    public boolean hasMoreElements() {
        try {
            return this.hasMore();
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    @Override
    public javax.naming.Binding nextElement() {
        try {
            return this.next();
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void close() throws NamingException {
        this.more = false;
        if (this._bindingIter != null) {
            this._bindingIter.destroy();
            this._bindingIter = null;
        }
        if (this._ctx != null) {
            this._ctx.decEnumCount();
            if (this.isLookedUpCtx) {
                this._ctx.close();
            }
            this._ctx = null;
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private boolean getMore() throws NamingException {
        try {
            this.more = this._bindingIter.next_n(this.batchsize, this._bindingList);
            this.counter = 0;
        }
        catch (Exception exception) {
            this.more = false;
            NamingException namingException = new NamingException("Problem getting binding list");
            namingException.setRootCause(exception);
            throw namingException;
        }
        return this.more;
    }

    private javax.naming.Binding mapBinding(Binding binding) throws NamingException {
        Object object = this._ctx.callResolve(binding.binding_name);
        Name name = CNNameParser.cosNameToName(binding.binding_name);
        try {
            if (CorbaUtils.isObjectFactoryTrusted(object)) {
                object = NamingManager.getObjectInstance(object, name, this._ctx, this._env);
            }
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException("problem generating object using object factory");
            namingException.setRootCause(exception);
            throw namingException;
        }
        String string = name.toString();
        javax.naming.Binding binding2 = new javax.naming.Binding(string, object);
        NameComponent[] nameComponentArray = this._ctx.makeFullName(binding.binding_name);
        String string2 = CNNameParser.cosNameToInsString(nameComponentArray);
        binding2.setNameInNamespace(string2);
        return binding2;
    }
}

