/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import sun.font.AttributeValues;
import sun.font.CoreMetrics;
import sun.font.Decoration;
import sun.font.ExtendedTextLabel;
import sun.font.GlyphLayout;
import sun.font.StandardGlyphVector;
import sun.font.TextLineComponent;
import sun.font.TextSource;

class ExtendedTextSourceLabel
extends ExtendedTextLabel
implements Decoration.Label {
    TextSource source;
    private Decoration decorator;
    private Font font;
    private AffineTransform baseTX;
    private CoreMetrics cm;
    Rectangle2D lb;
    Rectangle2D ab;
    Rectangle2D vb;
    Rectangle2D ib;
    StandardGlyphVector gv;
    float[] charinfo;
    float advTracking;
    private static final int posx = 0;
    private static final int posy = 1;
    private static final int advx = 2;
    private static final int advy = 3;
    private static final int visx = 4;
    private static final int visy = 5;
    private static final int visw = 6;
    private static final int vish = 7;
    private static final int numvals = 8;

    public ExtendedTextSourceLabel(TextSource textSource, Decoration decoration) {
        this.source = textSource;
        this.decorator = decoration;
        this.finishInit();
    }

    public ExtendedTextSourceLabel(TextSource textSource, ExtendedTextSourceLabel extendedTextSourceLabel, int n) {
        this.source = textSource;
        this.decorator = extendedTextSourceLabel.decorator;
        this.finishInit();
    }

    private void finishInit() {
        this.font = this.source.getFont();
        Map<TextAttribute, ?> map = this.font.getAttributes();
        this.baseTX = AttributeValues.getBaselineTransform(map);
        if (this.baseTX == null) {
            this.cm = this.source.getCoreMetrics();
        } else {
            AffineTransform affineTransform = AttributeValues.getCharTransform(map);
            if (affineTransform == null) {
                affineTransform = new AffineTransform();
            }
            this.font = this.font.deriveFont(affineTransform);
            LineMetrics lineMetrics = this.font.getLineMetrics(this.source.getChars(), this.source.getStart(), this.source.getStart() + this.source.getLength(), this.source.getFRC());
            this.cm = CoreMetrics.get(lineMetrics);
        }
        this.advTracking = (float)this.font.getSize() * AttributeValues.getTracking(map);
    }

    @Override
    public Rectangle2D getLogicalBounds() {
        return this.getLogicalBounds(0.0f, 0.0f);
    }

    @Override
    public Rectangle2D getLogicalBounds(float f, float f2) {
        if (this.lb == null) {
            this.lb = this.createLogicalBounds();
        }
        return new Rectangle2D.Float((float)(this.lb.getX() + (double)f), (float)(this.lb.getY() + (double)f2), (float)this.lb.getWidth(), (float)this.lb.getHeight());
    }

    @Override
    public float getAdvance() {
        if (this.lb == null) {
            this.lb = this.createLogicalBounds();
        }
        return (float)this.lb.getWidth();
    }

    @Override
    public Rectangle2D getVisualBounds(float f, float f2) {
        if (this.vb == null) {
            this.vb = this.decorator.getVisualBounds(this);
        }
        return new Rectangle2D.Float((float)(this.vb.getX() + (double)f), (float)(this.vb.getY() + (double)f2), (float)this.vb.getWidth(), (float)this.vb.getHeight());
    }

    @Override
    public Rectangle2D getAlignBounds(float f, float f2) {
        if (this.ab == null) {
            this.ab = this.createAlignBounds();
        }
        return new Rectangle2D.Float((float)(this.ab.getX() + (double)f), (float)(this.ab.getY() + (double)f2), (float)this.ab.getWidth(), (float)this.ab.getHeight());
    }

    @Override
    public Rectangle2D getItalicBounds(float f, float f2) {
        if (this.ib == null) {
            this.ib = this.createItalicBounds();
        }
        return new Rectangle2D.Float((float)(this.ib.getX() + (double)f), (float)(this.ib.getY() + (double)f2), (float)this.ib.getWidth(), (float)this.ib.getHeight());
    }

    @Override
    public Rectangle getPixelBounds(FontRenderContext fontRenderContext, float f, float f2) {
        return this.getGV().getPixelBounds(fontRenderContext, f, f2);
    }

    @Override
    public boolean isSimple() {
        return this.decorator == Decoration.getPlainDecoration() && this.baseTX == null;
    }

    @Override
    public AffineTransform getBaselineTransform() {
        return this.baseTX;
    }

    @Override
    public Shape handleGetOutline(float f, float f2) {
        return this.getGV().getOutline(f, f2);
    }

    @Override
    public Shape getOutline(float f, float f2) {
        return this.decorator.getOutline(this, f, f2);
    }

    @Override
    public void handleDraw(Graphics2D graphics2D, float f, float f2) {
        graphics2D.drawGlyphVector(this.getGV(), f, f2);
    }

    @Override
    public void draw(Graphics2D graphics2D, float f, float f2) {
        this.decorator.drawTextAndDecorations(this, graphics2D, f, f2);
    }

    protected Rectangle2D createLogicalBounds() {
        return this.getGV().getLogicalBounds();
    }

    @Override
    public Rectangle2D handleGetVisualBounds() {
        return this.getGV().getVisualBounds();
    }

    protected Rectangle2D createAlignBounds() {
        int n;
        float[] fArray = this.getCharinfo();
        float f = 0.0f;
        float f2 = -this.cm.ascent;
        float f3 = 0.0f;
        float f4 = this.cm.ascent + this.cm.descent;
        if (this.charinfo == null || this.charinfo.length == 0) {
            return new Rectangle2D.Float(f, f2, f3, f4);
        }
        boolean bl = (this.source.getLayoutFlags() & 8) == 0;
        if (bl) {
            for (n = fArray.length - 8; n > 0 && fArray[n + 6] == 0.0f; n -= 8) {
            }
        }
        if (n >= 0) {
            int n2;
            for (n2 = 0; n2 < n && (fArray[n2 + 2] == 0.0f || !bl && fArray[n2 + 6] == 0.0f); n2 += 8) {
            }
            f = Math.max(0.0f, fArray[n2 + 0]);
            f3 = fArray[n + 0] + fArray[n + 2] - f;
        }
        return new Rectangle2D.Float(f, f2, f3, f4);
    }

    public Rectangle2D createItalicBounds() {
        float f = this.cm.italicAngle;
        Rectangle2D rectangle2D = this.getLogicalBounds();
        float f2 = (float)rectangle2D.getMinX();
        float f3 = -this.cm.ascent;
        float f4 = (float)rectangle2D.getMaxX();
        float f5 = this.cm.descent;
        if (f != 0.0f) {
            if (f > 0.0f) {
                f2 -= f * (f5 - this.cm.ssOffset);
                f4 -= f * (f3 - this.cm.ssOffset);
            } else {
                f2 -= f * (f3 - this.cm.ssOffset);
                f4 -= f * (f5 - this.cm.ssOffset);
            }
        }
        return new Rectangle2D.Float(f2, f3, f4 - f2, f5 - f3);
    }

    private final StandardGlyphVector getGV() {
        if (this.gv == null) {
            this.gv = this.createGV();
        }
        return this.gv;
    }

    protected StandardGlyphVector createGV() {
        FontRenderContext fontRenderContext = this.source.getFRC();
        int n = this.source.getLayoutFlags();
        char[] cArray = this.source.getChars();
        int n2 = this.source.getStart();
        int n3 = this.source.getLength();
        GlyphLayout glyphLayout = GlyphLayout.get(null);
        this.gv = glyphLayout.layout(this.font, fontRenderContext, cArray, n2, n3, n, null);
        GlyphLayout.done(glyphLayout);
        return this.gv;
    }

    @Override
    public int getNumCharacters() {
        return this.source.getLength();
    }

    @Override
    public CoreMetrics getCoreMetrics() {
        return this.cm;
    }

    @Override
    public float getCharX(int n) {
        this.validate(n);
        float[] fArray = this.getCharinfo();
        int n2 = this.l2v(n) * 8 + 0;
        if (fArray == null || n2 >= fArray.length) {
            return 0.0f;
        }
        return fArray[n2];
    }

    @Override
    public float getCharY(int n) {
        this.validate(n);
        float[] fArray = this.getCharinfo();
        int n2 = this.l2v(n) * 8 + 1;
        if (fArray == null || n2 >= fArray.length) {
            return 0.0f;
        }
        return fArray[n2];
    }

    @Override
    public float getCharAdvance(int n) {
        this.validate(n);
        float[] fArray = this.getCharinfo();
        int n2 = this.l2v(n) * 8 + 2;
        if (fArray == null || n2 >= fArray.length || fArray[n2] == 0.0f) {
            return 0.0f;
        }
        return fArray[n2] + this.advTracking;
    }

    @Override
    public Rectangle2D handleGetCharVisualBounds(int n) {
        this.validate(n);
        float[] fArray = this.getCharinfo();
        n = this.l2v(n) * 8;
        if (fArray == null || n + 7 >= fArray.length) {
            return new Rectangle2D.Float();
        }
        return new Rectangle2D.Float(fArray[n + 4], fArray[n + 5], fArray[n + 6], fArray[n + 7]);
    }

    @Override
    public Rectangle2D getCharVisualBounds(int n, float f, float f2) {
        Rectangle2D rectangle2D = this.decorator.getCharVisualBounds(this, n);
        if (f != 0.0f || f2 != 0.0f) {
            rectangle2D.setRect(rectangle2D.getX() + (double)f, rectangle2D.getY() + (double)f2, rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        return rectangle2D;
    }

    private void validate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index " + n + " < 0");
        }
        if (n >= this.source.getLength()) {
            throw new IllegalArgumentException("index " + n + " < " + this.source.getLength());
        }
    }

    @Override
    public int logicalToVisual(int n) {
        this.validate(n);
        return this.l2v(n);
    }

    @Override
    public int visualToLogical(int n) {
        this.validate(n);
        return this.v2l(n);
    }

    @Override
    public int getLineBreakIndex(int n, float f) {
        int n2;
        float[] fArray = this.getCharinfo();
        int n3 = this.source.getLength();
        if (this.advTracking > 0.0f) {
            f += this.advTracking;
        }
        --n;
        while (f >= -0.005f && ++n < n3 && (n2 = this.l2v(n) * 8 + 2) < fArray.length) {
            float f2 = fArray[n2];
            if (f2 == 0.0f) continue;
            f -= f2 + this.advTracking;
        }
        return n;
    }

    @Override
    public float getAdvanceBetween(int n, int n2) {
        int n3;
        float f = 0.0f;
        float[] fArray = this.getCharinfo();
        --n;
        while (++n < n2 && (n3 = this.l2v(n) * 8 + 2) < fArray.length) {
            float f2 = fArray[n3];
            if (f2 == 0.0f) continue;
            f += f2 + this.advTracking;
        }
        return f;
    }

    @Override
    public boolean caretAtOffsetIsValid(int n) {
        if (n == 0 || n == this.source.getLength()) {
            return true;
        }
        char c = this.source.getChars()[this.source.getStart() + n];
        if (c == '\t' || c == '\n' || c == '\r') {
            return true;
        }
        int n2 = this.l2v(n);
        int n3 = n2 * 8 + 2;
        float[] fArray = this.getCharinfo();
        if (fArray == null || n3 >= fArray.length) {
            return false;
        }
        return fArray[n3] != 0.0f;
    }

    private final float[] getCharinfo() {
        if (this.charinfo == null) {
            this.charinfo = this.createCharinfo();
        }
        return this.charinfo;
    }

    protected float[] createCharinfo() {
        int n;
        boolean bl;
        int n2;
        StandardGlyphVector standardGlyphVector = this.getGV();
        float[] fArray = null;
        try {
            fArray = standardGlyphVector.getGlyphInfo();
        }
        catch (Exception exception) {
            System.out.println(this.source);
        }
        int n3 = standardGlyphVector.getNumGlyphs();
        if (n3 == 0) {
            return fArray;
        }
        int[] nArray = standardGlyphVector.getGlyphCharIndices(0, n3, null);
        boolean bl2 = false;
        if (bl2) {
            System.err.println("number of glyphs: " + n3);
            for (n2 = 0; n2 < n3; ++n2) {
                System.err.println("g: " + n2 + ", x: " + fArray[n2 * 8 + 0] + ", a: " + fArray[n2 * 8 + 2] + ", n: " + nArray[n2]);
            }
        }
        int n4 = n2 = nArray[0];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = n3;
        int n11 = 8;
        int n12 = 1;
        boolean bl3 = bl = (this.source.getLayoutFlags() & 1) == 0;
        if (!bl) {
            n4 = n2 = nArray[n3 - 1];
            n5 = 0;
            n6 = fArray.length - 8;
            n7 = 0;
            n8 = fArray.length - 8;
            n9 = n3 - 1;
            n10 = -1;
            n11 = -8;
            n12 = -1;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        boolean bl4 = false;
        while (n9 != n10) {
            boolean bl5 = false;
            n = 0;
            n4 = n2 = nArray[n9];
            n9 += n12;
            n8 += n11;
            while (n9 != n10 && (fArray[n8 + 2] == 0.0f || n2 != n5 || nArray[n9] <= n4 || n4 - n2 > n)) {
                float f8;
                if (!bl5) {
                    int n13 = n8 - n11;
                    f = fArray[n13 + 0];
                    f2 = f + fArray[n13 + 2];
                    f3 = fArray[n13 + 4];
                    f4 = fArray[n13 + 5];
                    f5 = f3 + fArray[n13 + 6];
                    f6 = f4 + fArray[n13 + 7];
                    bl5 = true;
                }
                ++n;
                float f9 = fArray[n8 + 2];
                if (f9 != 0.0f) {
                    f8 = fArray[n8 + 0];
                    f = Math.min(f, f8);
                    f2 = Math.max(f2, f8 + f9);
                }
                if ((f8 = fArray[n8 + 6]) != 0.0f) {
                    float f10 = fArray[n8 + 4];
                    float f11 = fArray[n8 + 5];
                    f3 = Math.min(f3, f10);
                    f4 = Math.min(f4, f11);
                    f5 = Math.max(f5, f10 + f8);
                    f6 = Math.max(f6, f11 + fArray[n8 + 7]);
                }
                n2 = Math.min(n2, nArray[n9]);
                n4 = Math.max(n4, nArray[n9]);
                n9 += n12;
                n8 += n11;
            }
            if (bl2) {
                System.out.println("minIndex = " + n2 + ", maxIndex = " + n4);
            }
            n5 = n4 + 1;
            fArray[n6 + 1] = f7;
            fArray[n6 + 3] = 0.0f;
            if (bl5) {
                fArray[n6 + 0] = f;
                fArray[n6 + 2] = f2 - f;
                fArray[n6 + 4] = f3;
                fArray[n6 + 5] = f4;
                fArray[n6 + 6] = f5 - f3;
                fArray[n6 + 7] = f6 - f4;
                if (n4 - n2 < n) {
                    bl4 = true;
                }
                if (n2 < n4) {
                    if (!bl) {
                        f2 = f;
                    }
                    f5 -= f3;
                    f6 -= f4;
                    int n14 = n2;
                    int n15 = n6 / 8;
                    while (n2 < n4) {
                        ++n2;
                        n7 += n12;
                        if (((n6 += n11) < 0 || n6 >= fArray.length) && bl2) {
                            System.out.println("minIndex = " + n14 + ", maxIndex = " + n4 + ", cp = " + n15);
                        }
                        fArray[n6 + 0] = f2;
                        fArray[n6 + 1] = f7;
                        fArray[n6 + 2] = 0.0f;
                        fArray[n6 + 3] = 0.0f;
                        fArray[n6 + 4] = f3;
                        fArray[n6 + 5] = f4;
                        fArray[n6 + 6] = f5;
                        fArray[n6 + 7] = f6;
                    }
                }
                bl5 = false;
            } else if (bl4) {
                int n16 = n8 - n11;
                fArray[n6 + 0] = fArray[n16 + 0];
                fArray[n6 + 2] = fArray[n16 + 2];
                fArray[n6 + 4] = fArray[n16 + 4];
                fArray[n6 + 5] = fArray[n16 + 5];
                fArray[n6 + 6] = fArray[n16 + 6];
                fArray[n6 + 7] = fArray[n16 + 7];
            }
            n6 += n11;
            n7 += n12;
        }
        if (bl4 && !bl) {
            System.arraycopy(fArray, n6 -= n11, fArray, 0, fArray.length - n6);
        }
        if (bl2) {
            char[] cArray = this.source.getChars();
            n = this.source.getStart();
            int n17 = this.source.getLength();
            System.out.println("char info for " + n17 + " characters");
            int n18 = 0;
            while (n18 < n17 * 8) {
                System.out.println(" ch: " + Integer.toHexString(cArray[n + this.v2l(n18 / 8)]) + " x: " + fArray[n18++] + " y: " + fArray[n18++] + " xa: " + fArray[n18++] + " ya: " + fArray[n18++] + " l: " + fArray[n18++] + " t: " + fArray[n18++] + " w: " + fArray[n18++] + " h: " + fArray[n18++]);
            }
        }
        return fArray;
    }

    protected int l2v(int n) {
        return (this.source.getLayoutFlags() & 1) == 0 ? n : this.source.getLength() - 1 - n;
    }

    protected int v2l(int n) {
        return (this.source.getLayoutFlags() & 1) == 0 ? n : this.source.getLength() - 1 - n;
    }

    @Override
    public TextLineComponent getSubset(int n, int n2, int n3) {
        return new ExtendedTextSourceLabel(this.source.getSubSource(n, n2 - n, n3), this.decorator);
    }

    public String toString() {
        return this.source.toString(false);
    }

    @Override
    public int getNumJustificationInfos() {
        return this.getGV().getNumGlyphs();
    }

    @Override
    public void getJustificationInfos(GlyphJustificationInfo[] glyphJustificationInfoArray, int n, int n2, int n3) {
        boolean bl;
        StandardGlyphVector standardGlyphVector = this.getGV();
        float[] fArray = this.getCharinfo();
        float f = standardGlyphVector.getFont().getSize2D();
        GlyphJustificationInfo glyphJustificationInfo = new GlyphJustificationInfo(0.0f, false, 3, 0.0f, 0.0f, false, 3, 0.0f, 0.0f);
        GlyphJustificationInfo glyphJustificationInfo2 = new GlyphJustificationInfo(f, true, 1, 0.0f, f, true, 1, 0.0f, f / 4.0f);
        GlyphJustificationInfo glyphJustificationInfo3 = new GlyphJustificationInfo(f, true, 2, f, f, false, 3, 0.0f, 0.0f);
        char[] cArray = this.source.getChars();
        int n4 = this.source.getStart();
        int n5 = standardGlyphVector.getNumGlyphs();
        int n6 = 0;
        int n7 = n5;
        boolean bl2 = bl = (this.source.getLayoutFlags() & 1) == 0;
        if (n2 != 0 || n3 != this.source.getLength()) {
            if (bl) {
                n6 = n2;
                n7 = n3;
            } else {
                n6 = n5 - n3;
                n7 = n5 - n2;
            }
        }
        for (int i = 0; i < n5; ++i) {
            GlyphJustificationInfo glyphJustificationInfo4 = null;
            if (i >= n6 && i < n7) {
                int n8;
                char c;
                glyphJustificationInfo4 = fArray[i * 8 + 2] == 0.0f ? glyphJustificationInfo : (Character.isWhitespace(c = cArray[n4 + (n8 = this.v2l(i))]) ? glyphJustificationInfo2 : (c >= '\u4e00' && c < '\ua000' || c >= '\uac00' && c < '\ud7b0' || c >= '\uf900' && c < '\ufb00' ? glyphJustificationInfo3 : glyphJustificationInfo));
            }
            glyphJustificationInfoArray[n + i] = glyphJustificationInfo4;
        }
    }

    @Override
    public TextLineComponent applyJustificationDeltas(float[] fArray, int n, boolean[] blArray) {
        float[] fArray2 = (float[])this.getCharinfo().clone();
        blArray[0] = false;
        StandardGlyphVector standardGlyphVector = (StandardGlyphVector)this.getGV().clone();
        float[] fArray3 = standardGlyphVector.getGlyphPositions(null);
        int n2 = standardGlyphVector.getNumGlyphs();
        char[] cArray = this.source.getChars();
        int n3 = this.source.getStart();
        float f = 0.0f;
        for (int i = 0; i < n2; ++i) {
            if (Character.isWhitespace(cArray[n3 + this.v2l(i)])) {
                int n4 = i * 2;
                fArray3[n4] = fArray3[n4] + f;
                float f2 = fArray[n + i * 2] + fArray[n + i * 2 + 1];
                int n5 = i * 8 + 0;
                fArray2[n5] = fArray2[n5] + f;
                int n6 = i * 8 + 4;
                fArray2[n6] = fArray2[n6] + f;
                int n7 = i * 8 + 2;
                fArray2[n7] = fArray2[n7] + f2;
                f += f2;
                continue;
            }
            int n8 = i * 2;
            fArray3[n8] = fArray3[n8] + (f += fArray[n + i * 2]);
            int n9 = i * 8 + 0;
            fArray2[n9] = fArray2[n9] + f;
            int n10 = i * 8 + 4;
            fArray2[n10] = fArray2[n10] + f;
            f += fArray[n + i * 2 + 1];
        }
        int n11 = n2 * 2;
        fArray3[n11] = fArray3[n11] + f;
        standardGlyphVector.setGlyphPositions(fArray3);
        ExtendedTextSourceLabel extendedTextSourceLabel = new ExtendedTextSourceLabel(this.source, this.decorator);
        extendedTextSourceLabel.gv = standardGlyphVector;
        extendedTextSourceLabel.charinfo = fArray2;
        return extendedTextSourceLabel;
    }
}

