/*
 * Decompiled with CFR 0.152.
 */
package com.azul.tooling;

import com.azul.tooling.Engine;
import com.azul.tooling.in.Model;
import com.azul.tooling.in.Tooling;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class Handler
implements Tooling.ToolingHandler {
    private static final String ENABLED_EVENTS_PROPERTY_NAME = "com.azul.tooling.events";
    private static final String TOOLING_EVENT_NAME_PREFIX = "com.azul.tooling.in.";
    private static final String TOOLING_EVENT_NAME_POSTFIX = "Event";

    private Handler() {
    }

    public boolean isEventTypeEnabled(Class<? extends Tooling.ToolingEvent> clazz) {
        String string = clazz.getName();
        if (!string.startsWith(TOOLING_EVENT_NAME_PREFIX) || !string.endsWith(TOOLING_EVENT_NAME_POSTFIX)) {
            return false;
        }
        String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(Handler.ENABLED_EVENTS_PROPERTY_NAME);
            }
        });
        if (string2 == null) {
            return false;
        }
        String string3 = string.substring(TOOLING_EVENT_NAME_PREFIX.length(), string.length() - TOOLING_EVENT_NAME_POSTFIX.length());
        int n = string2.indexOf(string3);
        int n2 = n + string3.length();
        return !(n < 0 || n != 0 && string2.charAt(n - 1) != ',' || n2 != string2.length() && string2.charAt(n2) != ',');
    }

    public void notifyEvent(Tooling.ToolingEvent toolingEvent) {
        if (!toolingEvent.isEventEnabled()) {
            return;
        }
        Model model = toolingEvent.getClass().getAnnotation(Model.class);
        if (model != null) {
            try {
                Class<?> clazz = Class.forName(model.value());
                EventModel eventModel = (EventModel)clazz.newInstance();
                eventModel.init(toolingEvent);
                Engine.putObject(eventModel);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
        } else {
            Engine.putObject(toolingEvent);
        }
    }

    static interface EventModel {
        public void init(Tooling.ToolingEvent var1);
    }
}

