/*
 * Decompiled with CFR 0.152.
 */
package arc.flabel;

import arc.flabel.FGlyph;
import arc.flabel.FLabel;
import arc.math.Interp;
import arc.math.Mathf;

public abstract class FEffect {
    private static final float fadeoutSplit = 0.25f;
    public int indexStart = -1;
    public int indexEnd = -1;
    public float duration = Float.POSITIVE_INFINITY;
    public String endToken;
    protected float totalTime;

    public void update(float delta) {
        this.totalTime += delta;
    }

    public final void apply(FLabel label, FGlyph glyph, int glyphIndex, float delta) {
        int localIndex = glyphIndex - this.indexStart;
        this.onApply(label, glyph, localIndex, delta);
    }

    protected abstract void onApply(FLabel var1, FGlyph var2, int var3, float var4);

    public boolean isFinished() {
        return this.totalTime > this.duration;
    }

    protected float calculateFadeout() {
        if (Float.isInfinite(this.duration)) {
            return 1.0f;
        }
        float progress = Mathf.clamp(this.totalTime / this.duration, 0.0f, 1.0f);
        if (progress < 0.25f) {
            return 1.0f;
        }
        return Interp.smooth.apply(1.0f, 0.0f, (progress - 0.25f) / 0.75f);
    }

    protected float calculateProgress(float modifier) {
        return this.calculateProgress(modifier, 0.0f, true);
    }

    protected float calculateProgress(float modifier, float offset) {
        return this.calculateProgress(modifier, offset, true);
    }

    protected float calculateProgress(float modifier, float offset, boolean pingpong) {
        float progress;
        for (progress = this.totalTime / modifier + offset; progress < 0.0f; progress += 2.0f) {
        }
        if (pingpong) {
            if ((progress %= 2.0f) > 1.0f) {
                progress = 1.0f - (progress - 1.0f);
            }
        } else {
            progress %= 1.0f;
        }
        progress = Mathf.clamp(progress, 0.0f, 1.0f);
        return progress;
    }

    protected float getLineHeight(FLabel label) {
        return label.getFontCache().getFont().getLineHeight() * label.getFontScaleY();
    }
}

