/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics;

import arc.graphics.Gl;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.TextureData;
import arc.graphics.gl.MipMapGenerator;
import arc.util.Disposable;

public abstract class GLTexture
implements Disposable {
    public final int glTarget;
    public int width;
    public int height;
    protected int glHandle;
    protected Texture.TextureFilter minFilter = Texture.TextureFilter.nearest;
    protected Texture.TextureFilter magFilter = Texture.TextureFilter.nearest;
    protected Texture.TextureWrap uWrap = Texture.TextureWrap.clampToEdge;
    protected Texture.TextureWrap vWrap = Texture.TextureWrap.clampToEdge;

    public GLTexture(int glTarget) {
        this(glTarget, Gl.genTexture());
    }

    public GLTexture(int glTarget, int glHandle) {
        this.glTarget = glTarget;
        this.glHandle = glHandle;
    }

    protected static void uploadImageData(int target, TextureData data) {
        GLTexture.uploadImageData(target, data, 0);
    }

    public static void uploadImageData(int target, TextureData data, int miplevel) {
        if (data == null) {
            return;
        }
        if (!data.isPrepared()) {
            data.prepare();
        }
        if (data.isCustom()) {
            data.consumeCustomData(target);
            return;
        }
        Pixmap pixmap = data.consumePixmap();
        boolean disposePixmap = data.disposePixmap();
        if (data.useMipMaps()) {
            MipMapGenerator.generateMipMap(target, pixmap, pixmap.width, pixmap.height);
        } else {
            Gl.texImage2D(target, miplevel, pixmap.getGLInternalFormat(), pixmap.width, pixmap.height, 0, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.pixels);
        }
        if (disposePixmap) {
            pixmap.dispose();
        }
    }

    public abstract int getDepth();

    public void bind() {
        Gl.bindTexture(this.glTarget, this.glHandle);
    }

    public void bind(int unit) {
        Gl.activeTexture(33984 + unit);
        Gl.bindTexture(this.glTarget, this.glHandle);
    }

    public Texture.TextureFilter getMinFilter() {
        return this.minFilter;
    }

    public Texture.TextureFilter getMagFilter() {
        return this.magFilter;
    }

    public Texture.TextureWrap getUWrap() {
        return this.uWrap;
    }

    public Texture.TextureWrap getVWrap() {
        return this.vWrap;
    }

    public int getTextureObjectHandle() {
        return this.glHandle;
    }

    public void unsafeSetWrap(Texture.TextureWrap u, Texture.TextureWrap v) {
        this.unsafeSetWrap(u, v, false);
    }

    public void unsafeSetWrap(Texture.TextureWrap u, Texture.TextureWrap v, boolean force) {
        if (u != null && (force || this.uWrap != u)) {
            Gl.texParameteri(this.glTarget, 10242, u.getGLEnum());
            this.uWrap = u;
        }
        if (v != null && (force || this.vWrap != v)) {
            Gl.texParameteri(this.glTarget, 10243, v.getGLEnum());
            this.vWrap = v;
        }
    }

    public void setWrap(Texture.TextureWrap wrap) {
        this.setWrap(wrap, wrap);
    }

    public void setWrap(Texture.TextureWrap u, Texture.TextureWrap v) {
        this.uWrap = u;
        this.vWrap = v;
        this.bind();
        Gl.texParameteri(this.glTarget, 10242, u.getGLEnum());
        Gl.texParameteri(this.glTarget, 10243, v.getGLEnum());
    }

    public void unsafeSetFilter(Texture.TextureFilter minFilter, Texture.TextureFilter magFilter) {
        this.unsafeSetFilter(minFilter, magFilter, false);
    }

    public void unsafeSetFilter(Texture.TextureFilter minFilter, Texture.TextureFilter magFilter, boolean force) {
        if (minFilter != null && (force || this.minFilter != minFilter)) {
            Gl.texParameteri(this.glTarget, 10241, minFilter.glEnum);
            this.minFilter = minFilter;
        }
        if (magFilter != null && (force || this.magFilter != magFilter)) {
            Gl.texParameteri(this.glTarget, 10240, magFilter.glEnum);
            this.magFilter = magFilter;
        }
    }

    public void setFilter(Texture.TextureFilter filter) {
        this.setFilter(filter, filter);
    }

    public void setFilter(Texture.TextureFilter minFilter, Texture.TextureFilter magFilter) {
        this.minFilter = minFilter;
        this.magFilter = magFilter;
        this.bind();
        Gl.texParameteri(this.glTarget, 10241, minFilter.glEnum);
        Gl.texParameteri(this.glTarget, 10240, magFilter.glEnum);
    }

    @Override
    public void dispose() {
        if (this.glHandle != 0) {
            Gl.deleteTexture(this.glHandle);
            this.glHandle = 0;
        }
    }
}

