/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g2d;

import arc.Core;
import arc.graphics.Gl;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.gl.FrameBuffer;
import arc.graphics.gl.Shader;

public class Bloom {
    public int blurPasses = 1;
    public boolean blending = false;
    private Shader thresholdShader;
    private Shader bloomShader;
    private Shader blurShader;
    private FrameBuffer buffer;
    private FrameBuffer pingPong1;
    private FrameBuffer pingPong2;
    private float bloomIntensity;
    private float originalIntensity;
    private float threshold;
    private boolean capturing = false;
    private float r;
    private float g;
    private float b;
    private float a;

    public void resume() {
        this.bloomShader.bind();
        this.bloomShader.setUniformi("u_texture1", 1);
        this.setSize(this.pingPong1.getWidth(), this.pingPong1.getHeight());
        this.setThreshold(this.threshold);
        this.setBloomIntensity(this.bloomIntensity);
        this.setOriginalIntensity(this.originalIntensity);
    }

    public Bloom() {
        this.init(Core.graphics.getWidth() / 4, Core.graphics.getHeight() / 4, false, false);
    }

    public Bloom(boolean useBlending) {
        this.init(Core.graphics.getWidth() / 4, Core.graphics.getHeight() / 4, false, useBlending);
    }

    public Bloom(int width, int height, boolean hasDepth, boolean useBlending) {
        this.init(width, height, hasDepth, useBlending);
    }

    public void resize(int width, int height) {
        this.resize(width, height, 4);
    }

    public void resize(int width, int height, int scaling) {
        boolean changed;
        boolean bl = changed = this.pingPong1.getWidth() != width / scaling || this.pingPong1.getHeight() != height / scaling;
        if (changed) {
            this.pingPong1.resize(width / scaling, height / scaling);
            this.pingPong2.resize(width / scaling, height / scaling);
            this.buffer.resize(width, height);
            this.setSize(width / scaling, height / scaling);
        }
    }

    private void init(int width, int height, boolean hasDepth, boolean useBlending) {
        this.blending = useBlending;
        Pixmap.Format format = Pixmap.Format.rgba8888;
        this.buffer = new FrameBuffer(format, Core.graphics.getWidth(), Core.graphics.getHeight(), hasDepth);
        this.pingPong1 = new FrameBuffer(format, width, height, false);
        this.pingPong2 = new FrameBuffer(format, width, height, false);
        String alpha = useBlending ? "alpha_" : "";
        this.bloomShader = Bloom.createShader("screenspace", alpha + "bloom");
        this.thresholdShader = Bloom.createShader("screenspace", alpha + "threshold");
        this.blurShader = Bloom.createShader("blurspace", alpha + "gaussian");
        this.setSize(width, height);
        this.setBloomIntensity(2.5f);
        this.setOriginalIntensity(1.0f);
        this.setThreshold(0.5f);
        this.bloomShader.bind();
        this.bloomShader.setUniformi("u_texture1", 1);
    }

    public void setClearColor(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public void capture() {
        if (!this.capturing) {
            this.capturing = true;
            this.buffer.begin();
            Gl.clearColor(this.r, this.g, this.b, this.a);
            Gl.clear(16640);
        }
    }

    public void capturePause() {
        if (this.capturing) {
            this.capturing = false;
            this.buffer.end();
        }
    }

    public void captureContinue() {
        if (!this.capturing) {
            this.capturing = true;
            this.buffer.begin();
        }
    }

    public void render() {
        if (this.capturing) {
            this.capturing = false;
            this.buffer.end();
        }
        Gl.disable(3042);
        Gl.disable(2929);
        Gl.depthMask(false);
        this.pingPong1.begin();
        this.buffer.blit(this.thresholdShader);
        this.pingPong1.end();
        for (int i = 0; i < this.blurPasses; ++i) {
            this.pingPong2.begin();
            this.blurShader.bind();
            this.blurShader.setUniformf("dir", 1.0f, 0.0f);
            this.pingPong1.blit(this.blurShader);
            this.pingPong2.end();
            this.pingPong1.begin();
            this.blurShader.bind();
            this.blurShader.setUniformf("dir", 0.0f, 1.0f);
            this.pingPong2.blit(this.blurShader);
            this.pingPong1.end();
        }
        if (this.blending) {
            Gl.enable(3042);
            Gl.blendFunc(770, 771);
        }
        ((Texture)this.pingPong1.getTexture()).bind(1);
        this.buffer.blit(this.bloomShader);
    }

    @Deprecated
    public void setBloomIntesity(float intensity) {
        this.setBloomIntensity(intensity);
    }

    @Deprecated
    public void setOriginalIntesity(float intensity) {
        this.setOriginalIntensity(intensity);
    }

    public void setBloomIntensity(float intensity) {
        this.bloomIntensity = intensity;
        this.bloomShader.bind();
        this.bloomShader.setUniformf("BloomIntensity", intensity);
    }

    public void setOriginalIntensity(float intensity) {
        this.originalIntensity = intensity;
        this.bloomShader.bind();
        this.bloomShader.setUniformf("OriginalIntensity", intensity);
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
        this.thresholdShader.bind();
        this.thresholdShader.setUniformf("threshold", threshold, 1.0f / (1.0f - threshold));
    }

    private void setSize(int width, int height) {
        this.blurShader.bind();
        this.blurShader.setUniformf("size", (float)width, (float)height);
    }

    public FrameBuffer buffer() {
        return this.buffer;
    }

    public void dispose() {
        try {
            this.buffer.dispose();
            this.pingPong1.dispose();
            this.pingPong2.dispose();
            this.blurShader.dispose();
            this.bloomShader.dispose();
            this.thresholdShader.dispose();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Shader createShader(String vertexName, String fragmentName) {
        return new Shader(Core.files.internal("bloomshaders/" + vertexName + ".vert"), Core.files.internal("bloomshaders/" + fragmentName + ".frag"));
    }
}

