/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.gl;

import arc.Core;
import arc.files.Fi;
import arc.graphics.Pixmap;
import arc.graphics.TextureArrayData;
import arc.graphics.TextureData;
import arc.util.ArcRuntimeException;

public class FileTextureArrayData
implements TextureArrayData {
    boolean useMipMaps;
    private TextureData[] textureDatas;
    private boolean prepared;
    private int depth;

    public FileTextureArrayData(boolean useMipMaps, Fi[] files) {
        this.useMipMaps = useMipMaps;
        this.depth = files.length;
        this.textureDatas = new TextureData[files.length];
        for (int i = 0; i < files.length; ++i) {
            this.textureDatas[i] = TextureData.load(files[i], useMipMaps);
        }
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    @Override
    public void prepare() {
        int width = -1;
        int height = -1;
        for (TextureData data : this.textureDatas) {
            data.prepare();
            if (width == -1) {
                width = data.getWidth();
                height = data.getHeight();
                continue;
            }
            if (width == data.getWidth() && height == data.getHeight()) continue;
            throw new ArcRuntimeException("Error whilst preparing TextureArray: TextureArray Textures must have equal dimensions.");
        }
        this.prepared = true;
    }

    @Override
    public void consumeTextureArrayData() {
        for (int i = 0; i < this.textureDatas.length; ++i) {
            if (this.textureDatas[i].isCustom()) {
                this.textureDatas[i].consumeCustomData(35866);
                continue;
            }
            TextureData texData = this.textureDatas[i];
            Pixmap pixmap = texData.consumePixmap();
            boolean disposePixmap = texData.disposePixmap();
            Core.gl30.glTexSubImage3D(35866, 0, 0, 0, i, pixmap.width, pixmap.height, 1, pixmap.getGLInternalFormat(), pixmap.getGLType(), pixmap.pixels);
            if (!disposePixmap) continue;
            pixmap.dispose();
        }
    }

    @Override
    public int getWidth() {
        return this.textureDatas[0].getWidth();
    }

    @Override
    public int getHeight() {
        return this.textureDatas[0].getHeight();
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getInternalFormat() {
        return 5121;
    }

    @Override
    public int getGLType() {
        return 6408;
    }
}

