/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.gl;

import arc.graphics.Gl;
import arc.graphics.gl.IndexData;
import arc.graphics.gl.Shader;
import arc.util.ArcRuntimeException;
import arc.util.Disposable;
import java.nio.FloatBuffer;

public interface VertexData
extends Disposable {
    default public void render(IndexData indices, int primitiveType, int offset, int count) {
        if (indices.size() > 0) {
            if (count + offset > indices.max()) {
                throw new ArcRuntimeException("Mesh attempting to access memory outside of the index buffer (count: " + count + ", offset: " + offset + ", max: " + indices.max() + ")");
            }
            Gl.drawElements(primitiveType, count, 5123, offset * 2);
        } else {
            Gl.drawArrays(primitiveType, offset, count);
        }
    }

    public int size();

    public int max();

    public void set(float[] var1, int var2, int var3);

    public void update(int var1, float[] var2, int var3, int var4);

    public FloatBuffer buffer();

    public void bind(Shader var1);

    public void unbind(Shader var1);
}

