/*
 * Decompiled with CFR 0.152.
 */
package arc.math.geom;

import arc.func.Cons;
import arc.math.geom.Rect;
import arc.struct.Seq;
import java.util.Iterator;

public class QuadTree<T extends QuadTreeObject> {
    protected final Rect tmp = new Rect();
    protected static final int maxObjectsPerNode = 5;
    public Rect bounds;
    public Seq<T> objects = new Seq(false);
    public QuadTree<T> botLeft;
    public QuadTree<T> botRight;
    public QuadTree<T> topLeft;
    public QuadTree<T> topRight;
    public boolean leaf = true;
    public int totalObjects;

    public QuadTree(Rect bounds) {
        this.bounds = bounds;
    }

    protected void split() {
        if (!this.leaf) {
            return;
        }
        float subW = this.bounds.width / 2.0f;
        float subH = this.bounds.height / 2.0f;
        if (this.botLeft == null) {
            this.botLeft = this.newChild(new Rect(this.bounds.x, this.bounds.y, subW, subH));
            this.botRight = this.newChild(new Rect(this.bounds.x + subW, this.bounds.y, subW, subH));
            this.topLeft = this.newChild(new Rect(this.bounds.x, this.bounds.y + subH, subW, subH));
            this.topRight = this.newChild(new Rect(this.bounds.x + subW, this.bounds.y + subH, subW, subH));
        }
        this.leaf = false;
        Iterator<T> iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            QuadTreeObject obj = (QuadTreeObject)iterator.next();
            this.hitbox(obj);
            QuadTree<QuadTreeObject> child = this.getFittingChild(this.tmp);
            if (child == null) continue;
            child.insert(obj);
            iterator.remove();
        }
    }

    protected void unsplit() {
        if (this.leaf) {
            return;
        }
        this.objects.addAll(this.botLeft.objects);
        this.objects.addAll(this.botRight.objects);
        this.objects.addAll(this.topLeft.objects);
        this.objects.addAll(this.topRight.objects);
        this.botLeft.clear();
        this.botRight.clear();
        this.topLeft.clear();
        this.topRight.clear();
        this.leaf = true;
    }

    public void insert(T obj) {
        this.hitbox(obj);
        if (!this.bounds.overlaps(this.tmp)) {
            return;
        }
        ++this.totalObjects;
        if (this.leaf && this.objects.size + 1 > 5) {
            this.split();
        }
        if (this.leaf) {
            this.objects.add(obj);
        } else {
            this.hitbox(obj);
            QuadTree<T> child = this.getFittingChild(this.tmp);
            if (child != null) {
                child.insert(obj);
            } else {
                this.objects.add(obj);
            }
        }
    }

    public boolean remove(T obj) {
        boolean result;
        if (this.leaf) {
            result = this.objects.remove(obj, true);
        } else {
            this.hitbox(obj);
            QuadTree<T> child = this.getFittingChild(this.tmp);
            result = child != null ? child.remove(obj) : this.objects.remove(obj, true);
            if (this.totalObjects <= 5) {
                this.unsplit();
            }
        }
        if (result) {
            --this.totalObjects;
        }
        return result;
    }

    public void clear() {
        this.objects.clear();
        this.totalObjects = 0;
        if (!this.leaf) {
            this.topLeft.clear();
            this.topRight.clear();
            this.botLeft.clear();
            this.botRight.clear();
        }
        this.leaf = true;
    }

    protected QuadTree<T> getFittingChild(Rect boundingBox) {
        boolean bottomQuadrant;
        float verticalMidpoint = this.bounds.x + this.bounds.width / 2.0f;
        float horizontalMidpoint = this.bounds.y + this.bounds.height / 2.0f;
        boolean topQuadrant = boundingBox.y > horizontalMidpoint;
        boolean bl = bottomQuadrant = boundingBox.y < horizontalMidpoint && boundingBox.y + boundingBox.height < horizontalMidpoint;
        if (boundingBox.x < verticalMidpoint && boundingBox.x + boundingBox.width < verticalMidpoint) {
            if (topQuadrant) {
                return this.topLeft;
            }
            if (bottomQuadrant) {
                return this.botLeft;
            }
        } else if (boundingBox.x > verticalMidpoint) {
            if (topQuadrant) {
                return this.topRight;
            }
            if (bottomQuadrant) {
                return this.botRight;
            }
        }
        return null;
    }

    public void intersect(float x, float y, float width, float height, Cons<T> out) {
        if (!this.leaf) {
            if (this.topLeft.bounds.overlaps(x, y, width, height)) {
                this.topLeft.intersect(x, y, width, height, out);
            }
            if (this.topRight.bounds.overlaps(x, y, width, height)) {
                this.topRight.intersect(x, y, width, height, out);
            }
            if (this.botLeft.bounds.overlaps(x, y, width, height)) {
                this.botLeft.intersect(x, y, width, height, out);
            }
            if (this.botRight.bounds.overlaps(x, y, width, height)) {
                this.botRight.intersect(x, y, width, height, out);
            }
        }
        Seq<T> objects = this.objects;
        for (int i = 0; i < objects.size; ++i) {
            QuadTreeObject item = (QuadTreeObject)objects.items[i];
            this.hitbox(item);
            if (!this.tmp.overlaps(x, y, width, height)) continue;
            out.get(item);
        }
    }

    public boolean any(float x, float y, float width, float height) {
        if (!this.leaf) {
            if (this.topLeft.bounds.overlaps(x, y, width, height) && this.topLeft.any(x, y, width, height)) {
                return true;
            }
            if (this.topRight.bounds.overlaps(x, y, width, height) && this.topRight.any(x, y, width, height)) {
                return true;
            }
            if (this.botLeft.bounds.overlaps(x, y, width, height) && this.botLeft.any(x, y, width, height)) {
                return true;
            }
            if (this.botRight.bounds.overlaps(x, y, width, height) && this.botRight.any(x, y, width, height)) {
                return true;
            }
        }
        Seq<T> objects = this.objects;
        for (int i = 0; i < objects.size; ++i) {
            QuadTreeObject item = (QuadTreeObject)objects.items[i];
            this.hitbox(item);
            if (!this.tmp.overlaps(x, y, width, height)) continue;
            return true;
        }
        return false;
    }

    public void intersect(Rect rect, Cons<T> out) {
        this.intersect(rect.x, rect.y, rect.width, rect.height, out);
    }

    public void intersect(Rect toCheck, Seq<T> out) {
        this.intersect(toCheck.x, toCheck.y, toCheck.width, toCheck.height, out);
    }

    public void intersect(float x, float y, float width, float height, Seq<T> out) {
        if (!this.leaf) {
            if (this.topLeft.bounds.overlaps(x, y, width, height)) {
                this.topLeft.intersect(x, y, width, height, out);
            }
            if (this.topRight.bounds.overlaps(x, y, width, height)) {
                this.topRight.intersect(x, y, width, height, out);
            }
            if (this.botLeft.bounds.overlaps(x, y, width, height)) {
                this.botLeft.intersect(x, y, width, height, out);
            }
            if (this.botRight.bounds.overlaps(x, y, width, height)) {
                this.botRight.intersect(x, y, width, height, out);
            }
        }
        Seq<T> objects = this.objects;
        for (int i = 0; i < objects.size; ++i) {
            QuadTreeObject item = (QuadTreeObject)objects.items[i];
            this.hitbox(item);
            if (!this.tmp.overlaps(x, y, width, height)) continue;
            out.add(item);
        }
    }

    public void getObjects(Seq<T> out) {
        out.addAll(this.objects);
        if (!this.leaf) {
            this.topLeft.getObjects(out);
            this.topRight.getObjects(out);
            this.botLeft.getObjects(out);
            this.botRight.getObjects(out);
        }
    }

    protected QuadTree<T> newChild(Rect rect) {
        return new QuadTree<T>(rect);
    }

    protected void hitbox(T t) {
        t.hitbox(this.tmp);
    }

    public static interface QuadTreeObject {
        public void hitbox(Rect var1);
    }
}

