/*
 * Decompiled with CFR 0.152.
 */
package arc.net.dns;

import arc.net.dns.AbstractNameserverProvider;
import arc.net.dns.NameserverProvider;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.OS;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public final class JndiContextNameserverProvider
implements NameserverProvider {
    private InnerJndiContextNameserverProvider inner;

    public JndiContextNameserverProvider() {
        if (!OS.isAndroid) {
            try {
                this.inner = new InnerJndiContextNameserverProvider();
            }
            catch (Throwable e) {
                Log.debug("[DNS] JNDI DNS not available");
            }
        }
    }

    @Override
    public void initialize() {
        this.inner.initialize();
    }

    @Override
    public Seq<InetSocketAddress> getNameservers() {
        return this.inner.getNameservers();
    }

    @Override
    public boolean isEnabled() {
        return this.inner != null;
    }

    private static final class InnerJndiContextNameserverProvider
    extends AbstractNameserverProvider {
        private InnerJndiContextNameserverProvider() {
        }

        @Override
        public void initialize() {
            this.reset();
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            env.put("java.naming.provider.url", "dns://");
            String servers = null;
            try {
                InitialDirContext ctx = new InitialDirContext(env);
                servers = (String)ctx.getEnvironment().get("java.naming.provider.url");
                ctx.close();
            }
            catch (NamingException ctx) {
                // empty catch block
            }
            if (servers != null) {
                StringTokenizer st = new StringTokenizer(servers, " ");
                while (st.hasMoreTokens()) {
                    String server = st.nextToken();
                    try {
                        URI serverUri = new URI(server);
                        String host = serverUri.getHost();
                        if (host == null || host.isEmpty()) continue;
                        int port = serverUri.getPort();
                        if (port == -1) {
                            port = 53;
                        }
                        this.addNameServer(new InetSocketAddress(host, port));
                    }
                    catch (URISyntaxException e) {
                        Log.debug("[DNS] Could not parse @ as a dns server, ignoring: @", server, e);
                    }
                }
            }
        }

        static {
            Log.debug("[DNS] JNDI class: @", DirContext.class.getName());
        }
    }
}

