/*
 * Decompiled with CFR 0.152.
 */
package arc.scene.style;

import arc.graphics.g2d.NinePatch;
import arc.scene.style.NinePatchDrawable;
import arc.scene.ui.layout.Scl;

public class ScaledNinePatchDrawable
extends NinePatchDrawable {
    private float scale = Scl.scl(1.0f);

    public ScaledNinePatchDrawable(NinePatch patch) {
        this(patch, 1.0f);
    }

    public ScaledNinePatchDrawable(NinePatch patch, float multiplier) {
        this.scale = Scl.scl(multiplier);
        this.setPatch(patch);
    }

    public ScaledNinePatchDrawable(NinePatchDrawable drawable) {
        super(drawable);
    }

    @Override
    public void draw(float x, float y, float width, float height) {
        this.getPatch().draw(x, y, 0.0f, 0.0f, width / this.scale, height / this.scale, this.scale, this.scale, 0.0f);
    }

    @Override
    public void setPatch(NinePatch patch) {
        super.setPatch(patch);
        this.setMinWidth(patch.getTotalWidth() * this.scale);
        this.setMinHeight(patch.getTotalHeight() * this.scale);
    }

    @Override
    public float getLeftWidth() {
        return this.patch.getPadLeft() * this.scale;
    }

    @Override
    public float getRightWidth() {
        return this.patch.getPadRight() * this.scale;
    }

    @Override
    public float getTopHeight() {
        return this.patch.getPadTop() * this.scale;
    }

    @Override
    public float getBottomHeight() {
        return this.patch.getPadBottom() * this.scale;
    }
}

