/*
 * Decompiled with CFR 0.152.
 */
package arc.scene.style;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.scene.style.BaseDrawable;
import arc.scene.style.Drawable;
import arc.scene.style.TransformDrawable;
import arc.scene.ui.layout.Scl;
import arc.util.Tmp;

public class TextureRegionDrawable
extends BaseDrawable
implements TransformDrawable {
    protected TextureRegion region;
    protected Color tint = new Color(1.0f, 1.0f, 1.0f);
    protected float scale = 1.0f;

    public TextureRegionDrawable() {
    }

    public TextureRegionDrawable(TextureRegion region) {
        this.setRegion(region);
    }

    public TextureRegionDrawable(TextureRegion region, float scale) {
        this.scale = scale;
        this.setRegion(region);
    }

    public TextureRegionDrawable(TextureRegionDrawable drawable) {
        super(drawable);
        this.setRegion(drawable.region);
    }

    @Override
    public float imageSize() {
        return this.region.width;
    }

    @Override
    public void draw(float x, float y, float width, float height) {
        Draw.color(Tmp.c1.set(this.tint).mul(Draw.getColor()).toFloatBits());
        Draw.rect(this.region, x + width / 2.0f, y + height / 2.0f, width, height);
    }

    @Override
    public void draw(float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
        Draw.color(Tmp.c1.set(this.tint).mul(Draw.getColor()).toFloatBits());
        Draw.rect(this.region, x + width / 2.0f, y + height / 2.0f, width * scaleX, height * scaleY, originX, originY, rotation);
    }

    public TextureRegionDrawable set(TextureRegion region) {
        this.setRegion(region);
        return this;
    }

    public TextureRegion getRegion() {
        return this.region;
    }

    public void setRegion(TextureRegion region) {
        this.region = region;
        this.setMinWidth(Scl.scl(this.scale * (float)region.width));
        this.setMinHeight(Scl.scl(this.scale * (float)region.height));
    }

    public Drawable tint(float r, float g, float b, float a) {
        return this.tint(Tmp.c1.set(r, g, b, a));
    }

    public Drawable tint(Color tint) {
        TextureRegionDrawable drawable = new TextureRegionDrawable(this.region);
        drawable.tint.set(tint);
        return drawable;
    }
}

