/*
 * Decompiled with CFR 0.152.
 */
package arc.scene.ui.layout;

import arc.scene.Element;
import arc.scene.event.Touchable;
import arc.scene.ui.layout.WidgetGroup;
import arc.struct.SnapshotSeq;

public class Stack
extends WidgetGroup {
    private float prefWidth;
    private float prefHeight;
    private float minWidth;
    private float minHeight;
    private boolean sizeInvalid = true;

    public Stack() {
        this.setTransform(false);
        this.setWidth(150.0f);
        this.setHeight(150.0f);
        this.touchable = Touchable.childrenOnly;
    }

    public Stack(Element ... actors) {
        this();
        for (Element actor : actors) {
            this.addChild(actor);
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.sizeInvalid = true;
    }

    private void computeSize() {
        this.sizeInvalid = false;
        this.prefWidth = 0.0f;
        this.prefHeight = 0.0f;
        this.minWidth = 0.0f;
        this.minHeight = 0.0f;
        SnapshotSeq<Element> children = this.getChildren();
        int n = children.size;
        for (int i = 0; i < n; ++i) {
            Element child = (Element)children.get(i);
            if (child != null) {
                this.prefWidth = Math.max(this.prefWidth, child.getPrefWidth());
                this.prefHeight = Math.max(this.prefHeight, child.getPrefHeight());
                this.minWidth = Math.max(this.minWidth, child.getMinWidth());
                this.minHeight = Math.max(this.minHeight, child.getMinHeight());
                continue;
            }
            this.prefWidth = Math.max(this.prefWidth, child.getWidth());
            this.prefHeight = Math.max(this.prefHeight, child.getHeight());
            this.minWidth = Math.max(this.minWidth, child.getWidth());
            this.minHeight = Math.max(this.minHeight, child.getHeight());
        }
    }

    public void add(Element actor) {
        this.addChild(actor);
    }

    @Override
    public void layout() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        float width = this.getWidth();
        float height = this.getHeight();
        SnapshotSeq<Element> children = this.getChildren();
        int n = children.size;
        for (int i = 0; i < n; ++i) {
            Element child = (Element)children.get(i);
            child.setBounds(0.0f, 0.0f, width, height);
            if (child == null) continue;
            child.validate();
        }
    }

    @Override
    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefHeight;
    }

    @Override
    public float getMinWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.minWidth;
    }

    @Override
    public float getMinHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.minHeight;
    }
}

