/*
 * Decompiled with CFR 0.152.
 */
package arc.util;

import arc.struct.ObjectMap;
import arc.util.Log;
import arc.util.Time;

public class Bench {
    private static long totalStart;
    private static String lastName;
    private static ObjectMap<String, Long> times;
    private static long last;

    public static void begin(String name) {
        if (lastName != null) {
            Bench.endi();
        } else {
            totalStart = Time.millis();
        }
        last = Time.millis();
        lastName = name;
    }

    public static void end() {
        Bench.endi();
        long total = Time.timeSinceMillis(totalStart);
        times.each((name, time) -> Log.info("[PERF] @: @ms (@%)", name, time, (int)((float)time.longValue() / (float)total * 100.0f)));
        Log.info("[PERF] TOTAL: @ms", total);
    }

    private static void endi() {
        times.put(lastName, Time.timeSinceMillis(last));
        lastName = null;
    }

    static {
        times = new ObjectMap();
    }
}

