/*
 * Decompiled with CFR 0.152.
 */
package arc.util;

import arc.func.Cons;
import arc.struct.ObjectMap;
import arc.struct.Seq;

public class CommandHandler {
    public String prefix = "";
    private final ObjectMap<String, Command> commands = new ObjectMap();
    private final Seq<Command> orderedCommands = new Seq();

    public CommandHandler(String prefix) {
        this.prefix = prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public CommandResponse handleMessage(String message) {
        return this.handleMessage(message, null);
    }

    public CommandResponse handleMessage(String message, Object params) {
        if (message == null || !message.startsWith(this.prefix)) {
            return new CommandResponse(ResponseType.noCommand, null, null);
        }
        String commandstr = (message = message.substring(this.prefix.length())).contains(" ") ? message.substring(0, message.indexOf(" ")) : message;
        String argstr = message.contains(" ") ? message.substring(commandstr.length() + 1) : "";
        Seq<String> result = new Seq<String>();
        Command command = this.commands.get(commandstr);
        if (command != null) {
            int index = 0;
            boolean satisfied = false;
            while (true) {
                if (index >= command.params.length && !argstr.isEmpty()) {
                    return new CommandResponse(ResponseType.manyArguments, command, commandstr);
                }
                if (argstr.isEmpty()) break;
                if (command.params[index].optional || index >= command.params.length - 1 || command.params[index + 1].optional) {
                    satisfied = true;
                }
                if (command.params[index].variadic) {
                    result.add(argstr);
                    break;
                }
                int next = argstr.indexOf(" ");
                if (next == -1) {
                    if (!satisfied) {
                        return new CommandResponse(ResponseType.fewArguments, command, commandstr);
                    }
                    result.add(argstr);
                    break;
                }
                String arg = argstr.substring(0, next);
                argstr = argstr.substring(arg.length() + 1);
                result.add(arg);
                ++index;
            }
            if (!satisfied && command.params.length > 0 && !command.params[0].optional) {
                return new CommandResponse(ResponseType.fewArguments, command, commandstr);
            }
            command.runner.accept((String[])result.toArray(String.class), params);
            return new CommandResponse(ResponseType.valid, command, commandstr);
        }
        return new CommandResponse(ResponseType.unknownCommand, null, commandstr);
    }

    public void removeCommand(String text) {
        Command c = this.commands.get(text);
        if (c == null) {
            return;
        }
        this.commands.remove(text);
        this.orderedCommands.remove(c);
    }

    public <T> Command register(String text, String description, CommandRunner<T> runner) {
        return this.register(text, "", description, runner);
    }

    public <T> Command register(String text, String params, String description, CommandRunner<T> runner) {
        this.orderedCommands.remove(c -> c.text.equals(text));
        Command cmd = new Command(text, params, description, runner);
        this.commands.put(text.toLowerCase(), cmd);
        this.orderedCommands.add(cmd);
        return cmd;
    }

    public Command register(String text, String description, Cons<String[]> runner) {
        return this.register(text, description, (String[] args, T p) -> runner.get(args));
    }

    public Command register(String text, String params, String description, Cons<String[]> runner) {
        return this.register(text, params, description, (String[] args, T p) -> runner.get(args));
    }

    public Seq<Command> getCommandList() {
        return this.orderedCommands;
    }

    public static class CommandResponse {
        public final ResponseType type;
        public final Command command;
        public final String runCommand;

        public CommandResponse(ResponseType type, Command command, String runCommand) {
            this.type = type;
            this.command = command;
            this.runCommand = runCommand;
        }
    }

    public static enum ResponseType {
        noCommand,
        unknownCommand,
        fewArguments,
        manyArguments,
        valid;

    }

    public static class Command {
        public final String text;
        public final String paramText;
        public final String description;
        public final CommandParam[] params;
        final CommandRunner runner;

        public Command(String text, String paramText, String description, CommandRunner runner) {
            this.text = text;
            this.paramText = paramText;
            this.runner = runner;
            this.description = description;
            String[] psplit = paramText.split(" ");
            if (paramText.length() == 0) {
                this.params = new CommandParam[0];
            } else {
                this.params = new CommandParam[psplit.length];
                boolean hadOptional = false;
                for (int i = 0; i < this.params.length; ++i) {
                    String fname;
                    boolean optional;
                    String param = psplit[i];
                    if (param.length() <= 2) {
                        throw new IllegalArgumentException("Malformed param '" + param + "'");
                    }
                    char l = param.charAt(0);
                    char r = param.charAt(param.length() - 1);
                    boolean variadic = false;
                    if (l == '<' && r == '>') {
                        if (hadOptional) {
                            throw new IllegalArgumentException("Can't have non-optional param after optional param!");
                        }
                        optional = false;
                    } else if (l == '[' && r == ']') {
                        optional = true;
                    } else {
                        throw new IllegalArgumentException("Malformed param '" + param + "'");
                    }
                    if (optional) {
                        hadOptional = true;
                    }
                    if ((fname = param.substring(1, param.length() - 1)).endsWith("...")) {
                        if (i != this.params.length - 1) {
                            throw new IllegalArgumentException("A variadic parameter should be the last parameter!");
                        }
                        fname = fname.substring(0, fname.length() - 3);
                        variadic = true;
                    }
                    this.params[i] = new CommandParam(fname, optional, variadic);
                }
            }
        }
    }

    public static class CommandParam {
        public final String name;
        public final boolean optional;
        public final boolean variadic;

        public CommandParam(String name, boolean optional, boolean variadic) {
            this.name = name;
            this.optional = optional;
            this.variadic = variadic;
        }
    }

    public static interface CommandRunner<T> {
        public void accept(String[] var1, T var2);
    }
}

