/*
 * Decompiled with CFR 0.152.
 */
package arc.util;

import arc.Core;
import arc.func.Prov;
import arc.struct.Seq;
import arc.util.ArcRuntimeException;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.OS;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Threads {
    public static <T> ThreadLocal<T> local(final Prov<T> prov) {
        return new ThreadLocal<T>(){

            @Override
            protected T initialValue() {
                return prov.get();
            }
        };
    }

    public static <T> T await(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new ArcRuntimeException(ex.getCause());
        }
    }

    public static void awaitAll(Seq<Future<?>> futures) {
        try {
            for (Future<?> f : futures) {
                f.get();
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new ArcRuntimeException(ex.getCause());
        }
    }

    public static ExecutorService executor(@Nullable String name, int threads) {
        return Executors.newFixedThreadPool(threads, r -> Threads.newThread(r, name, true));
    }

    public static ExecutorService executor(int threads) {
        return Executors.newFixedThreadPool(threads, r -> Threads.newThread(r, null, true));
    }

    public static ExecutorService executor(@Nullable String name) {
        return Threads.executor(name, OS.cores);
    }

    public static ExecutorService executor() {
        return Threads.executor(null);
    }

    public static ExecutorService unboundedExecutor(@Nullable String name, int min) {
        return new ThreadPoolExecutor(min, Integer.MAX_VALUE, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), r -> Threads.newThread(r, name, true));
    }

    public static ExecutorService unboundedExecutor(@Nullable String name) {
        return Threads.unboundedExecutor(name, 0);
    }

    public static ExecutorService unboundedExecutor() {
        return Threads.unboundedExecutor(null);
    }

    public static ExecutorService boundedExecutor(@Nullable String name, int max) {
        return new ThreadPoolExecutor(1, max, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), r -> Threads.newThread(r, name, true));
    }

    public static void await(ExecutorService exec) {
        try {
            exec.shutdown();
            exec.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sleep(long ms, int ns) {
        try {
            Thread.sleep(ms, ns);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void throwAppException(Throwable t) {
        Core.app.post(() -> {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        });
    }

    public static Thread thread(Runnable runnable) {
        return Threads.thread(null, runnable);
    }

    public static Thread thread(@Nullable String name, Runnable runnable) {
        Thread thread = Threads.newThread(runnable, name, false);
        thread.start();
        return thread;
    }

    public static Thread daemon(Runnable runnable) {
        return Threads.daemon(null, runnable);
    }

    public static Thread daemon(@Nullable String name, Runnable runnable) {
        Thread thread = Threads.newThread(runnable, name, true);
        thread.start();
        return thread;
    }

    private static Thread newThread(Runnable r, @Nullable String name, boolean daemon) {
        Thread thread = name == null ? new Thread(r) : new Thread(r, name);
        thread.setDaemon(daemon);
        thread.setUncaughtExceptionHandler((t, e) -> Log.err(e));
        return thread;
    }
}

