/*
 * Decompiled with CFR 0.152.
 */
package arc.util.io;

import arc.func.Floatc;
import arc.util.Buffers;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public final class Streams {
    public static final int defaultBufferSize = 4096;
    public static final byte[] emptyBytes = new byte[0];

    public static void copy(InputStream input, OutputStream output) throws IOException {
        Streams.copy(input, output, new byte[4096]);
    }

    public static void copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        Streams.copy(input, output, new byte[bufferSize]);
    }

    public static void copy(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int bytesRead;
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
    }

    public static void copyProgress(InputStream input, OutputStream output, long totalLength, int bufferSize, Floatc progress) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[bufferSize];
        long totalRead = 0L;
        while ((bytesRead = input.read(buffer)) != -1) {
            progress.get((float)(totalRead += (long)bytesRead) / (float)totalLength);
            output.write(buffer, 0, bytesRead);
        }
    }

    public static void copy(InputStream input, ByteBuffer output) throws IOException {
        Streams.copy(input, output, new byte[4096]);
    }

    public static void copy(InputStream input, ByteBuffer output, int bufferSize) throws IOException {
        Streams.copy(input, output, new byte[bufferSize]);
    }

    public static int copy(InputStream input, ByteBuffer output, byte[] buffer) throws IOException {
        int bytesRead;
        int startPosition = output.position();
        int total = 0;
        while ((bytesRead = input.read(buffer)) != -1) {
            Buffers.copy(buffer, 0, (Buffer)output, bytesRead);
            output.position(startPosition + (total += bytesRead));
        }
        output.position(startPosition);
        return total;
    }

    public static byte[] copyBytes(InputStream input) throws IOException {
        return Streams.copyBytes(input, input.available());
    }

    public static byte[] copyBytes(InputStream input, int estimatedSize) throws IOException {
        OptimizedByteArrayOutputStream baos = new OptimizedByteArrayOutputStream(Math.max(0, estimatedSize));
        Streams.copy(input, baos);
        return ((ByteArrayOutputStream)baos).toByteArray();
    }

    public static String copyString(InputStream input) throws IOException {
        return Streams.copyString(input, input.available(), null);
    }

    public static String copyString(InputStream input, int estimatedSize) throws IOException {
        return Streams.copyString(input, estimatedSize, null);
    }

    public static String copyString(InputStream input, int estimatedSize, String charset) throws IOException {
        int charsRead;
        InputStreamReader reader = new InputStreamReader(input, charset == null ? "UTF-8" : charset);
        StringWriter writer = new StringWriter(Math.max(0, estimatedSize));
        char[] buffer = new char[4096];
        while ((charsRead = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, charsRead);
        }
        return writer.toString();
    }

    public static void close(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class OptimizedByteArrayOutputStream
    extends ByteArrayOutputStream {
        public OptimizedByteArrayOutputStream(int initialSize) {
            super(initialSize);
        }

        @Override
        public synchronized byte[] toByteArray() {
            if (this.count == this.buf.length) {
                return this.buf;
            }
            return super.toByteArray();
        }

        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

