/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai;

import arc.Events;
import arc.graphics.g2d.Draw;
import arc.math.Mathf;
import arc.math.geom.Intersector;
import arc.math.geom.Vec2;
import arc.struct.IntSet;
import arc.struct.ObjectFloatMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.OS;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ai.types.CommandAI;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.entities.Units;
import mindustry.entities.units.UnitController;
import mindustry.game.EventType;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.logic.Ranged;
import mindustry.ui.Fonts;
import mindustry.world.blocks.defense.turrets.BaseTurret;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.meta.BlockFlag;

public class RtsAI {
    static final Seq<Building> targets = new Seq();
    static final Seq<Unit> squad = new Seq(false);
    static final IntSet used = new IntSet();
    static final IntSet assignedTargets = new IntSet();
    static final IntSet invalidTarget = new IntSet();
    static final float squadRadius = 140.0f;
    static final int timeUpdate = 0;
    static final int timerSpawn = 1;
    static final int maxTargetsChecked = 15;
    static final BlockFlag[] flags = new BlockFlag[]{BlockFlag.generator, BlockFlag.factory, BlockFlag.core, BlockFlag.battery, BlockFlag.drill};
    static final ObjectFloatMap<Building> weights = new ObjectFloatMap();
    static final boolean debug = OS.hasProp("mindustry.debug");
    final Interval timer = new Interval(10);
    final Teams.TeamData data;
    final ObjectSet<Building> damagedSet = new ObjectSet();
    final Seq<Building> damaged = new Seq(false);

    public RtsAI(Teams.TeamData data) {
        this.data = data;
        this.timer.reset(0, Mathf.random(120.0f));
        if (debug) {
            Events.run((Object)EventType.Trigger.draw, () -> Draw.draw(120.0f, () -> {
                float s = Fonts.outline.getScaleX();
                Fonts.outline.getData().setScale(0.5f);
                for (ObjectFloatMap.Entry entry : weights) {
                    Fonts.outline.draw("[sky]" + Strings.fixed(entry.value, 2), ((Building)entry.key).x, ((Building)entry.key).y, 1);
                }
                Fonts.outline.getData().setScale(s);
            }));
        }
    }

    public void update() {
        if (this.timer.get(0, 120.0f)) {
            this.assignSquads();
            this.checkBuilding();
        }
    }

    void checkBuilding() {
        if (this.data.team.rules().aiCoreSpawn && this.timer.get(1, 420.0f) && this.data.hasCore()) {
            CoreBlock block = (CoreBlock)this.data.core().block;
            int coreUnits = this.data.countType(block.unitType);
            if (coreUnits < this.data.cores.size) {
                Unit unit = block.unitType.create(this.data.team);
                unit.set(this.data.cores.random());
                unit.add();
                Fx.spawn.at(unit);
            }
        }
    }

    void assignSquads() {
        assignedTargets.clear();
        used.clear();
        this.damaged.addAll((Iterable<Building>)this.damagedSet);
        this.damagedSet.clear();
        boolean didDefend = false;
        for (Unit unit : this.data.units) {
            if (!used.add(unit.id) || !unit.isCommandable() || unit.command().hasCommand() || unit.command().isAttacking()) continue;
            squad.clear();
            this.data.tree().intersect(unit.x - 70.0f, unit.y - 70.0f, 140.0f, 140.0f, squad);
            squad.truncate(this.data.team.rules().rtsMaxSquad);
            squad.removeAll(u -> u != unit && used.contains(u.id) || !u.isCommandable() || u.command().hasCommand() || u.flag == 0.0 != (unit.flag == 0.0));
            for (Unit item : squad) {
                used.add(item.id);
            }
            if (!this.handleSquad(squad, !didDefend)) continue;
            didDefend = true;
        }
        this.damaged.clear();
    }

    boolean handleSquad(Seq<Unit> units, boolean noDefenders) {
        Building build;
        float aay;
        float aax;
        Building best;
        if (units.isEmpty()) {
            return false;
        }
        float health = 0.0f;
        float dps = 0.0f;
        float ax = 0.0f;
        float ay = 0.0f;
        boolean targetAir = true;
        boolean targetGround = true;
        for (Unit unit : units) {
            if (!unit.type.targetAir) {
                targetAir = false;
            }
            if (!unit.type.targetGround) {
                targetGround = false;
            }
            ax += unit.x;
            ay += unit.y;
            health += unit.health;
            dps += unit.type.dpsEstimate;
        }
        ax /= (float)units.size;
        ay /= (float)units.size;
        if (debug) {
            Vars.ui.showLabel("Squad: " + units.size, 2.0f, ax, ay);
        }
        Building defend = null;
        boolean defendingCore = false;
        if (this.damaged.size > 0 && (best = this.damaged.min(arg_0 -> RtsAI.lambda$handleSquad$4(aax = ax, aay = ay, arg_0))) != null && (best instanceof CoreBlock.CoreBuild || units.size >= this.data.team.rules().rtsMinSquad || units.size > 0 && units.first().flag != 0.0 || best.within(ax, ay, 1000.0f))) {
            defend = best;
            if (debug) {
                Vars.ui.showLabel("Defend, dst = " + (int)best.dst(ax, ay), 8.0f, best.x, best.y);
            }
            if (best instanceof CoreBlock.CoreBuild) {
                defendingCore = true;
            }
        }
        boolean tair = targetAir;
        boolean tground = targetGround;
        Vec2 defendPos = null;
        Unit defendTarget = null;
        if (defend != null) {
            float checkRange = 350.0f;
            Unit aggressor = Units.closestEnemy(this.data.team, defend.x, defend.y, checkRange, u -> u.checkTarget(tair, tground));
            if (aggressor != null) {
                defendPos = new Vec2(aggressor.x, aggressor.y);
                defendTarget = aggressor;
            } else {
                float mindst = Float.MAX_VALUE;
                Building build2 = null;
                for (Building turret : Vars.indexer.getEnemy(this.data.team, BlockFlag.turret)) {
                    float dst;
                    if (!turret.within(defend, ((Ranged)((Object)turret)).range()) || !((dst = turret.dst2(defend)) < mindst)) continue;
                    mindst = dst;
                    build2 = turret;
                }
                if (build2 != null) {
                    defendTarget = build2;
                }
            }
        }
        boolean anyDefend = defendPos != null || defendTarget != null;
        invalidTarget.clear();
        for (Unit unit : squad) {
            UnitController unitController = unit.controller();
            if (!(unitController instanceof CommandAI)) continue;
            CommandAI ai = (CommandAI)unitController;
            invalidTarget.addAll(ai.unreachableBuildings);
        }
        Building building = anyDefend ? null : (build = this.findTarget(ax, ay, units.size, dps, health, units.first().flag == 0.0));
        if (build != null || anyDefend) {
            for (Unit unit : units) {
                if (!unit.isCommandable() || unit.command().hasCommand()) continue;
                if (defendPos != null && !unit.isPathImpassable(World.toTile(defendPos.x), World.toTile(defendPos.y))) {
                    unit.command().commandPosition(defendPos, true);
                } else {
                    unit.command().commandTarget((Teamc)(defendTarget == null ? build : defendTarget), defendTarget != null);
                }
                if (defendingCore) continue;
                unit.flag = 1.0;
            }
        }
        return anyDefend;
    }

    @Nullable
    Building findTarget(float x, float y, int total, float dps, float health, boolean checkWeight) {
        if (total < this.data.team.rules().rtsMinSquad) {
            return null;
        }
        targets.clear();
        for (BlockFlag flag : flags) {
            targets.addAll(Vars.indexer.getEnemy(this.data.team, flag));
        }
        targets.removeAll(b -> assignedTargets.contains(b.id) || invalidTarget.contains(b.pos()));
        if (RtsAI.targets.size == 0) {
            return null;
        }
        weights.clear();
        targets.shuffle();
        targets.truncate(15);
        for (Building target : targets) {
            weights.put(target, this.estimateStats(x, y, target.x, target.y, dps, health));
        }
        Building result = targets.min(Structs.comps(Structs.comparingFloat(b -> 1.0f - weights.get((Building)b, 0.0f) + b.dst(x, y) / 10000.0f), Structs.comparingFloat(b -> b.dst2(x, y))));
        float weight = weights.get(result, 0.0f);
        if (checkWeight && weight < this.data.team.rules().rtsMinWeight && total < Units.getCap(this.data.team)) {
            return null;
        }
        assignedTargets.add(result.id);
        return result;
    }

    float estimateStats(float fromX, float fromY, float x, float y, float selfDps, float selfHealth) {
        float timeDestroySelf;
        float[] health = new float[]{0.0f};
        float[] dps = new float[]{0.0f};
        float extraRadius = 50.0f;
        for (Building turret : Vars.indexer.getEnemy(this.data.team, BlockFlag.turret)) {
            if (!(turret instanceof BaseTurret.BaseTurretBuild)) continue;
            BaseTurret.BaseTurretBuild t = (BaseTurret.BaseTurretBuild)turret;
            if (!(Intersector.distanceSegmentPoint(fromX, fromY, x, y, t.x, t.y) <= t.range() + extraRadius)) continue;
            health[0] = health[0] + t.health;
            dps[0] = dps[0] + t.estimateDps();
        }
        Tmp.r1.set(fromX, fromY, x - fromX, y - fromY).normalize().grow(280.0f);
        Units.nearbyEnemies(this.data.team, Tmp.r1, other -> {
            if (Intersector.distanceSegmentPoint(fromX, fromY, x, y, other.x, other.y) <= other.range() + extraRadius) {
                health[0] = health[0] + other.health;
                dps[0] = dps[0] + other.type.dpsEstimate;
            }
        });
        float hp = health[0];
        float dp = dps[0];
        float timeDestroyOther = Mathf.zero(selfDps, 0.001f) ? Float.POSITIVE_INFINITY : hp / selfDps;
        float f = timeDestroySelf = Mathf.zero(dp) ? Float.POSITIVE_INFINITY : selfHealth / dp;
        if (Float.isInfinite(timeDestroyOther) || Mathf.zero(timeDestroySelf)) {
            return 0.0f;
        }
        if (Float.isInfinite(timeDestroySelf) || Mathf.zero(timeDestroyOther)) {
            return 1.0f;
        }
        return timeDestroySelf / timeDestroyOther;
    }

    private static /* synthetic */ float lambda$handleSquad$4(float aax, float aay, Building b) {
        if (b instanceof CoreBlock.CoreBuild) {
            return -999999.0f;
        }
        return b.dst(aax, aay);
    }

    static {
        Events.on(EventType.BuildDamageEvent.class, e -> {
            RtsAI ai;
            if (e.build.team.rules().rtsAi && (ai = e.build.team.data().rtsAi) != null) {
                ai.damagedSet.add(e.build);
            }
        });
    }
}

