/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.entities.units.AIController;
import mindustry.gen.Building;
import mindustry.gen.BuildingTetherc;
import mindustry.gen.Call;
import mindustry.gen.Unit;
import mindustry.type.Item;
import mindustry.world.blocks.units.UnitCargoUnloadPoint;
import mindustry.world.meta.BlockFlag;

public class CargoAI
extends AIController {
    static Seq<Item> orderedItems = new Seq();
    static Seq<UnitCargoUnloadPoint.UnitCargoUnloadPointBuild> targets = new Seq();
    public static float emptyWaitTime = 120.0f;
    public static float dropSpacing = 90.0f;
    public static float transferRange = 20.0f;
    public static float moveRange = 6.0f;
    public static float moveSmoothing = 20.0f;
    @Nullable
    public UnitCargoUnloadPoint.UnitCargoUnloadPointBuild unloadTarget;
    @Nullable
    public Item itemTarget;
    public float noDestTimer = 0.0f;
    public int targetIndex = 0;

    @Override
    public void updateMovement() {
        BuildingTetherc tether;
        Unit unit = this.unit;
        if (!(unit instanceof BuildingTetherc) || (tether = (BuildingTetherc)((Object)unit)).building() == null) {
            return;
        }
        Building build = tether.building();
        if (build.items == null) {
            return;
        }
        if (!this.unit.hasItem()) {
            this.moveTo(build, moveRange, moveSmoothing);
            if (build.items.any() && this.unit.within(build, transferRange) && this.retarget()) {
                this.findAnyTarget(build);
                if (this.unloadTarget != null) {
                    Call.takeItems(build, this.itemTarget, Math.min(this.unit.type.itemCapacity, build.items.get(this.itemTarget)), this.unit);
                }
            }
        } else if (this.unloadTarget == null) {
            if (this.retarget()) {
                this.findDropTarget(this.unit.item(), 0, null);
                if (this.unloadTarget == null) {
                    this.unit.clearItem();
                }
            }
        } else {
            if (this.unloadTarget.item != this.itemTarget || this.unloadTarget.isPayload()) {
                this.unloadTarget = null;
                return;
            }
            this.moveTo(this.unloadTarget, moveRange, moveSmoothing);
            if (this.unit.within(this.unloadTarget, transferRange) && this.timer.get(1, dropSpacing)) {
                int max = this.unloadTarget.acceptStack(this.unit.item(), this.unit.stack.amount, this.unit);
                if (max > 0) {
                    this.noDestTimer = 0.0f;
                    Call.transferItemTo(this.unit, this.unit.item(), max, this.unit.x, this.unit.y, this.unloadTarget);
                    if (!this.unit.hasItem()) {
                        ++this.targetIndex;
                    }
                } else {
                    float f;
                    this.noDestTimer += dropSpacing;
                    if (f >= emptyWaitTime) {
                        this.targetIndex = this.findDropTarget(this.unit.item(), this.targetIndex, this.unloadTarget) + 1;
                        if (this.unloadTarget == null) {
                            this.unit.clearItem();
                        }
                    }
                }
            }
        }
    }

    public int findDropTarget(Item item, int offset, UnitCargoUnloadPoint.UnitCargoUnloadPointBuild ignore) {
        this.unloadTarget = null;
        this.itemTarget = item;
        targets.selectFrom(Vars.indexer.getFlagged(this.unit.team, BlockFlag.unitCargoUnloadPoint), u -> u.item == item);
        if (targets.isEmpty()) {
            return 0;
        }
        UnitCargoUnloadPoint.UnitCargoUnloadPointBuild lastStale = null;
        offset %= CargoAI.targets.size;
        int i = 0;
        for (UnitCargoUnloadPoint.UnitCargoUnloadPointBuild target : targets) {
            if (i >= offset && target != ignore) {
                if (target.stale) {
                    lastStale = target;
                } else {
                    this.unloadTarget = target;
                    targets.clear();
                    return i;
                }
            }
            ++i;
        }
        if (ignore != null) {
            this.unloadTarget = ignore;
        } else if (lastStale != null) {
            this.unloadTarget = lastStale;
        }
        targets.clear();
        return -1;
    }

    public void findAnyTarget(Building build) {
        this.unloadTarget = null;
        this.itemTarget = null;
        Seq<Building> baseTargets = Vars.indexer.getFlagged(this.unit.team, BlockFlag.unitCargoUnloadPoint);
        if (baseTargets.isEmpty()) {
            return;
        }
        CargoAI.orderedItems.size = 0;
        for (Item item : Vars.content.items()) {
            if (build.items.get(item) <= 0) continue;
            orderedItems.add(item);
        }
        orderedItems.sort(i -> -build.items.get((Item)i));
        UnitCargoUnloadPoint.UnitCargoUnloadPointBuild lastStale = null;
        block1: for (Item item : orderedItems) {
            targets.selectFrom(baseTargets, u -> u.item == item);
            if (CargoAI.targets.size > 0) {
                this.itemTarget = item;
            }
            for (int i2 = 0; i2 < CargoAI.targets.size; ++i2) {
                UnitCargoUnloadPoint.UnitCargoUnloadPointBuild target;
                lastStale = target = targets.get((i2 + this.targetIndex) % CargoAI.targets.size);
                if (target.stale) continue;
                this.unloadTarget = target;
                break block1;
            }
        }
        if (this.unloadTarget == null && lastStale != null) {
            this.unloadTarget = lastStale;
        }
        targets.clear();
    }

    void sortTargets(Seq<UnitCargoUnloadPoint.UnitCargoUnloadPointBuild> targets) {
        targets.sort(Structs.comps(Structs.comparingInt(b -> b.items.total()), Structs.comparingFloat(b -> b.dst2(this.unit))));
    }
}

