/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.Core;
import arc.files.Fi;
import arc.func.Cons;
import arc.math.Rand;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.OS;
import arc.util.Structs;
import arc.util.Threads;
import arc.util.serialization.Base64Coder;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import mindustry.Vars;
import mindustry.mod.Scripts;
import mindustry.net.ArcNetProvider;
import mindustry.net.Net;
import mindustry.type.Publishable;
import mindustry.ui.dialogs.FileChooser;
import rhino.Context;

public interface Platform {
    default public ClassLoader loadJar(Fi jar, final ClassLoader parent) throws Exception {
        return new URLClassLoader(new URL[]{jar.file().toURI().toURL()}, parent){

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                Class<?> loadedClass = this.findLoadedClass(name);
                if (loadedClass == null) {
                    try {
                        loadedClass = this.findClass(name);
                    }
                    catch (ClassNotFoundException e) {
                        return parent.loadClass(name);
                    }
                }
                if (resolve) {
                    this.resolveClass(loadedClass);
                }
                return loadedClass;
            }
        };
    }

    default public void updateLobby() {
    }

    default public void inviteFriends() {
    }

    default public void publish(Publishable pub) {
    }

    default public void viewListing(Publishable pub) {
    }

    default public void viewListingID(String mapid) {
    }

    default public Seq<Fi> getWorkshopContent(Class<? extends Publishable> type) {
        return new Seq<Fi>(0);
    }

    default public void openWorkshop() {
    }

    default public Net.NetProvider getNet() {
        return new ArcNetProvider();
    }

    default public Scripts createScripts() {
        return new Scripts();
    }

    default public Context getScriptContext() {
        Context context = Context.getCurrentContext();
        if (context == null) {
            context = Context.enter();
        }
        context.setOptimizationLevel(9);
        return context;
    }

    default public void updateRPC() {
    }

    default public String getUUID() {
        String uuid = Core.settings.getString("uuid", "");
        if (uuid.isEmpty()) {
            byte[] result = new byte[8];
            new Rand().nextBytes(result);
            uuid = new String(Base64Coder.encode(result));
            Core.settings.put("uuid", uuid);
            return uuid;
        }
        return uuid;
    }

    default public void shareFile(Fi file) {
    }

    default public void export(String name, String extension, FileWriter writer) {
        if (!Vars.ios) {
            Vars.platform.showFileChooser(false, extension, file -> Vars.ui.loadAnd(() -> {
                try {
                    writer.write((Fi)file);
                }
                catch (Throwable e) {
                    Vars.ui.showException(e);
                    Log.err(e);
                }
            }));
        } else {
            Vars.ui.loadAnd(() -> {
                try {
                    Fi result = Core.files.local(name + "." + extension);
                    writer.write(result);
                    Vars.platform.shareFile(result);
                }
                catch (Throwable e) {
                    Vars.ui.showException(e);
                    Log.err(e);
                }
            });
        }
    }

    default public void showFileChooser(boolean open, String title, String extension, Cons<Fi> cons) {
        if (OS.isLinux && !OS.isAndroid) {
            Platform.showZenity(open, title, new String[]{extension}, cons, () -> Platform.defaultFileDialog(open, title, extension, cons));
        } else {
            Platform.defaultFileDialog(open, title, extension, cons);
        }
    }

    public static void showZenity(boolean open, String title, String[] extensions, Cons<Fi> cons, Runnable fallback) {
        Threads.daemon(() -> {
            try {
                String result;
                String formatted = (title.startsWith("@") ? Core.bundle.get(title.substring(1)) : title).replaceAll("\"", "'");
                String last = FileChooser.getLastDirectory().absolutePath();
                if (!last.endsWith("/")) {
                    last = last + "/";
                }
                Seq<String> args = Seq.with("zenity", "--file-selection", "--title=" + formatted, "--filename=" + last, "--confirm-overwrite", "--file-filter=" + Seq.with(extensions).toString(" ", s -> "*." + s), "--file-filter=All files | *");
                if (!open) {
                    args.add("--save");
                }
                if ((result = OS.exec((String[])args.toArray(String.class))).length() > 1 && result.contains("\n")) {
                    result = result.split("\n")[0];
                }
                if (result.isEmpty() || result.equals("\n")) {
                    return;
                }
                if (result.endsWith("\n")) {
                    result = result.substring(0, result.length() - 1);
                }
                if (result.contains("\n")) {
                    throw new IOException("invalid input: \"" + result + "\"");
                }
                Fi file = Core.files.absolute(result);
                Core.app.post(() -> {
                    FileChooser.setLastDirectory(file.isDirectory() ? file : file.parent());
                    if (!open) {
                        cons.get(file.parent().child(file.nameWithoutExtension() + "." + extensions[0]));
                    } else {
                        cons.get(file);
                    }
                });
            }
            catch (Exception e) {
                Log.err(e);
                Log.warn("zenity not found, using non-native file dialog. Consider installing `zenity` for native file dialogs.", new Object[0]);
                Core.app.post(fallback);
            }
        });
    }

    public static void defaultFileDialog(boolean open, String title, String extension, Cons<Fi> cons) {
        new FileChooser(title, file -> file.extEquals(extension), open, file -> {
            if (!open) {
                cons.get(file.parent().child(file.nameWithoutExtension() + "." + extension));
            } else {
                cons.get((Fi)file);
            }
        }).show();
    }

    default public void showFileChooser(boolean open, String extension, Cons<Fi> cons) {
        this.showFileChooser(open, open ? "@open" : "@save", extension, cons);
    }

    default public void showMultiFileChooser(Cons<Fi> cons, String ... extensions) {
        if (Vars.mobile) {
            this.showFileChooser(true, extensions[0], cons);
        } else if (OS.isLinux && !OS.isAndroid) {
            Platform.showZenity(true, "@open", extensions, cons, () -> Platform.defaultMultiFileChooser(cons, extensions));
        } else {
            Platform.defaultMultiFileChooser(cons, extensions);
        }
    }

    public static void defaultMultiFileChooser(Cons<Fi> cons, String ... extensions) {
        new FileChooser("@open", file -> Structs.contains(extensions, file.extension().toLowerCase()), true, cons).show();
    }

    default public void hide() {
    }

    default public void beginForceLandscape() {
    }

    default public void endForceLandscape() {
    }

    public static interface FileWriter {
        public void write(Fi var1) throws Throwable;
    }
}

