/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.struct.LongSeq;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.gen.TileOp;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;

public class DrawOperation {
    private LongSeq array = new LongSeq();

    public boolean isEmpty() {
        return this.array.isEmpty();
    }

    public void addOperation(long op) {
        this.array.add(op);
    }

    public void undo() {
        for (int i = this.array.size - 1; i >= 0; --i) {
            this.updateTile(i);
        }
    }

    public void redo() {
        for (int i = 0; i < this.array.size; ++i) {
            this.updateTile(i);
        }
    }

    private void updateTile(int i) {
        long l = this.array.get(i);
        this.array.set(i, TileOp.get(TileOp.x(l), TileOp.y(l), TileOp.type(l), this.getTile(Vars.editor.tile(TileOp.x(l), TileOp.y(l)), TileOp.type(l))));
        this.setTile(Vars.editor.tile(TileOp.x(l), TileOp.y(l)), TileOp.type(l), TileOp.value(l));
    }

    short getTile(Tile tile, byte type) {
        if (type == OpType.floor.ordinal()) {
            return tile.floorID();
        }
        if (type == OpType.block.ordinal()) {
            return tile.blockID();
        }
        if (type == OpType.rotation.ordinal()) {
            return tile.build == null ? (short)0 : (short)((byte)tile.build.rotation);
        }
        if (type == OpType.team.ordinal()) {
            return (byte)tile.getTeamID();
        }
        if (type == OpType.overlay.ordinal()) {
            return tile.overlayID();
        }
        throw new IllegalArgumentException("Invalid type.");
    }

    void setTile(Tile tile, byte type, short to) {
        Vars.editor.load(() -> {
            if (type == OpType.floor.ordinal()) {
                Block patt1741$temp = Vars.content.block(to);
                if (patt1741$temp instanceof Floor) {
                    Floor floor = (Floor)patt1741$temp;
                    tile.setFloor(floor);
                }
            } else if (type == OpType.block.ordinal()) {
                tile.getLinkedTiles(t -> Vars.editor.renderer.updatePoint(t.x, t.y));
                Block block = Vars.content.block(to);
                tile.setBlock(block, tile.team(), tile.build == null ? 0 : tile.build.rotation);
                tile.getLinkedTiles(t -> Vars.editor.renderer.updatePoint(t.x, t.y));
            } else if (type == OpType.rotation.ordinal()) {
                if (tile.build != null) {
                    tile.build.rotation = to;
                }
            } else if (type == OpType.team.ordinal()) {
                tile.setTeam(Team.get(to));
            } else if (type == OpType.overlay.ordinal()) {
                tile.setOverlayID(to);
            }
        });
        Vars.editor.renderer.updatePoint(tile.x, tile.y);
    }

    public static enum OpType {
        floor,
        block,
        rotation,
        team,
        overlay;

    }

    class TileOpStruct {
        short x;
        short y;
        byte type;
        short value;

        TileOpStruct() {
        }
    }
}

