/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.Core;
import arc.func.Cons;
import arc.func.Prov;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.ui.Dialog;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Stack;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Scaling;
import java.util.concurrent.Future;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.gen.PackTile;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.io.JsonIO;
import mindustry.io.MapIO;
import mindustry.maps.Maps;
import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.ui.BorderImage;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Block;
import mindustry.world.CachedTile;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;

public class MapGenerateDialog
extends BaseDialog {
    final boolean applied;
    Pixmap pixmap;
    Texture texture;
    GenerateFilter.GenerateInput input = new GenerateFilter.GenerateInput();
    Seq<GenerateFilter> filters = new Seq();
    int scaling = Vars.mobile ? 3 : 1;
    Table filterTable;
    Future<?> result;
    boolean generating;
    long[] buffer1;
    long[] buffer2;
    Cons<Seq<GenerateFilter>> applier;
    CachedTile ctile = new CachedTile(){

        @Override
        protected void changeBuild(Team team, Prov<Building> entityprov, int rotation) {
        }

        @Override
        public void setBlock(Block type, Team team, int rotation, Prov<Building> entityprov) {
            this.block = type;
        }
    };

    public MapGenerateDialog(boolean applied) {
        super("@editor.generate");
        this.applied = applied;
        this.shown(this::setup);
        this.addCloseListener();
        TextButton.TextButtonStyle style = Styles.flatt;
        this.buttons.defaults().size(180.0f, 64.0f).pad(2.0f);
        this.buttons.button("@back", Icon.left, this::hide);
        if (applied) {
            this.buttons.button("@editor.apply", Icon.ok, () -> Vars.ui.loadAnd(() -> {
                this.apply();
                this.hide();
            }));
        }
        this.buttons.button("@editor.randomize", Icon.refresh, () -> {
            for (GenerateFilter filter : this.filters) {
                filter.randomize();
            }
            this.update();
        });
        this.buttons.button("@edit", Icon.edit, () -> {
            BaseDialog dialog = new BaseDialog("@editor.export");
            dialog.cont.pane((Table p) -> {
                p.margin(10.0f);
                p.table(Tex.button, in -> {
                    in.defaults().size(280.0f, 60.0f).left();
                    in.button("@waves.copy", (Drawable)Icon.copy, style, () -> {
                        dialog.hide();
                        Core.app.setClipboardText(JsonIO.write(this.filters));
                    }).marginLeft(12.0f).row();
                    in.button("@waves.load", (Drawable)Icon.download, style, () -> {
                        dialog.hide();
                        try {
                            this.filters.set(JsonIO.read(Seq.class, Core.app.getClipboardText()));
                            this.rebuildFilters();
                            this.update();
                        }
                        catch (Throwable e) {
                            Vars.ui.showException(e);
                        }
                    }).marginLeft(12.0f).disabled(b -> Core.app.getClipboardText() == null).row();
                    in.button("@clear", (Drawable)Icon.none, style, () -> {
                        dialog.hide();
                        this.filters.clear();
                        this.rebuildFilters();
                        this.update();
                    }).marginLeft(12.0f).row();
                    if (!applied) {
                        in.button("@settings.reset", (Drawable)Icon.refresh, style, () -> {
                            dialog.hide();
                            this.filters.set(Vars.maps.readFilters(""));
                            this.rebuildFilters();
                            this.update();
                        }).marginLeft(12.0f).row();
                    }
                });
            });
            dialog.addCloseButton();
            dialog.show();
        });
        this.buttons.button("@add", Icon.add, this::showAdd);
        if (!applied) {
            this.hidden(this::apply);
        }
        this.onResize(this::rebuildFilters);
    }

    public void show(Seq<GenerateFilter> filters, Cons<Seq<GenerateFilter>> applier) {
        this.filters = filters;
        this.applier = applier;
        this.show();
    }

    public void show(Cons<Seq<GenerateFilter>> applier) {
        this.show(this.filters, applier);
    }

    public void applyToEditor(Seq<GenerateFilter> filters) {
        long[] writeTiles = new long[Vars.editor.width() * Vars.editor.height()];
        for (GenerateFilter filter : filters) {
            this.input.begin(Vars.editor.width(), Vars.editor.height(), Vars.editor::tile);
            for (int x = 0; x < Vars.editor.width(); ++x) {
                for (int y = 0; y < Vars.editor.height(); ++y) {
                    Tile tile = Vars.editor.tile(x, y);
                    this.input.set(x, y, tile.block(), tile.floor(), tile.overlay());
                    filter.apply(this.input);
                    writeTiles[x + y * Vars.world.width()] = PackTile.get(this.input.block.id, this.input.floor.id, this.input.overlay.id);
                }
            }
            Vars.editor.load(() -> {
                for (int i = 0; i < Vars.editor.width() * Vars.editor.height(); ++i) {
                    Tile tile = Vars.world.tiles.geti(i);
                    long write = writeTiles[i];
                    Block block = Vars.content.block(PackTile.block(write));
                    Block floor = Vars.content.block(PackTile.floor(write));
                    Block overlay = Vars.content.block(PackTile.overlay(write));
                    if (!tile.synthetic() && !block.synthetic()) {
                        tile.setBlock(block);
                    }
                    tile.setFloor((Floor)floor);
                    tile.setOverlay(overlay);
                }
            });
        }
        Vars.editor.renderer.updateAll();
        Vars.editor.clearOp();
    }

    void setup() {
        if (this.pixmap != null) {
            this.pixmap.dispose();
            this.texture.dispose();
            this.pixmap = null;
            this.texture = null;
        }
        this.pixmap = new Pixmap(Vars.editor.width() / this.scaling, Vars.editor.height() / this.scaling);
        this.texture = new Texture(this.pixmap);
        this.cont.clear();
        this.cont.table((Table t) -> {
            t.margin(8.0f);
            t.stack(new BorderImage(this.texture){
                {
                    this.setScaling(Scaling.fit);
                }

                @Override
                public void draw() {
                    super.draw();
                    for (GenerateFilter filter : MapGenerateDialog.this.filters) {
                        filter.draw(this);
                    }
                }
            }, new Stack(){
                {
                    this.add(new Image(Styles.black8));
                    this.add(new Image((Drawable)Icon.refresh, Scaling.none));
                    this.visible(() -> MapGenerateDialog.this.generating && !Vars.updateEditorOnChange);
                }
            }).uniformX().grow().padRight(10.0f);
            t.pane((Table p) -> {
                this.filterTable = p.marginRight(6.0f);
            }).update((T pane) -> {
                if (Core.scene.getKeyboardFocus() instanceof Dialog && Core.scene.getKeyboardFocus() != this) {
                    return;
                }
                Vec2 v = pane.stageToLocalCoordinates(Core.input.mouse());
                if (v.x >= 0.0f && v.y >= 0.0f && v.x <= pane.getWidth() && v.y <= pane.getHeight()) {
                    Core.scene.setScrollFocus((Element)pane);
                } else {
                    Core.scene.setScrollFocus(null);
                }
            }).grow().uniformX().scrollX(false);
        }).grow();
        this.buffer1 = this.create();
        this.buffer2 = this.create();
        this.update();
        this.rebuildFilters();
    }

    long[] create() {
        return new long[Vars.editor.width() / this.scaling * (Vars.editor.height() / this.scaling)];
    }

    void rebuildFilters() {
        int cols = Math.max((int)((float)Core.graphics.getWidth() / 2.0f / Scl.scl(290.0f)), 1);
        this.filterTable.clearChildren();
        this.filterTable.top().left();
        int i = 0;
        for (GenerateFilter filter : this.filters) {
            this.filterTable.table(Tex.pane, c -> {
                c.margin(0.0f);
                c.table(Tex.whiteui, t -> {
                    t.setColor(Pal.gray);
                    t.top().left();
                    t.add(filter.name()).left().padLeft(6.0f).width(100.0f).wrap();
                    t.add().growX();
                    ImageButton.ImageButtonStyle style = Styles.geni;
                    t.defaults().size(42.0f).padLeft(-5.0f);
                    t.button((Drawable)Icon.refresh, style, () -> {
                        filter.randomize();
                        this.update();
                    }).padLeft(-16.0f).tooltip("@editor.randomize");
                    if (filter != this.filters.first()) {
                        t.button((Drawable)Icon.upOpen, style, () -> {
                            int idx = this.filters.indexOf(filter);
                            this.filters.swap(idx, Math.max(0, idx - 1));
                            this.rebuildFilters();
                            this.update();
                        }).tooltip("@editor.moveup");
                    }
                    if (filter != this.filters.peek()) {
                        t.button((Drawable)Icon.downOpen, style, () -> {
                            int idx = this.filters.indexOf(filter);
                            this.filters.swap(idx, Math.min(this.filters.size - 1, idx + 1));
                            this.rebuildFilters();
                            this.update();
                        }).tooltip("@editor.movedown");
                    }
                    t.button((Drawable)Icon.copy, style, () -> {
                        GenerateFilter copy = filter.copy();
                        copy.randomize();
                        this.filters.insert(this.filters.indexOf(filter) + 1, copy);
                        this.rebuildFilters();
                        this.update();
                    }).tooltip("@editor.copy");
                    t.button((Drawable)Icon.cancel, style, () -> {
                        this.filters.remove(filter);
                        this.rebuildFilters();
                        this.update();
                    }).tooltip("@waves.remove");
                }).growX();
                c.row();
                c.table((Table f) -> {
                    f.left().top();
                    for (FilterOption option : filter.options()) {
                        option.changed = this::update;
                        f.table((Table t) -> {
                            t.left();
                            option.build((Table)t);
                        }).growX().left();
                        f.row();
                    }
                }).grow().left().pad(6.0f).top();
            }).width(280.0f).pad(3.0f).top().left().fillY();
            if (++i % cols != 0) continue;
            this.filterTable.row();
        }
        if (this.filters.isEmpty()) {
            this.filterTable.add("@filters.empty").wrap().width(200.0f);
        }
    }

    void showAdd() {
        BaseDialog selection = new BaseDialog("@add");
        selection.cont.pane((Table p) -> {
            p.background(Tex.button);
            p.marginRight(14.0f);
            p.defaults().size(195.0f, 56.0f);
            int i = 0;
            for (Prov<GenerateFilter> gen : Maps.allFilterTypes) {
                GenerateFilter filter = gen.get();
                char icon = filter.icon();
                if (filter.isPost() && this.applied) continue;
                p.button((icon == '\u0000' ? "" : icon + " ") + filter.name(), Styles.flatt, () -> {
                    filter.randomize();
                    this.filters.add(filter);
                    this.rebuildFilters();
                    this.update();
                    selection.hide();
                }).with(Table::left).get().getLabelCell().growX().left().padLeft(5.0f).labelAlign(8);
                if (++i % 3 != 0) continue;
                p.row();
            }
            p.button("\ue86a " + Core.bundle.get("filter.defaultores"), Styles.flatt, () -> {
                Vars.maps.addDefaultOres(this.filters);
                this.rebuildFilters();
                this.update();
                selection.hide();
            }).with(Table::left).get().getLabelCell().growX().left().padLeft(5.0f).labelAlign(8);
        }).scrollX(false);
        selection.addCloseButton();
        selection.show();
    }

    long pack(Tile tile) {
        return PackTile.get(tile.blockID(), tile.floorID(), tile.overlayID());
    }

    Tile unpack(long tile) {
        this.ctile.setFloor((Floor)Vars.content.block(PackTile.floor(tile)));
        this.ctile.setBlock(Vars.content.block(PackTile.block(tile)));
        this.ctile.setOverlay(Vars.content.block(PackTile.overlay(tile)));
        return this.ctile;
    }

    void apply() {
        if (this.result != null) {
            try {
                this.result.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.buffer1 = null;
        this.buffer2 = null;
        this.generating = false;
        if (this.pixmap != null) {
            this.pixmap.dispose();
            this.texture.dispose();
            this.pixmap = null;
            this.texture = null;
        }
        this.applier.get(this.filters);
    }

    void update() {
        if (this.generating) {
            return;
        }
        Seq<GenerateFilter> copy = this.filters.copy();
        this.result = Vars.mainExecutor.submit(() -> {
            try {
                int w = this.pixmap.width;
                Vars.world.setGenerating(true);
                this.generating = true;
                if (!this.filters.isEmpty()) {
                    for (int px2 = 0; px2 < this.pixmap.width; ++px2) {
                        for (int py2 = 0; py2 < this.pixmap.height; ++py2) {
                            this.buffer1[px2 + py2 * w] = this.pack(Vars.editor.tile(px2 * this.scaling, py2 * this.scaling));
                        }
                    }
                }
                for (GenerateFilter filter : copy) {
                    this.input.begin(Vars.editor.width(), Vars.editor.height(), (x, y) -> this.unpack(this.buffer1[Mathf.clamp(x / this.scaling, 0, this.pixmap.width - 1) + w * Mathf.clamp(y / this.scaling, 0, this.pixmap.height - 1)]));
                    this.pixmap.each((px, py) -> {
                        int x = px * this.scaling;
                        int y = py * this.scaling;
                        long tile = this.buffer1[px + py * w];
                        this.input.set(x, y, Vars.content.block(PackTile.block(tile)), Vars.content.block(PackTile.floor(tile)), Vars.content.block(PackTile.overlay(tile)));
                        filter.apply(this.input);
                        this.buffer2[px + py * w] = PackTile.get(this.input.block.id, this.input.floor.id, this.input.overlay.id);
                    });
                    this.pixmap.each((px, py) -> {
                        this.buffer1[px + py * w] = this.buffer2[px + py * w];
                    });
                }
                for (int px3 = 0; px3 < this.pixmap.width; ++px3) {
                    for (int py3 = 0; py3 < this.pixmap.height; ++py3) {
                        int color;
                        if (this.filters.isEmpty()) {
                            Tile tile = Vars.editor.tile(px3 * this.scaling, py3 * this.scaling);
                            color = MapIO.colorFor(tile.block(), tile.floor(), tile.overlay(), Team.derelict);
                        } else {
                            long tile = this.buffer1[px3 + py3 * w];
                            color = MapIO.colorFor(Vars.content.block(PackTile.block(tile)), Vars.content.block(PackTile.floor(tile)), Vars.content.block(PackTile.overlay(tile)), Team.derelict);
                        }
                        this.pixmap.set(px3, this.pixmap.height - 1 - py3, color);
                    }
                }
                Core.app.post(() -> {
                    if (this.pixmap == null || this.texture == null) {
                        return;
                    }
                    this.texture.draw(this.pixmap);
                    this.generating = false;
                });
            }
            catch (Exception e) {
                this.generating = false;
                Log.err(e);
            }
            Vars.world.setGenerating(false);
        });
    }
}

