/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities;

import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.func.Cons;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Intersector;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.FloatSeq;
import arc.struct.IntFloatMap;
import arc.struct.IntSet;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.content.Bullets;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.entities.Effect;
import mindustry.entities.Fires;
import mindustry.entities.Lightning;
import mindustry.entities.Units;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Call;
import mindustry.gen.Healthc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.type.StatusEffect;
import mindustry.world.Tile;

public class Damage {
    private static final EventType.UnitDamageEvent bulletDamageEvent = new EventType.UnitDamageEvent();
    private static final Rect rect = new Rect();
    private static final Rect hitrect = new Rect();
    private static final Vec2 vec = new Vec2();
    private static final Vec2 seg1 = new Vec2();
    private static final Vec2 seg2 = new Vec2();
    private static final Seq<Unit> units = new Seq();
    private static final IntSet collidedBlocks = new IntSet();
    private static final IntFloatMap damages = new IntFloatMap();
    private static final Seq<Collided> collided = new Seq();
    private static final Pool<Collided> collidePool = Pools.get(Collided.class, Collided::new);
    private static final Seq<Building> builds = new Seq();
    private static final FloatSeq distances = new FloatSeq();
    private static Tile furthest;
    private static float maxDst;
    private static Building tmpBuilding;
    private static Unit tmpUnit;

    public static void applySuppression(Team team, float x, float y, float range, float reload, float maxDelay, float applyParticleChance, @Nullable Position source) {
        builds.clear();
        Vars.indexer.eachBlock(null, x, y, range, build -> build.team != team, build -> {
            float prev = build.healSuppressionTime;
            build.applyHealSuppression(reload + 1.0f);
            if ((build.wasRecentlyHealed(720.0f) || build.block.suppressable) && !Vars.headless && prev - Time.time <= reload / 2.0f) {
                builds.add((Building)build);
            }
        });
        float scaledChance = applyParticleChance / (float)Damage.builds.size;
        for (Building build2 : builds) {
            if (!Mathf.chance(scaledChance)) continue;
            Time.run(Mathf.random(maxDelay), () -> Fx.regenSuppressSeek.at(build.x + Mathf.range((float)(build.block.size * 8) / 2.0f), build.y + Mathf.range((float)(build.block.size * 8) / 2.0f), 0.0f, source));
        }
    }

    public static void dynamicExplosion(float x, float y, float flammability, float explosiveness, float power, float radius, boolean damage) {
        Damage.dynamicExplosion(x, y, flammability, explosiveness, power, radius, damage, true, null, Fx.dynamicExplosion);
    }

    public static void dynamicExplosion(float x, float y, float flammability, float explosiveness, float power, float radius, boolean damage, Effect explosionFx) {
        Damage.dynamicExplosion(x, y, flammability, explosiveness, power, radius, damage, true, null, explosionFx);
    }

    public static void dynamicExplosion(float x, float y, float flammability, float explosiveness, float power, float radius, boolean damage, boolean fire, @Nullable Team ignoreTeam) {
        Damage.dynamicExplosion(x, y, flammability, explosiveness, power, radius, damage, fire, ignoreTeam, Fx.dynamicExplosion);
    }

    public static void dynamicExplosion(float x, float y, float flammability, float explosiveness, float power, float radius, boolean damage, boolean fire, @Nullable Team ignoreTeam, Effect explosionFx) {
        if (damage) {
            int i = 0;
            while ((float)i < Mathf.clamp(power / 700.0f, 0.0f, 8.0f)) {
                int length = 5 + Mathf.clamp((int)(Mathf.pow(power, 0.98f) / 500.0f), 1, 18);
                Time.run((float)i * 0.8f + Mathf.random(4.0f), () -> Lightning.create(Team.derelict, Pal.power, 3.0f + Mathf.pow(power, 0.35f), x, y, Mathf.random(360.0f), length + Mathf.range(2)));
                ++i;
            }
            if (fire) {
                i = 0;
                while ((float)i < Mathf.clamp(flammability / 4.0f, 0.0f, 30.0f)) {
                    Time.run((float)i / 2.0f, () -> Call.createBullet(Bullets.fireball, Team.derelict, x, y, Mathf.random(360.0f), Bullets.fireball.damage, 1.0f, 1.0f));
                    ++i;
                }
            }
            int waves = explosiveness <= 2.0f ? 0 : Mathf.clamp((int)(explosiveness / 11.0f), 1, 25);
            float damagePerWave = explosiveness / 2.0f;
            for (int i2 = 0; i2 < waves; ++i2) {
                int f = i2;
                Time.run((float)i2 * 2.0f, () -> {
                    Damage.damage(ignoreTeam, x, y, Mathf.clamp(radius + explosiveness, 0.0f, 50.0f) * (((float)f + 1.0f) / (float)waves), damagePerWave, false);
                    Fx.blockExplosionSmoke.at(x + Mathf.range(radius), y + Mathf.range(radius));
                });
            }
        }
        if (explosiveness > 15.0f) {
            Fx.shockwave.at(x, y);
        }
        if (explosiveness > 30.0f) {
            Fx.bigShockwave.at(x, y);
        }
        float shake = Math.min(explosiveness / 4.0f + 3.0f, 9.0f);
        Effect.shake(shake, shake, x, y);
        explosionFx.at(x, y, radius / 8.0f);
    }

    public static void createIncend(float x, float y, float range, int amount) {
        for (int i = 0; i < amount; ++i) {
            float cy;
            float cx = x + Mathf.range(range);
            Tile tile = Vars.world.tileWorld(cx, cy = y + Mathf.range(range));
            if (tile == null) continue;
            Fires.create(tile);
        }
    }

    @Nullable
    public static Building findAbsorber(Team team, float x1, float y1, float x2, float y2) {
        tmpBuilding = null;
        boolean found = World.raycast(World.toTile(x1), World.toTile(y1), World.toTile(x2), World.toTile(y2), (x, y) -> {
            tmpBuilding = Vars.world.build(x, y);
            return tmpBuilding != null && Damage.tmpBuilding.team != team && Damage.tmpBuilding.block.absorbLasers;
        });
        return found ? tmpBuilding : null;
    }

    public static float findLength(Bullet b, float length, boolean laser, int pierceCap) {
        if (pierceCap > 0) {
            length = Damage.findPierceLength(b, pierceCap, laser, length);
        } else if (laser) {
            length = Damage.findLaserLength(b, length);
        }
        return length;
    }

    public static float findLaserLength(Bullet b, float length) {
        vec.trnsExact(b.rotation(), length);
        furthest = null;
        boolean found = World.raycast(b.tileX(), b.tileY(), World.toTile(b.x + Damage.vec.x), World.toTile(b.y + Damage.vec.y), (x, y) -> {
            furthest = Vars.world.tile(x, y);
            return furthest != null && furthest.team() != b.team && Damage.furthest.build != null && Damage.furthest.build.absorbLasers();
        });
        return found && furthest != null ? Math.max(6.0f, b.dst(furthest.worldx(), furthest.worldy())) : length;
    }

    public static float findPierceLength(Bullet b, int pierceCap, float length) {
        return Damage.findPierceLength(b, pierceCap, b.type.laserAbsorb, length);
    }

    public static float findPierceLength(Bullet b, int pierceCap, boolean laser, float length) {
        vec.trnsExact(b.rotation(), length);
        rect.setPosition(b.x, b.y).setSize(Damage.vec.x, Damage.vec.y).normalize().grow(3.0f);
        maxDst = Float.POSITIVE_INFINITY;
        distances.clear();
        World.raycast(b.tileX(), b.tileY(), World.toTile(b.x + Damage.vec.x), World.toTile(b.y + Damage.vec.y), (x, y) -> {
            Building build = Vars.world.build(x, y);
            if (build != null && build.team != b.team && build.collide(b) && b.checkUnderBuild(build, x * 8, y * 8)) {
                distances.add(b.dst(build));
                if (laser && build.absorbLasers()) {
                    maxDst = Math.min(maxDst, b.dst(build));
                    return true;
                }
            }
            return false;
        });
        Units.nearbyEnemies(b.team, rect, u -> {
            u.hitbox(hitrect);
            if (u.checkTarget(b.type.collidesAir, b.type.collidesGround) && u.hittable() && Intersector.intersectSegmentRectangle(b.x, b.y, b.x + Damage.vec.x, b.y + Damage.vec.y, hitrect)) {
                distances.add(u.dst(b));
            }
        });
        distances.sort();
        return Math.min(Damage.distances.size < pierceCap || pierceCap < 0 ? length : Math.max(6.0f, distances.get(pierceCap - 1)), maxDst);
    }

    public static float collideLaser(Bullet b, float length, boolean large, boolean laser, int pierceCap) {
        float resultLength = Damage.findPierceLength(b, pierceCap, laser, length);
        Damage.collideLine(b, b.team, b.type.hitEffect, b.x, b.y, b.rotation(), resultLength, large, laser, pierceCap);
        b.fdata = resultLength;
        return resultLength;
    }

    public static void collideLine(Bullet hitter, Team team, Effect effect, float x, float y, float angle, float length) {
        Damage.collideLine(hitter, team, effect, x, y, angle, length, false);
    }

    public static void collideLine(Bullet hitter, Team team, Effect effect, float x, float y, float angle, float length, boolean large) {
        Damage.collideLine(hitter, team, effect, x, y, angle, length, large, true);
    }

    public static void collideLine(Bullet hitter, Team team, Effect effect, float x, float y, float angle, float length, boolean large, boolean laser) {
        Damage.collideLine(hitter, team, effect, x, y, angle, length, large, laser, -1);
    }

    public static void collideLine(Bullet hitter, Team team, Effect effect, float x, float y, float angle, float length, boolean large, boolean laser, int pierceCap) {
        length = Damage.findLength(hitter, length, laser, pierceCap);
        collidedBlocks.clear();
        vec.trnsExact(angle, length);
        if (hitter.type.collidesGround) {
            seg1.set(x, y);
            seg2.set(seg1).add(vec);
            World.raycastEachWorld(x, y, Damage.seg2.x, Damage.seg2.y, (cx, cy) -> {
                boolean collide;
                Building tile = Vars.world.build(cx, cy);
                boolean bl = collide = tile != null && tile.collide(hitter) && hitter.checkUnderBuild(tile, cx * 8, cy * 8) && (tile.team != team && tile.collide(hitter) || hitter.type.testCollision(hitter, tile)) && collidedBlocks.add(tile.pos());
                if (collide) {
                    collided.add(collidePool.obtain().set(cx * 8, cy * 8, tile));
                    for (Point2 p : Geometry.d4) {
                        Building build;
                        Tile other = Vars.world.tile(p.x + cx, p.y + cy);
                        if (other == null || !large && !Intersector.intersectSegmentRectangle(seg1, seg2, other.getBounds(Tmp.r1)) || (build = other.build) == null || !hitter.checkUnderBuild(build, cx * 8, cy * 8) || !collidedBlocks.add(build.pos())) continue;
                        collided.add(collidePool.obtain().set(p.x + cx * 8, (p.y + cy) * 8, build));
                    }
                }
                return false;
            });
        }
        float expand = 3.0f;
        rect.setPosition(x, y).setSize(Damage.vec.x, Damage.vec.y).normalize().grow(expand * 2.0f);
        float x2 = Damage.vec.x + x;
        float y2 = Damage.vec.y + y;
        Units.nearbyEnemies(team, rect, u -> {
            if (u.checkTarget(hitter.type.collidesAir, hitter.type.collidesGround) && u.hittable()) {
                u.hitbox(hitrect);
                Vec2 vec = Geometry.raycastRect(x, y, x2, y2, hitrect.grow(expand * 2.0f));
                if (vec != null) {
                    collided.add(collidePool.obtain().set(vec.x, vec.y, (Teamc)u));
                }
            }
        });
        int[] collideCount = new int[]{0};
        collided.sort(c -> hitter.dst2(c.x, c.y));
        collided.each(c -> {
            if (hitter.damage > 0.0f && (pierceCap <= 0 || collideCount[0] < pierceCap)) {
                Teamc patt12870$temp = c.target;
                if (patt12870$temp instanceof Unit) {
                    Unit u = (Unit)patt12870$temp;
                    effect.at(c.x, c.y);
                    u.collision(hitter, c.x, c.y);
                    hitter.collision(u, c.x, c.y);
                    collideCount[0] = collideCount[0] + 1;
                } else {
                    Teamc patt13106$temp = c.target;
                    if (patt13106$temp instanceof Building) {
                        Building tile = (Building)patt13106$temp;
                        float health = tile.health;
                        if (tile.team != team && tile.collide(hitter)) {
                            tile.collision(hitter);
                            hitter.type.hit(hitter, c.x, c.y);
                            collideCount[0] = collideCount[0] + 1;
                        }
                        if (hitter.type.testCollision(hitter, tile)) {
                            hitter.type.hitTile(hitter, tile, c.x, c.y, health, false);
                        }
                    }
                }
            }
        });
        collidePool.freeAll(collided);
        collided.clear();
    }

    public static void collidePoint(Bullet hitter, Team team, Effect effect, float x, float y) {
        Building build;
        if (hitter.type.collidesGround && (build = Vars.world.build(World.toTile(x), World.toTile(y))) != null && hitter.damage > 0.0f) {
            float health = build.health;
            if (build.team != team && build.collide(hitter)) {
                build.collision(hitter);
                hitter.type.hit(hitter, x, y);
            }
            if (hitter.type.testCollision(hitter, build)) {
                hitter.type.hitTile(hitter, build, x, y, health, false);
            }
        }
        Units.nearbyEnemies(team, rect.setCentered(x, y, 1.0f), u -> {
            if (u.checkTarget(hitter.type.collidesAir, hitter.type.collidesGround) && u.hittable()) {
                effect.at(x, y);
                u.collision(hitter, x, y);
                hitter.collision((Hitboxc)u, x, y);
            }
        });
    }

    public static Healthc linecast(Bullet hitter, float x, float y, float angle, float length) {
        vec.trns(angle, length);
        tmpBuilding = null;
        if (hitter.type.collidesGround) {
            World.raycastEachWorld(x, y, x + Damage.vec.x, y + Damage.vec.y, (cx, cy) -> {
                Building tile = Vars.world.build(cx, cy);
                if (tile != null && tile.team != hitter.team) {
                    tmpBuilding = tile;
                    return true;
                }
                return false;
            });
        }
        rect.setPosition(x, y).setSize(Damage.vec.x, Damage.vec.y);
        float x2 = Damage.vec.x + x;
        float y2 = Damage.vec.y + y;
        if (Damage.rect.width < 0.0f) {
            Damage.rect.x += Damage.rect.width;
            Damage.rect.width *= -1.0f;
        }
        if (Damage.rect.height < 0.0f) {
            Damage.rect.y += Damage.rect.height;
            Damage.rect.height *= -1.0f;
        }
        float expand = 3.0f;
        Damage.rect.y -= expand;
        Damage.rect.x -= expand;
        Damage.rect.width += expand * 2.0f;
        Damage.rect.height += expand * 2.0f;
        tmpUnit = null;
        Units.nearbyEnemies(hitter.team, rect, e -> {
            if (tmpUnit != null && e.dst2(x, y) > tmpUnit.dst2(x, y) || !e.checkTarget(hitter.type.collidesAir, hitter.type.collidesGround) || !e.targetable(hitter.team)) {
                return;
            }
            e.hitbox(hitrect);
            Rect other = hitrect;
            other.y -= expand;
            other.x -= expand;
            other.width += expand * 2.0f;
            other.height += expand * 2.0f;
            Vec2 vec = Geometry.raycastRect(x, y, x2, y2, other);
            if (vec != null) {
                tmpUnit = e;
            }
        });
        if (tmpBuilding != null && tmpUnit != null ? Mathf.dst2(x, y, tmpBuilding.getX(), tmpBuilding.getY()) <= Mathf.dst2(x, y, tmpUnit.getX(), tmpUnit.getY()) : tmpBuilding != null) {
            return tmpBuilding;
        }
        return tmpUnit;
    }

    public static void damageUnits(Team team, float x, float y, float size, float damage, Boolf<Unit> predicate, Cons<Unit> acceptor) {
        Cons<Unit> cons = entity -> {
            if (!predicate.get((Unit)entity) || !entity.hittable()) {
                return;
            }
            entity.hitbox(hitrect);
            if (!hitrect.overlaps(rect)) {
                return;
            }
            entity.damage(damage);
            acceptor.get((Unit)entity);
        };
        rect.setSize(size * 2.0f).setCenter(x, y);
        if (team != null) {
            Units.nearbyEnemies(team, rect, cons);
        } else {
            Units.nearby(rect, cons);
        }
    }

    public static void damage(float x, float y, float radius, float damage) {
        Damage.damage(null, x, y, radius, damage, false);
    }

    public static void damage(Team team, float x, float y, float radius, float damage) {
        Damage.damage(team, x, y, radius, damage, false);
    }

    public static void damage(Team team, float x, float y, float radius, float damage, boolean air, boolean ground) {
        Damage.damage(team, x, y, radius, damage, false, air, ground);
    }

    public static void status(Team team, float x, float y, float radius, StatusEffect effect, float duration, boolean air, boolean ground) {
        Cons<Unit> cons = entity -> {
            if (!(entity.team != team && entity.checkTarget(air, ground) && entity.hittable() && entity.within(x, y, radius))) {
                return;
            }
            entity.apply(effect, duration);
        };
        rect.setSize(radius * 2.0f).setCenter(x, y);
        if (team != null) {
            Units.nearbyEnemies(team, rect, cons);
        } else {
            Units.nearby(rect, cons);
        }
    }

    public static void damage(Team team, float x, float y, float radius, float damage, boolean complete) {
        Damage.damage(team, x, y, radius, damage, complete, true, true);
    }

    public static void damage(Team team, float x, float y, float radius, float damage, boolean complete, boolean air, boolean ground) {
        Damage.damage(team, x, y, radius, damage, complete, air, ground, false, null);
    }

    public static void damage(Team team, float x, float y, float radius, float damage, boolean complete, boolean air, boolean ground, boolean scaled, @Nullable Bullet source) {
        Cons<Unit> cons = unit -> {
            if (!(unit.team != team && unit.checkTarget(air, ground) && unit.hittable() && unit.within(x, y, radius + (scaled ? unit.hitSize / 2.0f : 0.0f)))) {
                return;
            }
            boolean dead = unit.dead;
            float amount = Damage.calculateDamage(scaled ? Math.max(0.0f, unit.dst(x, y) - unit.type.hitSize / 2.0f) : unit.dst(x, y), radius, damage);
            unit.damage(amount);
            if (source != null) {
                Events.fire(bulletDamageEvent.set((Unit)unit, source));
                unit.controller().hit(source);
                if (!dead && unit.dead) {
                    Events.fire(new EventType.UnitBulletDestroyEvent((Unit)unit, source));
                }
            }
            float dst = vec.set(unit.x - x, unit.y - y).len();
            unit.vel.add(vec.setLength((1.0f - dst / radius) * 2.0f / unit.mass()));
            if (complete && damage >= 9999999.0f && unit.isPlayer()) {
                Events.fire(EventType.Trigger.exclusionDeath);
            }
        };
        rect.setSize(radius * 2.0f).setCenter(x, y);
        if (team != null) {
            Units.nearbyEnemies(team, rect, cons);
        } else {
            Units.nearby(rect, cons);
        }
        if (ground) {
            if (!complete) {
                Damage.tileDamage(team, World.toTile(x), World.toTile(y), radius / 8.0f, damage * (source == null ? 1.0f : source.type.buildingDamageMultiplier), source);
            } else {
                Damage.completeDamage(team, x, y, radius, damage);
            }
        }
    }

    public static void tileDamage(Team team, int x, int y, float baseRadius, float damage) {
        Damage.tileDamage(team, x, y, baseRadius, damage, null);
    }

    public static void tileDamage(Team team, int x, int y, float baseRadius, float damage, @Nullable Bullet source) {
        Core.app.post(() -> {
            Building in = Vars.world.build(x, y);
            if (in != null && in.team != team && in.block.size > 1 && in.health > damage) {
                in.damage(team, damage * Math.min((float)in.block.size, baseRadius * 0.4f));
                return;
            }
            float radius = Math.min(baseRadius, 100.0f);
            float rad2 = radius * radius;
            int rays = Mathf.ceil(radius * 2.0f * (float)Math.PI);
            double spacing = Math.PI * 2 / (double)rays;
            damages.clear();
            block0: for (int i = 0; i <= rays; ++i) {
                float dealt = 0.0f;
                int startX = x;
                int startY = y;
                int endX = x + (int)(Math.cos(spacing * (double)i) * (double)radius);
                int endY = y + (int)(Math.sin(spacing * (double)i) * (double)radius);
                int xDist = Math.abs(endX - startX);
                int yDist = -Math.abs(endY - startY);
                int xStep = startX < endX ? 1 : -1;
                int yStep = startY < endY ? 1 : -1;
                int error = xDist + yDist;
                while (startX != endX || startY != endY) {
                    Building build = Vars.world.build(startX, startY);
                    if (build != null && build.team != team) {
                        float edgeScale = 0.6f;
                        float mult = (1.0f - Mathf.dst2(startX, startY, x, y) / rad2 + edgeScale) / (1.0f + edgeScale);
                        float next = damage * mult - dealt;
                        int p = Point2.pack(startX, startY);
                        damages.put(p, Math.max(damages.get(p), next));
                        if (next - (dealt += build.health) <= 0.0f) continue block0;
                    }
                    if (2 * error - yDist > xDist - 2 * error) {
                        error += yDist;
                        startX += xStep;
                        continue;
                    }
                    error += xDist;
                    startY += yStep;
                }
            }
            for (IntFloatMap.Entry e : damages) {
                short cy;
                short cx = Point2.x(e.key);
                Building build = Vars.world.build(cx, cy = Point2.y(e.key));
                if (build == null) continue;
                if (source != null) {
                    build.damage(source, team, e.value);
                    continue;
                }
                build.damage(team, e.value);
            }
        });
    }

    private static void completeDamage(Team team, float x, float y, float radius, float damage) {
        int trad = (int)(radius / 8.0f);
        for (int dx = -trad; dx <= trad; ++dx) {
            for (int dy = -trad; dy <= trad; ++dy) {
                Tile tile = Vars.world.tile(Math.round(x / 8.0f) + dx, Math.round(y / 8.0f) + dy);
                if (tile == null || tile.build == null || team != null && team == tile.team() || dx * dx + dy * dy > trad * trad) continue;
                tile.build.damage(team, damage);
            }
        }
    }

    private static float calculateDamage(float dist, float radius, float damage) {
        float falloff = 0.4f;
        float scaled = Mathf.lerp(1.0f - dist / radius, 1.0f, falloff);
        return damage * scaled;
    }

    public static float applyArmor(float damage, float armor) {
        return Math.max(damage - armor, 0.1f * damage);
    }

    static {
        maxDst = 0.0f;
    }

    public static class Collided
    implements Pool.Poolable {
        public float x;
        public float y;
        public Teamc target;

        public Collided set(float x, float y, Teamc target) {
            this.x = x;
            this.y = y;
            this.target = target;
            return this;
        }

        @Override
        public void reset() {
            this.target = null;
        }
    }
}

