/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.util.Time;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Unit;
import mindustry.graphics.Shaders;
import mindustry.world.meta.Stat;

public class ArmorPlateAbility
extends Ability {
    public TextureRegion plateRegion;
    public Color color = Color.valueOf("d1efff");
    public float healthMultiplier = 0.2f;
    public float z = 110.0f;
    protected float warmup;

    @Override
    public void update(Unit unit) {
        super.update(unit);
        this.warmup = Mathf.lerpDelta(this.warmup, unit.isShooting() ? 1.0f : 0.0f, 0.1f);
        unit.healthMultiplier += this.warmup * this.healthMultiplier;
    }

    @Override
    public void addStats(Table t) {
        t.add("[lightgray]" + Stat.healthMultiplier.localized() + ": [white]" + Math.round(this.healthMultiplier * 100.0f) + 100 + "%");
    }

    @Override
    public void draw(Unit unit) {
        if (this.warmup > 0.001f) {
            if (this.plateRegion == null) {
                this.plateRegion = Core.atlas.find(unit.type.name + "-armor", unit.type.region);
            }
            Draw.draw(this.z <= 0.0f ? Draw.z() : this.z, () -> {
                Shaders.armor.region = this.plateRegion;
                Shaders.armor.progress = this.warmup;
                Shaders.armor.time = -Time.time / 20.0f;
                Draw.rect(Shaders.armor.region, unit.x, unit.y, unit.rotation - 90.0f);
                Draw.color(this.color);
                Draw.shader(Shaders.armor);
                Draw.rect(Shaders.armor.region, unit.x, unit.y, unit.rotation - 90.0f);
                Draw.shader();
                Draw.reset();
            });
        }
    }
}

