/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.geom.Intersector;
import arc.math.geom.Position;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Bullet;
import mindustry.gen.Groups;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class ForceFieldAbility
extends Ability {
    public float radius = 60.0f;
    public float regen = 0.1f;
    public float max = 200.0f;
    public float cooldown = 300.0f;
    public int sides = 6;
    public float rotation = 0.0f;
    protected float radiusScale;
    protected float alpha;
    private static float realRad;
    private static Unit paramUnit;
    private static ForceFieldAbility paramField;
    private static final Cons<Bullet> shieldConsumer;

    public ForceFieldAbility(float radius, float regen, float max, float cooldown) {
        this.radius = radius;
        this.regen = regen;
        this.max = max;
        this.cooldown = cooldown;
    }

    public ForceFieldAbility(float radius, float regen, float max, float cooldown, int sides, float rotation) {
        this.radius = radius;
        this.regen = regen;
        this.max = max;
        this.cooldown = cooldown;
        this.sides = sides;
        this.rotation = rotation;
    }

    ForceFieldAbility() {
    }

    @Override
    public void addStats(Table t) {
        t.add("[lightgray]" + Stat.health.localized() + ": [white]" + Math.round(this.max));
        t.row();
        t.add("[lightgray]" + Stat.shootRange.localized() + ": [white]" + Strings.autoFixed(this.radius / 8.0f, 2) + " " + StatUnit.blocks.localized());
        t.row();
        t.add("[lightgray]" + Stat.repairSpeed.localized() + ": [white]" + Strings.autoFixed(this.regen * 60.0f, 2) + StatUnit.perSecond.localized());
        t.row();
        t.add("[lightgray]" + Stat.cooldownTime.localized() + ": [white]" + Strings.autoFixed(this.cooldown / 60.0f, 2) + " " + StatUnit.seconds.localized());
        t.row();
    }

    @Override
    public void update(Unit unit) {
        if (unit.shield < this.max) {
            unit.shield += Time.delta * this.regen;
        }
        this.alpha = Math.max(this.alpha - Time.delta / 10.0f, 0.0f);
        if (unit.shield > 0.0f) {
            this.radiusScale = Mathf.lerpDelta(this.radiusScale, 1.0f, 0.06f);
            paramUnit = unit;
            paramField = this;
            this.checkRadius(unit);
            Groups.bullet.intersect(unit.x - realRad, unit.y - realRad, realRad * 2.0f, realRad * 2.0f, shieldConsumer);
        } else {
            this.radiusScale = 0.0f;
        }
    }

    @Override
    public void draw(Unit unit) {
        this.checkRadius(unit);
        if (unit.shield > 0.0f) {
            Draw.color(unit.team.color, Color.white, Mathf.clamp(this.alpha));
            if (Vars.renderer.animateShields) {
                Draw.z(125.0f + 0.001f * this.alpha);
                Fill.poly(unit.x, unit.y, this.sides, realRad, this.rotation);
            } else {
                Draw.z(125.0f);
                Lines.stroke(1.5f);
                Draw.alpha(0.09f);
                Fill.poly(unit.x, unit.y, this.sides, this.radius, this.rotation);
                Draw.alpha(1.0f);
                Lines.poly(unit.x, unit.y, this.sides, this.radius, this.rotation);
            }
        }
    }

    @Override
    public void displayBars(Unit unit, Table bars) {
        bars.add(new Bar("stat.shieldhealth", Pal.accent, () -> unit.shield / this.max)).row();
    }

    public void checkRadius(Unit unit) {
        realRad = this.radiusScale * this.radius;
    }

    static {
        shieldConsumer = trait -> {
            if (trait.team != ForceFieldAbility.paramUnit.team && trait.type.absorbable && Intersector.isInRegularPolygon(ForceFieldAbility.paramField.sides, ForceFieldAbility.paramUnit.x, ForceFieldAbility.paramUnit.y, realRad, ForceFieldAbility.paramField.rotation, trait.x(), trait.y()) && ForceFieldAbility.paramUnit.shield > 0.0f) {
                trait.absorb();
                Fx.absorb.at((Position)trait);
                if (ForceFieldAbility.paramUnit.shield <= trait.damage()) {
                    ForceFieldAbility.paramUnit.shield -= ForceFieldAbility.paramField.cooldown * ForceFieldAbility.paramField.regen;
                    Fx.shieldBreak.at(ForceFieldAbility.paramUnit.x, ForceFieldAbility.paramUnit.y, ForceFieldAbility.paramField.radius, ForceFieldAbility.paramUnit.team.color, paramUnit);
                }
                ForceFieldAbility.paramUnit.shield -= trait.damage();
                ForceFieldAbility.paramField.alpha = 1.0f;
            }
        };
    }
}

