/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.Core;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import arc.util.Time;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Unit;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class RegenAbility
extends Ability {
    public float percentAmount = 0.0f;
    public float amount = 0.0f;

    @Override
    public void addStats(Table t) {
        if (this.amount > 0.01f) {
            t.add("[lightgray]" + Stat.repairSpeed.localized() + ": [white]" + Strings.autoFixed(this.amount * 60.0f, 2) + StatUnit.perSecond.localized());
            t.row();
        }
        if (this.percentAmount > 0.01f) {
            t.add(Core.bundle.format("bullet.healpercent", Strings.autoFixed(this.percentAmount * 60.0f, 2)) + StatUnit.perSecond.localized());
        }
    }

    @Override
    public void update(Unit unit) {
        unit.heal((unit.maxHealth * this.percentAmount / 100.0f + this.amount) * Time.delta);
    }
}

