/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.math.geom.Position;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import arc.util.Time;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Unit;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class RepairFieldAbility
extends Ability {
    public float amount = 1.0f;
    public float reload = 100.0f;
    public float range = 60.0f;
    public Effect healEffect = Fx.heal;
    public Effect activeEffect = Fx.healWaveDynamic;
    public boolean parentizeEffects = false;
    protected float timer;
    protected boolean wasHealed = false;

    RepairFieldAbility() {
    }

    public RepairFieldAbility(float amount, float reload, float range) {
        this.amount = amount;
        this.reload = reload;
        this.range = range;
    }

    @Override
    public void addStats(Table t) {
        t.add("[lightgray]" + Stat.repairSpeed.localized() + ": [white]" + Strings.autoFixed(this.amount * 60.0f / this.reload, 2) + StatUnit.perSecond.localized());
        t.row();
        t.add("[lightgray]" + Stat.shootRange.localized() + ": [white]" + Strings.autoFixed(this.range / 8.0f, 2) + " " + StatUnit.blocks.localized());
    }

    @Override
    public void update(Unit unit) {
        this.timer += Time.delta;
        if (this.timer >= this.reload) {
            this.wasHealed = false;
            Units.nearby(unit.team, unit.x, unit.y, this.range, other -> {
                if (other.damaged()) {
                    this.healEffect.at((Position)other, this.parentizeEffects);
                    this.wasHealed = true;
                }
                other.heal(this.amount);
            });
            if (this.wasHealed) {
                this.activeEffect.at((Position)unit, this.range);
            }
            this.timer = 0.0f;
        }
    }
}

