/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;

public class ContinuousBulletType
extends BulletType {
    public float length = 220.0f;
    public float shake = 0.0f;
    public float damageInterval = 5.0f;
    public boolean largeHit = false;
    public boolean continuous = true;

    public ContinuousBulletType() {
        this.removeAfterPierce = false;
        this.pierceCap = -1;
        this.speed = 0.0f;
        this.despawnEffect = Fx.none;
        this.shootEffect = Fx.none;
        this.lifetime = 16.0f;
        this.impact = true;
        this.keepVelocity = false;
        this.collides = false;
        this.pierce = true;
        this.hittable = false;
        this.absorbable = false;
    }

    @Override
    public float continuousDamage() {
        if (!this.continuous) {
            return -1.0f;
        }
        return this.damage / this.damageInterval * 60.0f;
    }

    @Override
    public float estimateDPS() {
        if (!this.continuous) {
            return super.estimateDPS();
        }
        return this.damage * 100.0f / this.damageInterval * 3.0f;
    }

    @Override
    protected float calculateRange() {
        return Math.max(this.length, this.maxRange);
    }

    @Override
    public void init() {
        super.init();
        this.drawSize = Math.max(this.drawSize, this.length * 2.0f);
    }

    @Override
    public void init(Bullet b) {
        super.init(b);
        if (!this.continuous) {
            this.applyDamage(b);
        }
    }

    @Override
    public void update(Bullet b) {
        if (!this.continuous) {
            return;
        }
        if (b.timer(1, this.damageInterval)) {
            this.applyDamage(b);
        }
        if (this.shake > 0.0f) {
            Effect.shake(this.shake, this.shake, b);
        }
        this.updateBulletInterval(b);
    }

    public void applyDamage(Bullet b) {
        Damage.collideLine(b, b.team, this.hitEffect, b.x, b.y, b.rotation(), this.currentLength(b), this.largeHit, this.laserAbsorb, this.pierceCap);
    }

    public float currentLength(Bullet b) {
        return this.length;
    }
}

