/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.graphics.Drawf;
import mindustry.graphics.Trail;

public class PointLaserBulletType
extends BulletType {
    public String sprite = "point-laser";
    public TextureRegion laser;
    public TextureRegion laserEnd;
    public Color color = Color.white;
    public Effect beamEffect = Fx.colorTrail;
    public float beamEffectInterval = 3.0f;
    public float beamEffectSize = 3.5f;
    public float oscScl = 2.0f;
    public float oscMag = 0.3f;
    public float damageInterval = 5.0f;
    public float shake = 0.0f;

    public PointLaserBulletType() {
        this.removeAfterPierce = false;
        this.speed = 0.0f;
        this.despawnEffect = Fx.none;
        this.lifetime = 20.0f;
        this.impact = true;
        this.keepVelocity = false;
        this.collides = false;
        this.pierce = true;
        this.hittable = false;
        this.absorbable = false;
        this.optimalLifeFract = 0.5f;
        this.shootEffect = this.smokeEffect = Fx.none;
        this.drawSize = 1000.0f;
    }

    @Override
    public float continuousDamage() {
        return this.damage / this.damageInterval * 60.0f;
    }

    @Override
    public float estimateDPS() {
        return this.damage * 100.0f / this.damageInterval * 3.0f;
    }

    @Override
    public void load() {
        super.load();
        this.laser = Core.atlas.find(this.sprite);
        this.laserEnd = Core.atlas.find(this.sprite + "-end");
    }

    @Override
    public void draw(Bullet b) {
        super.draw(b);
        Draw.color(this.color);
        Drawf.laser(this.laser, this.laserEnd, b.x, b.y, b.aimX, b.aimY, b.fslope() * (1.0f - this.oscMag + Mathf.absin(Time.time, this.oscScl, this.oscMag)));
        Draw.reset();
    }

    @Override
    public void update(Bullet b) {
        this.updateTrail(b);
        this.updateTrailEffects(b);
        this.updateBulletInterval(b);
        if (b.timer.get(0, this.damageInterval)) {
            Damage.collidePoint(b, b.team, this.hitEffect, b.aimX, b.aimY);
        }
        if (b.timer.get(1, this.beamEffectInterval)) {
            this.beamEffect.at(b.aimX, b.aimY, this.beamEffectSize * b.fslope(), this.hitColor);
        }
        if (this.shake > 0.0f) {
            Effect.shake(this.shake, this.shake, b);
        }
    }

    @Override
    public void updateTrailEffects(Bullet b) {
        if (this.trailChance > 0.0f && Mathf.chanceDelta(this.trailChance)) {
            this.trailEffect.at(b.aimX, b.aimY, this.trailRotation ? b.angleTo(b.aimX, b.aimY) : this.trailParam * b.fslope(), this.trailColor);
        }
        if (this.trailInterval > 0.0f && b.timer(0, this.trailInterval)) {
            this.trailEffect.at(b.aimX, b.aimY, this.trailRotation ? b.angleTo(b.aimX, b.aimY) : this.trailParam * b.fslope(), this.trailColor);
        }
    }

    @Override
    public void updateTrail(Bullet b) {
        if (!Vars.headless && this.trailLength > 0) {
            if (b.trail == null) {
                b.trail = new Trail(this.trailLength);
            }
            b.trail.length = this.trailLength;
            b.trail.update(b.aimX, b.aimY, b.fslope() * (1.0f - (this.trailSinMag > 0.0f ? Mathf.absin(Time.time, this.trailSinScl, this.trailSinMag) : 0.0f)));
        }
    }

    @Override
    public void updateBulletInterval(Bullet b) {
        if (this.intervalBullet != null && b.time >= this.intervalDelay && b.timer.get(2, this.bulletInterval)) {
            float ang = b.rotation();
            for (int i = 0; i < this.intervalBullets; ++i) {
                this.intervalBullet.create(b, b.aimX, b.aimY, ang + Mathf.range(this.intervalRandomSpread) + this.intervalAngle + ((float)i - ((float)this.intervalBullets - 1.0f) / 2.0f) * this.intervalSpread);
            }
        }
    }
}

