/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Damage;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Healthc;
import mindustry.gen.Hitboxc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;

public class SapBulletType
extends BulletType {
    public float length = 100.0f;
    public float sapStrength = 0.5f;
    public Color color = Color.white.cpy();
    public float width = 0.4f;

    public SapBulletType() {
        this.speed = 0.0f;
        this.despawnEffect = Fx.none;
        this.pierce = true;
        this.collides = false;
        this.hitSize = 0.0f;
        this.hittable = false;
        this.hitEffect = Fx.hitLiquid;
        this.status = StatusEffects.sapped;
        this.lightColor = Pal.sap;
        this.lightOpacity = 0.6f;
        this.statusDuration = 180.0f;
        this.impact = true;
    }

    @Override
    public void draw(Bullet b) {
        Object object = b.data;
        if (object instanceof Position) {
            Position data = (Position)object;
            Tmp.v1.set(data).lerp(b, b.fin());
            Draw.color(this.color);
            Drawf.laser((TextureRegion)Core.atlas.find("laser"), (TextureRegion)Core.atlas.find("laser-end"), b.x, b.y, Tmp.v1.x, Tmp.v1.y, this.width * b.fout());
            Draw.reset();
            Drawf.light(b.x, b.y, Tmp.v1.x, Tmp.v1.y, 15.0f * b.fout(), this.lightColor, this.lightOpacity);
        }
    }

    @Override
    public void drawLight(Bullet b) {
    }

    @Override
    protected float calculateRange() {
        return Math.max(this.length, this.maxRange);
    }

    @Override
    public void init(Bullet b) {
        super.init(b);
        Healthc target = Damage.linecast(b, b.x, b.y, b.rotation(), this.length);
        b.data = target;
        if (target != null) {
            float result = Math.max(Math.min(target.health(), this.damage), 0.0f);
            Entityc entityc = b.owner;
            if (entityc instanceof Healthc) {
                Healthc h = (Healthc)entityc;
                h.heal(result * this.sapStrength);
            }
        }
        if (target instanceof Hitboxc) {
            Hitboxc hit = (Hitboxc)((Object)target);
            hit.collision(b, hit.x(), hit.y());
            b.collision(hit, hit.x(), hit.y());
        } else if (target instanceof Building) {
            Building tile = (Building)target;
            if (tile.collide(b)) {
                tile.collision(b);
                this.hit(b, tile.x, tile.y);
            }
        } else {
            b.data = new Vec2().trns(b.rotation(), this.length).add(b.x, b.y);
        }
    }
}

