/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.part;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.entities.part.DrawPart;
import mindustry.graphics.Drawf;

public class HaloPart
extends DrawPart {
    public boolean hollow = false;
    public boolean tri = false;
    public int shapes = 3;
    public int sides = 3;
    public float radius = 3.0f;
    public float radiusTo = -1.0f;
    public float stroke = 1.0f;
    public float strokeTo = -1.0f;
    public float triLength = 1.0f;
    public float triLengthTo = -1.0f;
    public float haloRadius = 10.0f;
    public float haloRadiusTo = -1.0f;
    public float x;
    public float y;
    public float shapeRotation;
    public float moveX;
    public float moveY;
    public float shapeMoveRot;
    public float haloRotateSpeed = 0.0f;
    public float haloRotation = 0.0f;
    public float rotateSpeed = 0.0f;
    public Color color = Color.white;
    @Nullable
    public Color colorTo;
    public boolean mirror = false;
    public DrawPart.PartProgress progress = DrawPart.PartProgress.warmup;
    public float layer = -1.0f;
    public float layerOffset = 0.0f;

    @Override
    public void draw(DrawPart.PartParams params) {
        float z = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z(this.layer);
        }
        if (this.under && this.turretShading) {
            Draw.z(z - 1.0E-4f);
        }
        Draw.z(Draw.z() + this.layerOffset);
        float prog = this.progress.getClamp(params);
        float baseRot = Time.time * this.rotateSpeed;
        float rad = this.radiusTo < 0.0f ? this.radius : Mathf.lerp(this.radius, this.radiusTo, prog);
        float triLen = this.triLengthTo < 0.0f ? this.triLength : Mathf.lerp(this.triLength, this.triLengthTo, prog);
        float str = this.strokeTo < 0.0f ? this.stroke : Mathf.lerp(this.stroke, this.strokeTo, prog);
        float haloRad = this.haloRadiusTo < 0.0f ? this.haloRadius : Mathf.lerp(this.haloRadius, this.haloRadiusTo, prog);
        int len = this.mirror && params.sideOverride == -1 ? 2 : 1;
        for (int s = 0; s < len; ++s) {
            int i = params.sideOverride == -1 ? s : params.sideOverride;
            float sign = (i == 0 ? 1 : -1) * params.sideMultiplier;
            Tmp.v1.set((this.x + this.moveX * prog) * sign, this.y + this.moveY * prog).rotate(params.rotation - 90.0f);
            float rx = params.x + Tmp.v1.x;
            float ry = params.y + Tmp.v1.y;
            if (this.color != null && this.colorTo != null) {
                Draw.color(this.color, this.colorTo, prog);
            } else if (this.color != null) {
                Draw.color(this.color);
            }
            float haloRot = (this.haloRotation + this.haloRotateSpeed * Time.time) * sign;
            for (int v = 0; v < this.shapes; ++v) {
                float rot = haloRot + (float)v * 360.0f / (float)this.shapes + params.rotation;
                float shapeX = Angles.trnsx(rot, haloRad) + rx;
                float shapeY = Angles.trnsy(rot, haloRad) + ry;
                float pointRot = rot + this.shapeMoveRot * prog * sign + this.shapeRotation * sign + baseRot * sign;
                if (this.tri) {
                    if (!((double)rad > 0.001) || !((double)triLen > 0.001)) continue;
                    Drawf.tri(shapeX, shapeY, rad, triLen, pointRot);
                    continue;
                }
                if (!this.hollow) {
                    if (!((double)rad > 0.001)) continue;
                    Fill.poly(shapeX, shapeY, this.sides, rad, pointRot);
                    continue;
                }
                if (!((double)str > 0.001)) continue;
                Lines.stroke(str);
                Lines.poly(shapeX, shapeY, this.sides, rad, pointRot);
                Lines.stroke(1.0f);
            }
            if (this.color == null) continue;
            Draw.color();
        }
        Draw.z(z);
    }

    @Override
    public void load(String name) {
    }
}

