/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.part;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.entities.part.DrawPart;

public class HoverPart
extends DrawPart {
    public float radius = 4.0f;
    public float x;
    public float y;
    public float rotation;
    public float phase = 50.0f;
    public float stroke = 3.0f;
    public float minStroke = 0.12f;
    public int circles = 2;
    public int sides = 4;
    public Color color = Color.white;
    public boolean mirror = false;
    public float layer = -1.0f;
    public float layerOffset = 0.0f;

    @Override
    public void draw(DrawPart.PartParams params) {
        float z = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z(this.layer);
        }
        if (this.under && this.turretShading) {
            Draw.z(z - 1.0E-4f);
        }
        Draw.z(Draw.z() + this.layerOffset);
        int len = this.mirror && params.sideOverride == -1 ? 2 : 1;
        Draw.color(this.color);
        for (int c = 0; c < this.circles; ++c) {
            float fin = (Time.time / this.phase + (float)c / (float)this.circles) % 1.0f;
            Lines.stroke((1.0f - fin) * this.stroke + this.minStroke);
            for (int s = 0; s < len; ++s) {
                int i = params.sideOverride == -1 ? s : params.sideOverride;
                float sign = (i == 0 ? 1 : -1) * params.sideMultiplier;
                Tmp.v1.set(this.x * sign, this.y).rotate(params.rotation - 90.0f);
                float rx = params.x + Tmp.v1.x;
                float ry = params.y + Tmp.v1.y;
                Lines.poly(rx, ry, this.sides, this.radius * fin, params.rotation);
            }
        }
        Draw.reset();
        Draw.z(z);
    }

    @Override
    public void load(String name) {
    }
}

