/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.part;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Tmp;
import mindustry.entities.part.DrawPart;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;

public class RegionPart
extends DrawPart {
    protected DrawPart.PartParams childParam = new DrawPart.PartParams();
    public String suffix = "";
    @Nullable
    public String name;
    public TextureRegion heat;
    public TextureRegion[] regions = new TextureRegion[0];
    public TextureRegion[] outlines = new TextureRegion[0];
    public boolean mirror = false;
    public boolean outline = true;
    public boolean drawRegion = true;
    public boolean heatLight = false;
    public DrawPart.PartProgress progress = DrawPart.PartProgress.warmup;
    public DrawPart.PartProgress growProgress = DrawPart.PartProgress.warmup;
    public DrawPart.PartProgress heatProgress = DrawPart.PartProgress.heat;
    public Blending blending = Blending.normal;
    public float layer = -1.0f;
    public float layerOffset = 0.0f;
    public float heatLayerOffset = 1.0f;
    public float turretHeatLayer = 50.1f;
    public float outlineLayerOffset = -0.001f;
    public float x;
    public float y;
    public float xScl = 1.0f;
    public float yScl = 1.0f;
    public float rotation;
    public float moveX;
    public float moveY;
    public float growX;
    public float growY;
    public float moveRot;
    public float heatLightOpacity = 0.3f;
    @Nullable
    public Color color;
    @Nullable
    public Color colorTo;
    @Nullable
    public Color mixColor;
    @Nullable
    public Color mixColorTo;
    public Color heatColor = Pal.turretHeat.cpy();
    public Seq<DrawPart> children = new Seq();
    public Seq<DrawPart.PartMove> moves = new Seq();

    public RegionPart(String region) {
        this.suffix = region;
    }

    public RegionPart(String region, Blending blending, Color color) {
        this.suffix = region;
        this.blending = blending;
        this.color = color;
        this.outline = false;
    }

    public RegionPart() {
    }

    @Override
    public void draw(DrawPart.PartParams params) {
        int i;
        int s;
        float z = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z(this.layer);
        }
        if (this.under && this.turretShading) {
            Draw.z(z - 1.0E-4f);
        }
        Draw.z(Draw.z() + this.layerOffset);
        float prevZ = Draw.z();
        float prog = this.progress.getClamp(params);
        float sclProg = this.growProgress.getClamp(params);
        float mx = this.moveX * prog;
        float my = this.moveY * prog;
        float mr = this.moveRot * prog + this.rotation;
        float gx = this.growX * sclProg;
        float gy = this.growY * sclProg;
        if (this.moves.size > 0) {
            for (int i2 = 0; i2 < this.moves.size; ++i2) {
                DrawPart.PartMove move = this.moves.get(i2);
                float p = move.progress.getClamp(params);
                mx += move.x * p;
                my += move.y * p;
                mr += move.rot * p;
                gx += move.gx * p;
                gy += move.gy * p;
            }
        }
        int len = this.mirror && params.sideOverride == -1 ? 2 : 1;
        float preXscl = Draw.xscl;
        float preYscl = Draw.yscl;
        Draw.xscl *= this.xScl + gx;
        Draw.yscl *= this.yScl + gy;
        for (s = 0; s < len; ++s) {
            i = params.sideOverride == -1 ? s : params.sideOverride;
            TextureRegion region = this.drawRegion ? this.regions[Math.min(i, this.regions.length - 1)] : null;
            float sign = (i == 0 ? 1 : -1) * params.sideMultiplier;
            Tmp.v1.set((this.x + mx) * sign, this.y + my).rotateRadExact((params.rotation - 90.0f) * ((float)Math.PI / 180));
            float rx = params.x + Tmp.v1.x;
            float ry = params.y + Tmp.v1.y;
            float rot = mr * sign + params.rotation - 90.0f;
            Draw.xscl *= sign;
            if (this.outline && this.drawRegion) {
                Draw.z(prevZ + this.outlineLayerOffset);
                Draw.rect(this.outlines[Math.min(i, this.regions.length - 1)], rx, ry, rot);
                Draw.z(prevZ);
            }
            if (this.drawRegion && region.found()) {
                if (this.color != null && this.colorTo != null) {
                    Draw.color(this.color, this.colorTo, prog);
                } else if (this.color != null) {
                    Draw.color(this.color);
                }
                if (this.mixColor != null && this.mixColorTo != null) {
                    Draw.mixcol(this.mixColor, this.mixColorTo, prog);
                } else if (this.mixColor != null) {
                    Draw.mixcol(this.mixColor, this.mixColor.a);
                }
                Draw.blend(this.blending);
                Draw.rect(region, rx, ry, rot);
                Draw.blend();
                if (this.color != null) {
                    Draw.color();
                }
            }
            if (this.heat.found()) {
                float hprog = this.heatProgress.getClamp(params);
                this.heatColor.write(Tmp.c1).a(hprog * this.heatColor.a);
                Drawf.additive(this.heat, Tmp.c1, rx, ry, rot, this.turretShading ? this.turretHeatLayer : Draw.z() + this.heatLayerOffset);
                if (this.heatLight) {
                    Drawf.light(rx, ry, this.heat, rot, Tmp.c1, this.heatLightOpacity * hprog);
                }
            }
            Draw.xscl *= sign;
        }
        Draw.color();
        Draw.mixcol();
        Draw.z(z);
        if (this.children.size > 0) {
            for (s = 0; s < len; ++s) {
                i = params.sideOverride == -1 ? s : params.sideOverride;
                float sign = (i == 1 ? -1 : 1) * params.sideMultiplier;
                Tmp.v1.set((this.x + mx) * sign, this.y + my).rotateRadExact((params.rotation - 90.0f) * ((float)Math.PI / 180));
                this.childParam.set(params.warmup, params.reload, params.smoothReload, params.heat, params.recoil, params.charge, params.x + Tmp.v1.x, params.y + Tmp.v1.y, (float)i * sign + mr * sign + params.rotation);
                this.childParam.sideMultiplier = params.sideMultiplier;
                this.childParam.life = params.life;
                this.childParam.sideOverride = i;
                for (DrawPart child : this.children) {
                    child.draw(this.childParam);
                }
            }
        }
        Draw.scl(preXscl, preYscl);
    }

    @Override
    public void load(String name) {
        String realName;
        String string = realName = this.name == null ? name + this.suffix : this.name;
        if (this.drawRegion) {
            if (this.mirror && this.turretShading) {
                this.regions = new TextureRegion[]{Core.atlas.find(realName + "-r"), Core.atlas.find(realName + "-l")};
                this.outlines = new TextureRegion[]{Core.atlas.find(realName + "-r-outline"), Core.atlas.find(realName + "-l-outline")};
            } else {
                this.regions = new TextureRegion[]{Core.atlas.find(realName)};
                this.outlines = new TextureRegion[]{Core.atlas.find(realName + "-outline")};
            }
        }
        this.heat = Core.atlas.find(realName + "-heat");
        for (DrawPart child : this.children) {
            child.turretShading = this.turretShading;
            child.load(name);
        }
    }

    @Override
    public void getOutlines(Seq<TextureRegion> out) {
        if (this.outline && this.drawRegion) {
            out.addAll((TextureRegion[])this.regions);
        }
        for (DrawPart child : this.children) {
            child.getOutlines(out);
        }
    }
}

