/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.files.Fi;
import arc.func.Boolf;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.mod.Mods;
import mindustry.type.ItemSeq;
import mindustry.type.ItemStack;
import mindustry.type.Publishable;
import mindustry.world.Block;
import mindustry.world.blocks.power.PowerGenerator;
import mindustry.world.blocks.storage.CoreBlock;

public class Schematic
implements Publishable,
Comparable<Schematic> {
    public final Seq<Stile> tiles;
    public Seq<String> labels = new Seq();
    public StringMap tags;
    public int width;
    public int height;
    @Nullable
    public Fi file;
    @Nullable
    public Mods.LoadedMod mod;

    public Schematic(Seq<Stile> tiles, StringMap tags, int width, int height) {
        this.tiles = tiles;
        this.tags = tags;
        this.width = width;
        this.height = height;
    }

    public float powerProduction() {
        return this.tiles.sumf(s -> {
            float f;
            Block patt1015$temp = s.block;
            if (patt1015$temp instanceof PowerGenerator) {
                PowerGenerator p = (PowerGenerator)patt1015$temp;
                f = p.powerProduction;
            } else {
                f = 0.0f;
            }
            return f;
        });
    }

    public float powerConsumption() {
        return this.tiles.sumf(s -> s.block.consPower != null ? s.block.consPower.usage : 0.0f);
    }

    public ItemSeq requirements() {
        ItemSeq requirements = new ItemSeq();
        this.tiles.each(t -> {
            for (ItemStack stack : t.block.requirements) {
                requirements.add(stack.item, stack.amount);
            }
        });
        return requirements;
    }

    public boolean hasCore() {
        return this.tiles.contains((Stile)((Object)((Boolf<Stile>)s -> s.block instanceof CoreBlock)));
    }

    public CoreBlock findCore() {
        Stile tile = this.tiles.find(s -> s.block instanceof CoreBlock);
        if (tile == null) {
            throw new IllegalArgumentException("Schematic is missing a core!");
        }
        return (CoreBlock)tile.block;
    }

    public String name() {
        return this.tags.get("name", "unknown");
    }

    public String description() {
        return this.tags.get("description", "");
    }

    public void save() {
        Vars.schematics.saveChanges(this);
    }

    @Override
    public String getSteamID() {
        return (String)this.tags.get("steamid");
    }

    @Override
    public void addSteamID(String id) {
        this.tags.put("steamid", id);
        this.save();
    }

    @Override
    public void removeSteamID() {
        this.tags.remove("steamid");
        this.save();
    }

    @Override
    public String steamTitle() {
        return this.name();
    }

    @Override
    public String steamDescription() {
        return this.description();
    }

    @Override
    public String steamTag() {
        return "schematic";
    }

    @Override
    public Fi createSteamFolder(String id) {
        Fi directory = Vars.tmpDirectory.child("schematic_" + id).child("schematic.msch");
        this.file.copyTo(directory);
        return directory;
    }

    @Override
    public Fi createSteamPreview(String id) {
        Fi preview = Vars.tmpDirectory.child("schematic_preview_" + id + ".png");
        Vars.schematics.savePreview(this, preview);
        return preview;
    }

    @Override
    public int compareTo(Schematic schematic) {
        return this.name().compareTo(schematic.name());
    }

    public static class Stile {
        public Block block;
        public short x;
        public short y;
        public Object config;
        public byte rotation;

        public Stile(Block block, int x, int y, Object config, byte rotation) {
            this.block = block;
            this.x = (short)x;
            this.y = (short)y;
            this.config = config;
            this.rotation = rotation;
        }

        public Stile() {
            this.block = Blocks.air;
        }

        public Stile set(Stile other) {
            this.block = other.block;
            this.x = other.x;
            this.y = other.y;
            this.config = other.config;
            this.rotation = other.rotation;
            return this;
        }

        public Stile copy() {
            return new Stile(this.block, this.x, this.y, this.config, this.rotation);
        }
    }
}

