/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.graphics.Color;
import arc.math.Angles;
import arc.math.geom.Position;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.core.World;
import mindustry.entities.Effect;
import mindustry.entities.EntityGroup;
import mindustry.gen.Building;
import mindustry.gen.Childc;
import mindustry.gen.Drawc;
import mindustry.gen.EffectStatec;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.IndexableEntity__all;
import mindustry.gen.IndexableEntity__draw;
import mindustry.gen.Posc;
import mindustry.gen.Rotc;
import mindustry.gen.Timedc;
import mindustry.gen.Unitc;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;

public class EffectState
implements Pool.Poolable,
Childc,
Drawc,
EffectStatec,
Entityc,
IndexableEntity__all,
IndexableEntity__draw,
Posc,
Rotc,
Timedc {
    protected transient boolean added;
    public Color color = new Color(Color.white);
    public Object data;
    public Effect effect;
    public transient int id = EntityGroup.nextId();
    protected transient int index__all = -1;
    protected transient int index__draw = -1;
    public float lifetime;
    public float offsetPos;
    public float offsetRot;
    public float offsetX;
    public float offsetY;
    @Nullable
    public Posc parent;
    public boolean rotWithParent;
    public float rotation;
    public float time;
    public float x;
    public float y;

    protected EffectState() {
    }

    @Override
    public Color color() {
        return this.color;
    }

    @Override
    public boolean rotWithParent() {
        return this.rotWithParent;
    }

    @Override
    public float lifetime() {
        return this.lifetime;
    }

    @Override
    public float offsetPos() {
        return this.offsetPos;
    }

    @Override
    public float offsetRot() {
        return this.offsetRot;
    }

    @Override
    public float offsetX() {
        return this.offsetX;
    }

    @Override
    public float offsetY() {
        return this.offsetY;
    }

    @Override
    public float rotation() {
        return this.rotation;
    }

    @Override
    public float time() {
        return this.time;
    }

    @Override
    public float x() {
        return this.x;
    }

    @Override
    public float y() {
        return this.y;
    }

    @Override
    public int classId() {
        return 9;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public Object data() {
        return this.data;
    }

    public String toString() {
        return "EffectState#" + this.id;
    }

    @Override
    public Effect effect() {
        return this.effect;
    }

    @Override
    public Posc parent() {
        return this.parent;
    }

    @Override
    public void color(Color color) {
        this.color = color;
    }

    @Override
    public void data(Object data) {
        this.data = data;
    }

    @Override
    public void effect(Effect effect) {
        this.effect = effect;
    }

    @Override
    public void id(int id) {
        this.id = id;
    }

    @Override
    public void lifetime(float lifetime) {
        this.lifetime = lifetime;
    }

    @Override
    public void offsetPos(float offsetPos) {
        this.offsetPos = offsetPos;
    }

    @Override
    public void offsetRot(float offsetRot) {
        this.offsetRot = offsetRot;
    }

    @Override
    public void offsetX(float offsetX) {
        this.offsetX = offsetX;
    }

    @Override
    public void offsetY(float offsetY) {
        this.offsetY = offsetY;
    }

    @Override
    public void parent(Posc parent) {
        this.parent = parent;
    }

    @Override
    public void rotWithParent(boolean rotWithParent) {
        this.rotWithParent = rotWithParent;
    }

    @Override
    public void rotation(float rotation) {
        this.rotation = rotation;
    }

    @Override
    public void setIndex__all(int index) {
        this.index__all = index;
    }

    @Override
    public void setIndex__draw(int index) {
        this.index__draw = index;
    }

    @Override
    public void time(float time) {
        this.time = time;
    }

    @Override
    public void x(float x) {
        this.x = x;
    }

    @Override
    public void y(float y) {
        this.y = y;
    }

    @Override
    public <T extends Entityc> T self() {
        return (T)this;
    }

    @Override
    public <T> T as() {
        return (T)this;
    }

    @Override
    public Building buildOn() {
        return Vars.world.buildWorld(this.x, this.y);
    }

    @Override
    public boolean isAdded() {
        return this.added;
    }

    @Override
    public boolean isLocal() {
        Unitc u;
        EffectState effectState;
        return this == Vars.player || (effectState = this) instanceof Unitc && (u = (Unitc)((Object)effectState)).controller() == Vars.player;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isRemote() {
        Unitc u;
        EffectState effectState = this;
        return effectState instanceof Unitc && (u = (Unitc)((Object)effectState)).isPlayer() && !this.isLocal();
    }

    @Override
    public boolean onSolid() {
        Tile tile = this.tileOn();
        return tile == null || tile.solid();
    }

    @Override
    public boolean serialize() {
        return false;
    }

    @Override
    public float clipSize() {
        return this.effect.clip;
    }

    @Override
    public float fin() {
        return this.time / this.lifetime;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public int tileX() {
        return World.toTile(this.x);
    }

    @Override
    public int tileY() {
        return World.toTile(this.y);
    }

    @Override
    public Block blockOn() {
        Tile tile = this.tileOn();
        return tile == null ? Blocks.air : tile.block();
    }

    @Override
    public Tile tileOn() {
        return Vars.world.tileWorld(this.x, this.y);
    }

    @Override
    public Floor floorOn() {
        Tile tile = this.tileOn();
        return tile == null || tile.block() != Blocks.air ? (Floor)Blocks.air : tile.floor();
    }

    public static EffectState create() {
        return Pools.obtain(EffectState.class, EffectState::new);
    }

    @Override
    public void add() {
        if (this.added) {
            return;
        }
        this.index__all = Groups.all.addIndex(this);
        this.index__draw = Groups.draw.addIndex(this);
        if (this.parent != null) {
            Posc posc;
            this.offsetX = this.x - this.parent.getX();
            this.offsetY = this.y - this.parent.getY();
            if (this.rotWithParent && (posc = this.parent) instanceof Rotc) {
                Rotc r = (Rotc)((Object)posc);
                this.offsetPos = -r.rotation();
                this.offsetRot = this.rotation - r.rotation();
            }
        }
        this.added = true;
    }

    @Override
    public void afterRead() {
    }

    @Override
    public void draw() {
        this.lifetime = this.effect.render(this.id, this.color, this.time, this.lifetime, this.rotation, this.x, this.y, this.data);
    }

    @Override
    public void read(Reads read) {
        this.afterRead();
    }

    @Override
    public void remove() {
        if (!this.added) {
            return;
        }
        Groups.all.removeIndex(this, this.index__all);
        this.index__all = -1;
        Groups.draw.removeIndex(this, this.index__draw);
        this.index__draw = -1;
        this.added = false;
        Groups.queueFree(this);
    }

    @Override
    public void reset() {
        this.added = false;
        this.data = null;
        this.effect = null;
        this.id = EntityGroup.nextId();
        this.lifetime = 0.0f;
        this.offsetPos = 0.0f;
        this.offsetRot = 0.0f;
        this.offsetX = 0.0f;
        this.offsetY = 0.0f;
        this.parent = null;
        this.rotWithParent = false;
        this.rotation = 0.0f;
        this.time = 0.0f;
        this.x = 0.0f;
        this.y = 0.0f;
    }

    @Override
    public void set(Position pos) {
        this.set(pos.getX(), pos.getY());
    }

    @Override
    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void trns(Position pos) {
        this.trns(pos.getX(), pos.getY());
    }

    @Override
    public void trns(float x, float y) {
        this.set(this.x + x, this.y + y);
    }

    @Override
    public void update() {
        if (this.parent != null) {
            Posc posc;
            if (this.rotWithParent && (posc = this.parent) instanceof Rotc) {
                Rotc r = (Rotc)((Object)posc);
                this.x = this.parent.getX() + Angles.trnsx(r.rotation() + this.offsetPos, this.offsetX, this.offsetY);
                this.y = this.parent.getY() + Angles.trnsy(r.rotation() + this.offsetPos, this.offsetX, this.offsetY);
                this.rotation = r.rotation() + this.offsetRot;
            } else {
                this.x = this.parent.getX() + this.offsetX;
                this.y = this.parent.getY() + this.offsetY;
            }
        }
        this.time = Math.min(this.time + Time.delta, this.lifetime);
        if (this.time >= this.lifetime) {
            this.remove();
        }
    }

    @Override
    public void write(Writes write) {
    }
}

