/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.FloatSeq;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.graphics.Shaders;
import mindustry.world.Block;
import mindustry.world.Tile;

public class Drawf {
    private static final Vec2[] vecs = new Vec2[]{new Vec2(), new Vec2(), new Vec2(), new Vec2()};
    private static final FloatSeq points = new FloatSeq();

    public static void checkBleed(Pixmap pixmap) {
        if (Core.settings.getBool("linear", true)) {
            Pixmaps.bleed(pixmap);
        }
    }

    public static void flame(float x, float y, int divisions, float rotation, float length, float width, float pan) {
        float rot;
        int i;
        float len1 = length * pan;
        float len2 = length * (1.0f - pan);
        points.clear();
        for (i = 0; i < divisions; ++i) {
            rot = 90.0f + 180.0f * (float)i / (float)divisions;
            Tmp.v1.trnsExact(rot, width);
            Drawf.point((Tmp.v1.x + width) / width * len1, Tmp.v1.y, x, y, rotation);
        }
        for (i = 0; i < divisions; ++i) {
            rot = -90.0f + 180.0f * (float)i / (float)divisions;
            Tmp.v1.trnsExact(rot, width);
            Drawf.point(len1 + Tmp.v1.x / width * len2, Tmp.v1.y, x, y, rotation);
        }
        Fill.poly(points);
    }

    public static void flameFront(float x, float y, int divisions, float rotation, float length, float width) {
        divisions = Mathf.round(divisions, 2) + 1;
        points.clear();
        for (int i = 0; i <= divisions; ++i) {
            float rot = -90.0f + 180.0f * (float)i / (float)divisions;
            Tmp.v1.trnsExact(rot, width);
            Drawf.point(Tmp.v1.x / width * length, Tmp.v1.y, x, y, rotation);
        }
        Fill.poly(points);
    }

    private static void point(float x, float y, float baseX, float baseY, float rotation) {
        Tmp.v1.set(x, y).rotateRadExact(rotation * ((float)Math.PI / 180));
        points.add(Tmp.v1.x + baseX, Tmp.v1.y + baseY);
    }

    public static void buildBeam(float x, float y, float tx, float ty, float radius) {
        float ang = Angles.angle(x, y, tx, ty);
        vecs[0].set(tx - radius, ty - radius);
        vecs[1].set(tx + radius, ty - radius);
        vecs[2].set(tx - radius, ty + radius);
        vecs[3].set(tx + radius, ty + radius);
        Arrays.sort(vecs, Structs.comparingFloat(vec -> -Angles.angleDist(Angles.angle(x, y, vec.x, vec.y), ang)));
        Vec2 close = (Vec2)Geometry.findClosest((float)x, (float)y, (Position[])vecs);
        float x1 = Drawf.vecs[0].x;
        float y1 = Drawf.vecs[0].y;
        float x2 = close.x;
        float y2 = close.y;
        float x3 = Drawf.vecs[1].x;
        float y3 = Drawf.vecs[1].y;
        if (Vars.renderer.animateShields) {
            if (close != vecs[0] && close != vecs[1]) {
                Fill.tri(x, y, x1, y1, x2, y2);
                Fill.tri(x, y, x3, y3, x2, y2);
            } else {
                Fill.tri(x, y, x1, y1, x3, y3);
            }
        } else {
            Lines.line(x, y, x1, y1);
            Lines.line(x, y, x3, y3);
        }
    }

    public static void additive(TextureRegion region, Color color, float x, float y) {
        Drawf.additive(region, color, x, y, 0.0f, 31.0f);
    }

    public static void additive(TextureRegion region, Color color, float x, float y, float rotation) {
        Drawf.additive(region, color, x, y, rotation, 31.0f);
    }

    public static void additive(TextureRegion region, Color color, float x, float y, float rotation, float layer) {
        Drawf.additive(region, color, 1.0f, x, y, rotation, layer);
    }

    public static void additive(TextureRegion region, Color color, float alpha, float x, float y, float rotation, float layer) {
        float pz = Draw.z();
        Draw.z(layer);
        Draw.color(color, alpha * color.a);
        Draw.blend(Blending.additive);
        Draw.rect(region, x, y, rotation);
        Draw.blend();
        Draw.color();
        Draw.z(pz);
    }

    public static void limitLine(Position start, Position dest, float len1, float len2) {
        Tmp.v1.set(dest).sub(start).setLength(len1);
        Tmp.v2.set(Tmp.v1).scl(-1.0f).setLength(len2);
        Drawf.line(Pal.accent, start.getX() + Tmp.v1.x, start.getY() + Tmp.v1.y, dest.getX() + Tmp.v2.x, dest.getY() + Tmp.v2.y);
    }

    public static void dashLineDst(Color color, float x, float y, float x2, float y2) {
        Drawf.dashLine(color, x, y, x2, y2, (int)(Mathf.dst(x, y, x2, y2) / 8.0f * 1.6f));
    }

    public static void dashLine(Color color, float x, float y, float x2, float y2) {
        Drawf.dashLine(color, x, y, x2, y2, (int)(Math.max(Math.abs(x - x2), Math.abs(y - y2)) / 8.0f * 2.0f));
    }

    public static void dashLine(Color color, float x, float y, float x2, float y2, int segments) {
        Lines.stroke(3.0f);
        Draw.color(Pal.gray, color.a);
        Lines.dashLine(x, y, x2, y2, segments);
        Lines.stroke(1.0f, color);
        Lines.dashLine(x, y, x2, y2, segments);
        Draw.reset();
    }

    public static void line(Color color, float x, float y, float x2, float y2) {
        Lines.stroke(3.0f);
        Draw.color(Pal.gray, color.a);
        Lines.line(x, y, x2, y2);
        Lines.stroke(1.0f, color);
        Lines.line(x, y, x2, y2);
        Draw.reset();
    }

    public static void dashLineBasic(float x, float y, float x2, float y2) {
        Lines.dashLine(x, y, x2, y2, (int)(Math.max(Math.abs(x - x2), Math.abs(y - y2)) / 8.0f * 2.0f));
    }

    public static void dashSquare(Color color, float x, float y, float size) {
        Drawf.dashRect(color, x - size / 2.0f, y - size / 2.0f, size, size);
    }

    public static void dashRect(Color color, Rect rect) {
        Drawf.dashRect(color, rect.x, rect.y, rect.width, rect.height);
    }

    public static void dashRect(Color color, float x, float y, float width, float height) {
        Drawf.dashLine(color, x, y, x + width, y);
        Drawf.dashLine(color, x + width, y, x + width, y + height);
        Drawf.dashLine(color, x + width, y + height, x, y + height);
        Drawf.dashLine(color, x, y + height, x, y);
    }

    public static void dashSquareBasic(float x, float y, float size) {
        Drawf.dashRectBasic(x - size / 2.0f, y - size / 2.0f, size, size);
    }

    public static void dashRectBasic(float x, float y, float width, float height) {
        Drawf.dashLineBasic(x, y, x + width, y);
        Drawf.dashLineBasic(x + width, y, x + width, y + height);
        Drawf.dashLineBasic(x + width, y + height, x, y + height);
        Drawf.dashLineBasic(x, y + height, x, y);
    }

    public static void target(float x, float y, float rad, Color color) {
        Drawf.target(x, y, rad, 1.0f, color);
    }

    public static void target(float x, float y, float rad, float alpha, Color color) {
        Lines.stroke(3.0f);
        Draw.color(Pal.gray, alpha);
        Lines.poly(x, y, 4, rad, Time.time * 1.5f);
        Lines.spikes(x, y, 0.42857143f * rad, 0.85714287f * rad, 4, Time.time * 1.5f);
        Lines.stroke(1.0f);
        Draw.color(color, alpha);
        Lines.poly(x, y, 4, rad, Time.time * 1.5f);
        Lines.spikes(x, y, 0.42857143f * rad, 0.85714287f * rad, 4, Time.time * 1.5f);
        Draw.reset();
    }

    public static float text() {
        float z = Draw.z();
        if (Vars.renderer.pixelator.enabled()) {
            Draw.z(210.0f);
        }
        return z;
    }

    public static void light(float x, float y, float radius, Color color, float opacity) {
        if (Vars.renderer == null) {
            return;
        }
        Vars.renderer.lights.add(x, y, radius, color, opacity);
    }

    public static void light(Position pos, float radius, Color color, float opacity) {
        if (Vars.renderer == null) {
            return;
        }
        Drawf.light(pos.getX(), pos.getY(), radius, color, opacity);
    }

    public static void light(float x, float y, TextureRegion region, Color color, float opacity) {
        Drawf.light(x, y, region, 0.0f, color, opacity);
    }

    public static void light(float x, float y, TextureRegion region, float rotation, Color color, float opacity) {
        if (Vars.renderer == null) {
            return;
        }
        Vars.renderer.lights.add(x, y, region, rotation, color, opacity);
    }

    public static void light(float x, float y, float x2, float y2) {
        if (Vars.renderer == null) {
            return;
        }
        Vars.renderer.lights.line(x, y, x2, y2, 30.0f, Color.orange, 0.3f);
    }

    public static void light(float x, float y, float x2, float y2, float stroke, Color tint, float alpha) {
        if (Vars.renderer == null) {
            return;
        }
        Vars.renderer.lights.line(x, y, x2, y2, stroke, tint, alpha);
    }

    public static void selected(Building tile, Color color) {
        Drawf.selected(tile.tile(), color);
    }

    public static void selected(Tile tile, Color color) {
        Drawf.selected(tile.x, tile.y, tile.block(), color);
    }

    public static void selected(int x, int y, Block block, Color color) {
        Draw.color(color);
        for (int i = 0; i < 4; ++i) {
            Point2 p = Geometry.d8edge[i];
            float offset = (float)(-Math.max(block.size - 1, 0)) / 2.0f * 8.0f;
            Draw.rect("block-select", (float)(x * 8) + block.offset + offset * (float)p.x, (float)(y * 8) + block.offset + offset * (float)p.y, (float)(i * 90));
        }
        Draw.reset();
    }

    public static void shadow(float x, float y, float rad) {
        Drawf.shadow(x, y, rad, 1.0f);
    }

    public static void squareShadow(float x, float y, float rad, float alpha) {
        Draw.color(0.0f, 0.0f, 0.0f, 0.4f * alpha);
        Draw.rect("square-shadow", x, y, rad * Draw.xscl, rad * Draw.yscl);
        Draw.color();
    }

    public static void shadow(float x, float y, float rad, float alpha) {
        Draw.color(0.0f, 0.0f, 0.0f, 0.4f * alpha);
        Draw.rect("circle-shadow", x, y, rad * Draw.xscl, rad * Draw.yscl);
        Draw.color();
    }

    public static void shadow(TextureRegion region, float x, float y, float rotation) {
        Draw.color(Pal.shadow);
        Draw.rect(region, x, y, rotation);
        Draw.color();
    }

    public static void shadow(TextureRegion region, float x, float y) {
        Draw.color(Pal.shadow);
        Draw.rect(region, x, y);
        Draw.color();
    }

    public static void shadow(TextureRegion region, float x, float y, float width, float height, float rotation) {
        Draw.color(Pal.shadow);
        Draw.rect(region, x, y, width, height, rotation);
        Draw.color();
    }

    public static void liquid(TextureRegion region, float x, float y, float alpha, Color color, float rotation) {
        Draw.color(color, alpha * color.a);
        Draw.rect(region, x, y, rotation);
        Draw.color();
    }

    public static void liquid(TextureRegion region, float x, float y, float alpha, Color color) {
        Draw.color(color, alpha * color.a);
        Draw.rect(region, x, y);
        Draw.color();
    }

    public static void dashCircle(float x, float y, float rad, Color color) {
        Lines.stroke(3.0f, Pal.gray);
        Lines.dashCircle(x, y, rad);
        Lines.stroke(1.0f, color);
        Lines.dashCircle(x, y, rad);
        Draw.reset();
    }

    public static void circles(float x, float y, float rad) {
        Drawf.circles(x, y, rad, Pal.accent);
    }

    public static void circles(float x, float y, float rad, Color color) {
        Lines.stroke(3.0f, Pal.gray);
        Lines.circle(x, y, rad);
        Lines.stroke(1.0f, color);
        Lines.circle(x, y, rad);
        Draw.reset();
    }

    public static void select(float x, float y, float radius, Color color) {
        Lines.stroke(3.0f, Pal.gray);
        Lines.square(x, y, radius + 1.0f);
        Lines.stroke(1.0f, color);
        Lines.square(x, y, radius);
        Draw.reset();
    }

    public static void square(float x, float y, float radius, float rotation, Color color) {
        Lines.stroke(3.0f, Pal.gray);
        Lines.square(x, y, radius + 1.0f, rotation);
        Lines.stroke(1.0f, color);
        Lines.square(x, y, radius + 1.0f, rotation);
        Draw.reset();
    }

    public static void square(float x, float y, float radius, float rotation) {
        Drawf.square(x, y, radius, rotation, Pal.accent);
    }

    public static void square(float x, float y, float radius, Color color) {
        Drawf.square(x, y, radius, 45.0f, color);
    }

    public static void square(float x, float y, float radius) {
        Drawf.square(x, y, radius, 45.0f);
    }

    public static void arrow(float x, float y, float x2, float y2, float length, float radius) {
        Drawf.arrow(x, y, x2, y2, length, radius, Pal.accent);
    }

    public static void arrow(float x, float y, float x2, float y2, float length, float radius, Color color) {
        float angle = Angles.angle(x, y, x2, y2);
        float space = 2.0f;
        Tmp.v1.set(x2, y2).sub(x, y).limit(length);
        float vx = Tmp.v1.x + x;
        float vy = Tmp.v1.y + y;
        Draw.color(Pal.gray);
        Fill.poly(vx, vy, 3, radius + space, angle);
        Draw.color(color);
        Fill.poly(vx, vy, 3, radius, angle);
        Draw.color();
    }

    public static void laser(TextureRegion line, TextureRegion edge, float x, float y, float x2, float y2) {
        Drawf.laser(line, edge, edge, x, y, x2, y2, 1.0f);
    }

    public static void laser(TextureRegion line, TextureRegion start, TextureRegion end, float x, float y, float x2, float y2) {
        Drawf.laser(line, start, end, x, y, x2, y2, 1.0f);
    }

    public static void laser(TextureRegion line, TextureRegion edge, float x, float y, float x2, float y2, float scale) {
        Drawf.laser(line, edge, edge, x, y, x2, y2, scale);
    }

    public static void laser(TextureRegion line, TextureRegion start, TextureRegion end, float x, float y, float x2, float y2, float scale) {
        float scl = 8.0f * scale * Draw.scl;
        float rot = Mathf.angle(x2 - x, y2 - y);
        float vx = Mathf.cosDeg(rot) * scl;
        float vy = Mathf.sinDeg(rot) * scl;
        Draw.rect(start, x, y, (float)start.width * scale * start.scl(), (float)start.height * scale * start.scl(), rot + 180.0f);
        Draw.rect(end, x2, y2, (float)end.width * scale * end.scl(), (float)end.height * scale * end.scl(), rot);
        Lines.stroke(12.0f * scale);
        Lines.line(line, x + vx, y + vy, x2 - vx, y2 - vy, false);
        Lines.stroke(1.0f);
        Drawf.light(x, y, x2, y2);
    }

    public static void tri(float x, float y, float width, float length, float rotation) {
        float fx = Angles.trnsx(rotation, length);
        float fy = Angles.trnsy(rotation, length);
        float rx = Angles.trnsx(rotation - 90.0f, width / 2.0f);
        float ry = Angles.trnsy(rotation - 90.0f, width / 2.0f);
        Fill.tri(x + rx, y + ry, x + fx, y + fy, x - rx, y - ry);
    }

    public static void construct(Building t, UnlockableContent content, float rotation, float progress, float alpha, float time) {
        Drawf.construct(t, content.fullIcon, rotation, progress, alpha, time);
    }

    public static void construct(float x, float y, TextureRegion region, float rotation, float progress, float alpha, float time) {
        Drawf.construct(x, y, region, Pal.accent, rotation, progress, alpha, time);
    }

    public static void construct(float x, float y, TextureRegion region, Color color, float rotation, float progress, float alpha, float time) {
        Shaders.build.region = region;
        Shaders.build.progress = progress;
        Shaders.build.color.set(color);
        Shaders.build.color.a = alpha;
        Shaders.build.time = -time / 20.0f;
        Draw.shader(Shaders.build);
        Draw.rect(region, x, y, rotation);
        Draw.shader();
        Draw.reset();
    }

    public static void construct(Building t, TextureRegion region, float rotation, float progress, float alpha, float time) {
        Drawf.construct(t, region, Pal.accent, rotation, progress, alpha, time);
    }

    public static void construct(Building t, TextureRegion region, Color color, float rotation, float progress, float alpha, float time) {
        Drawf.construct(t, region, color, rotation, progress, alpha, time, (float)(t.block.size * 8) - 4.0f);
    }

    public static void construct(Building t, TextureRegion region, Color color, float rotation, float progress, float alpha, float time, float size) {
        Shaders.build.region = region;
        Shaders.build.progress = progress;
        Shaders.build.color.set(color);
        Shaders.build.color.a = alpha;
        Shaders.build.time = -time / 20.0f;
        Draw.shader(Shaders.build);
        Draw.rect(region, t.x, t.y, rotation);
        Draw.shader();
        Draw.color(Pal.accent);
        Draw.alpha(alpha);
        Lines.lineAngleCenter(t.x + Mathf.sin(time, 20.0f, size / 2.0f), t.y, 90.0f, size);
        Draw.reset();
    }

    public static void spinSprite(TextureRegion region, float x, float y, float r) {
        float a = Draw.getColor().a;
        r = Mathf.mod(r, 90.0f);
        Draw.rect(region, x, y, r);
        Draw.alpha(r / 90.0f * a);
        Draw.rect(region, x, y, r - 90.0f);
        Draw.alpha(a);
    }
}

