/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.Events;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import java.lang.invoke.LambdaMetafactory;
import mindustry.Vars;
import mindustry.ai.types.LogicAI;
import mindustry.entities.Sized;
import mindustry.game.EventType;
import mindustry.game.MapObjectives;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Player;
import mindustry.gen.Unit;
import mindustry.gen.Unitc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.graphics.Voronoi;
import mindustry.input.Binding;
import mindustry.input.InputHandler;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;

public class OverlayRenderer {
    private static final float indicatorLength = 14.0f;
    private static final float spawnerMargin = 88.0f;
    private static final Rect rect = new Rect();
    private float buildFade;
    private float unitFade;
    private Sized lastSelect;
    private Seq<CoreEdge> cedges = new Seq();
    private boolean updatedCores;

    public OverlayRenderer() {
        Events.on(EventType.WorldLoadEvent.class, e -> {
            this.updatedCores = true;
        });
        Events.on(EventType.CoreChangeEvent.class, e -> {
            this.updatedCores = true;
        });
    }

    private void updateCoreEdges() {
        if (!this.updatedCores) {
            return;
        }
        this.updatedCores = false;
        this.cedges.clear();
        Seq<Vec2> pos = new Seq<Vec2>();
        Seq<CoreBlock.CoreBuild> teams = new Seq<CoreBlock.CoreBuild>();
        for (Teams.TeamData team : Vars.state.teams.active) {
            for (CoreBlock.CoreBuild b : team.cores) {
                teams.add(b);
                pos.add(new Vec2(b.x, b.y));
            }
        }
        if (pos.isEmpty()) {
            return;
        }
        Seq<Voronoi.GraphEdge> result = Voronoi.generate((Vec2[])pos.toArray(Vec2.class), 0.0f, Vars.world.unitWidth(), 0.0f, Vars.world.unitHeight());
        for (Voronoi.GraphEdge edge : result) {
            this.cedges.add(new CoreEdge(edge.x1, edge.y1, edge.x2, edge.y2, ((CoreBlock.CoreBuild)teams.get((int)edge.site1)).team, ((CoreBlock.CoreBuild)teams.get((int)edge.site2)).team));
        }
    }

    public void drawBottom() {
        InputHandler input = Vars.control.input;
        if (Vars.player.dead()) {
            return;
        }
        if (Vars.player.isBuilder()) {
            Vars.player.unit().drawBuildPlans();
        }
        input.drawBottom();
    }

    /*
     * Unable to fully structure code
     */
    public void drawTop() {
        block36: {
            if (!Vars.player.dead() && Vars.ui.hudfrag.shown) {
                if (Core.settings.getBool("playerindicators")) {
                    for (Player player : Groups.player) {
                        if (Vars.player == player || Vars.player.team() != player.team() || OverlayRenderer.rect.setSize(Core.camera.width * 0.9f, Core.camera.height * 0.9f).setCenter(Core.camera.position.x, Core.camera.position.y).contains(player.x, player.y)) continue;
                        Tmp.v1.set(player).sub(Vars.player).setLength(14.0f);
                        Lines.stroke(2.0f, Vars.player.team().color);
                        Lines.lineAngle(Vars.player.x + Tmp.v1.x, Vars.player.y + Tmp.v1.y, Tmp.v1.angle(), 4.0f);
                        Draw.reset();
                    }
                }
                if (Core.settings.getBool("indicators") && !Vars.state.rules.fog) {
                    Groups.unit.each((Cons<Unit>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$drawTop$2(mindustry.gen.Unit ), (Lmindustry/gen/Unit;)V)());
                }
            }
            Vars.state.rules.objectives.eachRunning((Cons<MapObjectives.MapObjective>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$drawTop$3(mindustry.game.MapObjectives$MapObjective ), (Lmindustry/game/MapObjectives$MapObjective;)V)());
            if (Vars.player.dead()) {
                return;
            }
            input = Vars.control.input;
            select = input.selectedUnit();
            if (select == null) {
                select = input.selectedControlBuild();
            }
            if (!Core.input.keyDown(Binding.control) || !Vars.state.rules.possessionAllowed) {
                select = null;
            }
            this.unitFade = Mathf.lerpDelta(this.unitFade, Mathf.num(select != null), 0.1f);
            if (select != null) {
                this.lastSelect = select;
            }
            if (select == null) {
                select = this.lastSelect;
            }
            if (select == null || select instanceof Unitc && !(u = (Unitc)select).isAI()) break block36;
            Draw.mixcol(Pal.accent, 1.0f);
            Draw.alpha(this.unitFade);
            if (select instanceof BlockUnitc) {
                b = (BlockUnitc)select;
                v0 = b.tile();
            } else {
                v0 = build = select instanceof Building != false ? (b = (Building)select) : null;
            }
            if (build != null) {
                v1 = build.block.fullIcon;
            } else if (select instanceof Unit) {
                u = select;
                v1 = u.icon();
            } else {
                v1 = Core.atlas.white();
            }
            region = v1;
            v2 = select.getX();
            v3 = select.getY();
            if (!(select instanceof Unit)) ** GOTO lbl-1000
            u = (Unit)select;
            if (!(select instanceof BlockUnitc)) {
                v4 = u.rotation - 90.0f;
            } else lbl-1000:
            // 2 sources

            {
                v4 = 0.0f;
            }
            Draw.rect((TextureRegion)region, v2, v3, v4);
            for (i = 0; i < 4; ++i) {
                rot = (float)i * 90.0f + 45.0f + -Time.time % 360.0f;
                length = select.hitSize() * 1.5f + this.unitFade * 2.5f;
                Draw.rect("select-arrow", select.getX() + Angles.trnsx(rot, length), select.getY() + Angles.trnsy(rot, length), length / 1.9f, length / 1.9f, rot - 135.0f);
            }
            Draw.reset();
        }
        if (input.config.isShown()) {
            tile = input.config.getSelected();
            tile.drawConfigure();
        }
        input.drawTop();
        this.buildFade = Mathf.lerpDelta(this.buildFade, input.isPlacing() != false || input.isUsingSchematic() != false ? 1.0f : 0.0f, 0.06f);
        Draw.reset();
        Lines.stroke(this.buildFade * 2.0f);
        if (this.buildFade > 0.005f) {
            if (Vars.state.rules.polygonCoreProtection) {
                this.updateCoreEdges();
                Draw.color(Pal.accent);
                for (i = 0; i < 2; ++i) {
                    offset = i == 0 ? -2.0f : 0.0f;
                    for (CoreEdge edge : this.cedges) {
                        displayed = edge.displayed();
                        if (displayed == null) continue;
                        Draw.color(i == 0 ? Color.darkGray : Tmp.c1.set(displayed.color).lerp(Pal.accent, Mathf.absin(Time.time, 10.0f, 0.2f)));
                        Lines.line(edge.x1, edge.y1 + offset, edge.x2, edge.y2 + offset);
                    }
                }
                Draw.color();
            } else {
                Vars.state.teams.eachEnemyCore(Vars.player.team(), (Cons<Building>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$drawTop$4(mindustry.gen.Building ), (Lmindustry/gen/Building;)V)());
            }
        }
        Lines.stroke(2.0f);
        Draw.color(Color.gray, Color.lightGray, Mathf.absin(Time.time, 8.0f, 1.0f));
        if (Vars.state.hasSpawns()) {
            for (Tile tile : Vars.spawner.getSpawns()) {
                if (!tile.within(Vars.player.x, Vars.player.y, Vars.state.rules.dropZoneRadius + 88.0f)) continue;
                Draw.alpha(Mathf.clamp(1.0f - (Vars.player.dst(tile) - Vars.state.rules.dropZoneRadius) / 88.0f));
                Lines.dashCircle(tile.worldx(), tile.worldy(), Vars.state.rules.dropZoneRadius);
            }
        }
        Draw.reset();
        if (input.block == null && !Core.scene.hasMouse()) {
            vec = Core.input.mouseWorld(input.getMouseX(), input.getMouseY());
            build = Vars.world.buildWorld(vec.x, vec.y);
            if (build != null && build.team == Vars.player.team()) {
                build.drawSelect();
                if (!build.enabled && build.block.drawDisabled) {
                    build.drawDisabled();
                }
                if (Core.input.keyDown(Binding.rotateplaced) && build.block.rotate && build.block.quickRotate && build.interactable(Vars.player.team())) {
                    Vars.control.input.drawArrow(build.block, build.tileX(), build.tileY(), build.rotation, true);
                    Draw.color(Pal.accent, 0.3f + Mathf.absin(4.0f, 0.2f));
                    Fill.square(build.x, build.y, (float)(build.block.size * 8) / 2.0f);
                    Draw.color();
                }
            }
        }
        input.drawOverSelect();
        region = Vars.ui.hudfrag.blockfrag.hover();
        if (region instanceof Unit && (region = (unit = (Unit)region).controller()) instanceof LogicAI) {
            ai = (LogicAI)region;
            if (ai.controller != null && ai.controller.isValid()) {
                build = ai.controller;
                Drawf.square(build.x, build.y, (float)(build.block.size * 8) / 2.0f + 2.0f);
                if (!unit.within(build, unit.hitSize * 2.0f)) {
                    Drawf.arrow(unit.x, unit.y, build.x, build.y, unit.hitSize * 2.0f, 4.0f);
                }
            }
        }
        if (input.isDroppingItem()) {
            v = Core.input.mouseWorld(input.getMouseX(), input.getMouseY());
            size = 8.0f;
            Draw.rect(Vars.player.unit().item().fullIcon, v.x, v.y, size, size);
            Draw.color(Pal.accent);
            Lines.circle(v.x, v.y, 6.0f + Mathf.absin(Time.time, 5.0f, 1.0f));
            Draw.reset();
            build = Vars.world.buildWorld(v.x, v.y);
            if (input.canDropItem() && build != null && build.interactable(Vars.player.team()) && build.acceptStack(Vars.player.unit().item(), Vars.player.unit().stack.amount, Vars.player.unit()) > 0 && Vars.player.within(build, 220.0f)) {
                invalid = Vars.state.rules.onlyDepositCore != false && build instanceof CoreBlock.CoreBuild == false;
                Lines.stroke(3.0f, Pal.gray);
                Lines.square(build.x, build.y, (float)(build.block.size * 8) / 2.0f + 3.0f + Mathf.absin(Time.time, 5.0f, 1.0f));
                Lines.stroke(1.0f, invalid != false ? Pal.remove : Pal.place);
                Lines.square(build.x, build.y, (float)(build.block.size * 8) / 2.0f + 2.0f + Mathf.absin(Time.time, 5.0f, 1.0f));
                Draw.reset();
                if (invalid) {
                    build.block.drawPlaceText(Core.bundle.get("bar.onlycoredeposit"), build.tileX(), build.tileY(), false);
                }
            }
        }
    }

    private static /* synthetic */ void lambda$drawTop$4(Building core) {
        if (Core.camera.bounds(Tmp.r1).overlaps(Tmp.r2.setCentered(core.x, core.y, Vars.state.rules.enemyCoreBuildRadius * 2.0f))) {
            Draw.color(Color.darkGray);
            Lines.circle(core.x, core.y - 2.0f, Vars.state.rules.enemyCoreBuildRadius);
            Draw.color(Pal.accent, core.team.color, 0.5f + Mathf.absin(Time.time, 10.0f, 0.5f));
            Lines.circle(core.x, core.y, Vars.state.rules.enemyCoreBuildRadius);
        }
    }

    private static /* synthetic */ void lambda$drawTop$3(MapObjectives.MapObjective obj) {
        for (MapObjectives.ObjectiveMarker marker : obj.markers) {
            marker.draw();
        }
    }

    private static /* synthetic */ void lambda$drawTop$2(Unit unit) {
        if (!unit.isLocal() && unit.team != Vars.player.team() && !rect.setSize(Core.camera.width * 0.9f, Core.camera.height * 0.9f).setCenter(Core.camera.position.x, Core.camera.position.y).contains(unit.x, unit.y)) {
            Tmp.v1.set(unit.x, unit.y).sub(Vars.player).setLength(14.0f);
            Lines.stroke(1.0f, unit.team().color);
            Lines.lineAngle(Vars.player.x + Tmp.v1.x, Vars.player.y + Tmp.v1.y, Tmp.v1.angle(), 3.0f);
            Draw.reset();
        }
    }

    private static class CoreEdge {
        float x1;
        float y1;
        float x2;
        float y2;
        Team t1;
        Team t2;

        public CoreEdge(float x1, float y1, float x2, float y2, Team t1, Team t2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.t1 = t1;
            this.t2 = t2;
        }

        @Nullable
        Team displayed() {
            return this.t1 == this.t2 ? null : (this.t1 == Vars.player.team() ? this.t2 : (this.t2 == Vars.player.team() ? this.t1 : (this.t2.id == 0 ? this.t1 : (this.t1.id < this.t2.id && this.t1.id != 0 ? this.t1 : this.t2))));
        }
    }
}

