/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics.g3d;

import arc.graphics.Mesh;
import arc.graphics.gl.Shader;
import arc.math.geom.Mat3D;
import mindustry.graphics.g3d.GenericMesh;
import mindustry.graphics.g3d.PlanetParams;
import mindustry.type.Planet;

public abstract class PlanetMesh
implements GenericMesh {
    protected Mesh mesh;
    protected Planet planet;
    protected Shader shader;

    public PlanetMesh(Planet planet, Mesh mesh, Shader shader) {
        this.planet = planet;
        this.mesh = mesh;
        this.shader = shader;
    }

    public PlanetMesh() {
    }

    public void preRender(PlanetParams params) {
    }

    @Override
    public void render(PlanetParams params, Mat3D projection, Mat3D transform) {
        this.preRender(params);
        this.shader.bind();
        this.shader.setUniformMatrix4("u_proj", projection.val);
        this.shader.setUniformMatrix4("u_trans", transform.val);
        this.shader.apply();
        this.mesh.render(this.shader, 4);
    }
}

